/*
 * Decompiled with CFR 0.152.
 */
package mindustry.input;

import arc.Core;
import arc.Events;
import arc.Graphics;
import arc.KeyBinds;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.input.KeyCode;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.Group;
import arc.scene.style.Drawable;
import arc.scene.ui.layout.Table;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import java.util.Iterator;
import mindustry.Vars;
import mindustry.core.World;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.game.Schematic;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Icon;
import mindustry.gen.Mechc;
import mindustry.gen.Payloadc;
import mindustry.gen.Player;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.input.InputHandler;
import mindustry.input.PlaceMode;
import mindustry.ui.Styles;
import mindustry.world.Tile;

public class DesktopInput
extends InputHandler {
    public Vec2 movement = new Vec2();
    public Graphics.Cursor cursorType = Graphics.Cursor.SystemCursor.arrow;
    public int selectX = -1;
    public int selectY = -1;
    public int schemX = -1;
    public int schemY = -1;
    public int lastLineX;
    public int lastLineY;
    public int schematicX;
    public int schematicY;
    public PlaceMode mode;
    public float selectScale;
    @Nullable
    public BuildPlan splan;
    public boolean deleting = false;
    public boolean shouldShoot = false;
    public boolean panning = false;
    public float panScale = 0.005f;
    public float panSpeed = 4.5f;
    public float panBoostSpeed = 15.0f;
    public long selectMillis = 0L;
    public Tile prevSelected;

    boolean showHint() {
        return Vars.ui.hudfrag.shown && Core.settings.getBool("hints") && this.selectPlans.isEmpty() && (!this.isBuilding && !Core.settings.getBool("buildautopause") || Vars.player.unit().isBuilding() || !Vars.player.dead() && !Vars.player.unit().spawnedByCore());
    }

    @Override
    public void buildUI(Group group) {
        group.fill(t -> {
            t.color.a = 0.0f;
            t.visible(() -> {
                float f;
                t.color.a = Mathf.lerpDelta(t.color.a, Mathf.num(this.showHint()), 0.15f);
                return f > 0.001f;
            });
            t.bottom();
            t.table(Styles.black6, b -> {
                StringBuilder str = new StringBuilder();
                b.defaults().left();
                b.label(() -> {
                    if (!this.showHint()) {
                        return str;
                    }
                    str.setLength(0);
                    if (!(this.isBuilding || Core.settings.getBool("buildautopause") || Vars.player.unit().isBuilding())) {
                        str.append(Core.bundle.format("enablebuilding", Core.keybinds.get((KeyBinds.KeyBind)Binding.pause_building).key.toString()));
                    } else if (Vars.player.unit().isBuilding()) {
                        str.append(Core.bundle.format(this.isBuilding ? "pausebuilding" : "resumebuilding", Core.keybinds.get((KeyBinds.KeyBind)Binding.pause_building).key.toString())).append("\n").append(Core.bundle.format("cancelbuilding", Core.keybinds.get((KeyBinds.KeyBind)Binding.clear_building).key.toString())).append("\n").append(Core.bundle.format("selectschematic", Core.keybinds.get((KeyBinds.KeyBind)Binding.schematic_select).key.toString()));
                    }
                    if (!Vars.player.dead() && !Vars.player.unit().spawnedByCore()) {
                        str.append(str.length() != 0 ? "\n" : "").append(Core.bundle.format("respawn", Core.keybinds.get((KeyBinds.KeyBind)Binding.respawn).key.toString()));
                    }
                    return str;
                }).style(Styles.outlineLabel);
            }).margin(10.0f);
        });
        group.fill(t -> {
            t.visible(() -> Vars.ui.hudfrag.shown && this.lastSchematic != null && !this.selectPlans.isEmpty());
            t.bottom();
            t.table(Styles.black6, b -> {
                b.defaults().left();
                b.label(() -> Core.bundle.format("schematic.flip", Core.keybinds.get((KeyBinds.KeyBind)Binding.schematic_flip_x).key.toString(), Core.keybinds.get((KeyBinds.KeyBind)Binding.schematic_flip_y).key.toString())).style(Styles.outlineLabel).visible(() -> Core.settings.getBool("hints"));
                b.row();
                b.table(a -> a.button("@schematic.add", Icon.save, this::showSchematicSave).colspan(2).size(250.0f, 50.0f).disabled(f -> this.lastSchematic == null || this.lastSchematic.file != null));
            }).margin(6.0f);
        });
    }

    @Override
    public void drawTop() {
        Lines.stroke(1.0f);
        int cursorX = this.tileX(Core.input.mouseX());
        int cursorY = this.tileY(Core.input.mouseY());
        if (this.mode == PlaceMode.breaking) {
            this.drawBreakSelection(this.selectX, this.selectY, cursorX, cursorY, !Core.input.keyDown(Binding.schematic_select) ? 100 : Vars.maxSchematicSize);
        }
        if (!Core.scene.hasKeyboard() && this.mode != PlaceMode.breaking) {
            if (Core.input.keyDown(Binding.schematic_select)) {
                this.drawSelection(this.schemX, this.schemY, cursorX, cursorY, Vars.maxSchematicSize);
            } else if (Core.input.keyDown(Binding.rebuild_select)) {
                this.drawRebuildSelection(this.schemX, this.schemY, cursorX, cursorY);
            }
        }
        this.drawCommanded();
        Draw.reset();
    }

    @Override
    public void drawBottom() {
        BuildPlan plan;
        int i;
        BuildPlan plan2;
        int cursorX = this.tileX(Core.input.mouseX());
        int cursorY = this.tileY(Core.input.mouseY());
        if (this.splan != null) {
            boolean valid = this.validPlace(this.splan.x, this.splan.y, this.splan.block, this.splan.rotation, this.splan);
            if (this.splan.block.rotate && this.splan.block.drawArrow) {
                this.drawArrow(this.splan.block, this.splan.x, this.splan.y, this.splan.rotation, valid);
            }
            this.splan.block.drawPlan(this.splan, this.allPlans(), valid);
            this.drawSelected(this.splan.x, this.splan.y, this.splan.block, this.getPlan(this.splan.x, this.splan.y, this.splan.block.size, this.splan) != null ? Pal.remove : Pal.accent);
        }
        if (this.mode == PlaceMode.none && !this.isPlacing() && (plan2 = this.getPlan(cursorX, cursorY)) != null) {
            this.drawSelected(plan2.x, plan2.y, plan2.breaking ? plan2.tile().block() : plan2.block, Pal.accent);
        }
        BuildPlan[] items = (BuildPlan[])this.selectPlans.items;
        int size = this.selectPlans.size;
        for (i = 0; i < size; ++i) {
            plan = items[i];
            plan.animScale = 1.0f;
            this.drawPlan(plan);
        }
        for (i = 0; i < size; ++i) {
            plan = items[i];
            this.drawOverPlan(plan, plan.cachedValid);
        }
        if (Vars.player.isBuilder()) {
            if (this.mode == PlaceMode.placing && this.block != null) {
                for (i = 0; i < this.linePlans.size; ++i) {
                    plan = (BuildPlan)this.linePlans.get(i);
                    if (i == this.linePlans.size - 1 && plan.block.rotate && plan.block.drawArrow) {
                        this.drawArrow(this.block, plan.x, plan.y, plan.rotation);
                    }
                    this.drawPlan((BuildPlan)this.linePlans.get(i));
                }
                this.linePlans.each(this::drawOverPlan);
            } else if (this.isPlacing()) {
                int rot;
                int n = rot = this.block == null ? this.rotation : this.block.planRotation(this.rotation);
                if (this.block.rotate && this.block.drawArrow) {
                    this.drawArrow(this.block, cursorX, cursorY, rot);
                }
                Draw.color();
                boolean valid = this.validPlace(cursorX, cursorY, this.block, rot);
                this.drawPlan(cursorX, cursorY, this.block, rot);
                this.block.drawPlace(cursorX, cursorY, rot, valid);
                if (this.block.saveConfig) {
                    Draw.mixcol(!valid ? Pal.breakInvalid : Color.white, (!valid ? 0.4f : 0.24f) + Mathf.absin(Time.globalTime, 6.0f, 0.28f));
                    this.bplan.set(cursorX, cursorY, rot, this.block);
                    this.bplan.config = this.block.lastConfig;
                    this.block.drawPlanConfig(this.bplan, this.allPlans());
                    this.bplan.config = null;
                    Draw.reset();
                }
                this.drawOverlapCheck(this.block, cursorX, cursorY, valid);
            }
        }
        Draw.reset();
    }

    @Override
    public void update() {
        Tile cursor;
        Tile selected;
        super.update();
        if (Vars.net.active() && Core.input.keyTap(Binding.player_list) && (Core.scene.getKeyboardFocus() == null || Core.scene.getKeyboardFocus().isDescendantOf(Vars.ui.listfrag.content) || Core.scene.getKeyboardFocus().isDescendantOf(Vars.ui.minimapfrag.elem))) {
            Vars.ui.listfrag.toggle();
        }
        boolean locked = this.locked();
        boolean panCam = false;
        float camSpeed = (!Core.input.keyDown(Binding.boost) ? this.panSpeed : this.panBoostSpeed) * Time.delta;
        if (Core.input.keyDown(Binding.pan) && !Core.scene.hasField() && !Core.scene.hasDialog()) {
            panCam = true;
            this.panning = true;
        }
        if ((Math.abs(Core.input.axis(Binding.move_x)) > 0.0f || Math.abs(Core.input.axis(Binding.move_y)) > 0.0f || Core.input.keyDown(Binding.mouse_move)) && !Core.scene.hasField()) {
            this.panning = false;
        }
        if (!locked) {
            if (!(!Vars.player.dead() && !Vars.state.isPaused() || Vars.ui.chatfrag.shown() || Core.scene.hasField() || Core.scene.hasDialog())) {
                if (Core.input.keyDown(Binding.mouse_move)) {
                    panCam = true;
                }
                Core.camera.position.add(Tmp.v1.setZero().add(Core.input.axis(Binding.move_x), Core.input.axis(Binding.move_y)).nor().scl(camSpeed));
            } else if (!Vars.player.dead() && !this.panning) {
                Iterator<Building> corePanTeam = Vars.state.won ? Vars.state.rules.waveTeam : Vars.player.team();
                Player coreTarget = Vars.state.gameOver && !Vars.state.rules.pvp && ((Team)((Object)corePanTeam)).data().lastCore != null ? ((Team)((Object)corePanTeam)).data().lastCore : null;
                Core.camera.position.lerpDelta(coreTarget != null ? coreTarget : Vars.player, Core.settings.getBool("smoothcamera") ? 0.08f : 1.0f);
            }
            if (panCam) {
                Core.camera.position.x += Mathf.clamp(((float)Core.input.mouseX() - (float)Core.graphics.getWidth() / 2.0f) * this.panScale, -1.0f, 1.0f) * camSpeed;
                Core.camera.position.y += Mathf.clamp(((float)Core.input.mouseY() - (float)Core.graphics.getHeight() / 2.0f) * this.panScale, -1.0f, 1.0f) * camSpeed;
            }
        }
        boolean bl = this.shouldShoot = !Core.scene.hasMouse() && !locked;
        if (!(locked || this.block != null || Core.scene.hasField() || Core.scene.hasDialog() || !Vars.player.dead() && Vars.player.unit().type.canBoost && Core.keybinds.get((KeyBinds.KeyBind)Binding.command_mode).key == Core.keybinds.get((KeyBinds.KeyBind)Binding.boost).key)) {
            if (Core.settings.getBool("commandmodehold")) {
                this.commandMode = Core.input.keyDown(Binding.command_mode);
            } else if (Core.input.keyTap(Binding.command_mode)) {
                this.commandMode = !this.commandMode;
            }
        } else {
            this.commandMode = false;
        }
        this.selectedUnits.removeAll(u -> !u.isCommandable() || !u.isValid());
        if (this.commandMode && Core.input.keyTap(Binding.select_all_units) && !Core.scene.hasField() && !Core.scene.hasDialog()) {
            this.selectedUnits.clear();
            this.commandBuildings.clear();
            for (Unit unit : Vars.player.team().data().units) {
                if (!unit.isCommandable()) continue;
                this.selectedUnits.add(unit);
            }
        }
        if (this.commandMode && Core.input.keyTap(Binding.select_all_unit_factories) && !Core.scene.hasField() && !Core.scene.hasDialog()) {
            this.selectedUnits.clear();
            this.commandBuildings.clear();
            for (Building build : Vars.player.team().data().buildings) {
                if (!build.block.commandable) continue;
                this.commandBuildings.add(build);
            }
        }
        if (!Core.scene.hasMouse() && !locked && Vars.state.rules.possessionAllowed && Core.input.keyDown(Binding.control) && Core.input.keyTap(Binding.select)) {
            Building build;
            Unit on = this.selectedUnit();
            build = this.selectedControlBuild();
            if (on != null) {
                Call.unitControl(Vars.player, on);
                this.shouldShoot = false;
                this.recentRespawnTimer = 1.0f;
            } else if (build != null) {
                Call.buildingControlSelect(Vars.player, build);
                this.recentRespawnTimer = 1.0f;
            }
        }
        if (!(Vars.player.dead() || Vars.state.isPaused() || Core.scene.hasField() || locked)) {
            this.updateMovement(Vars.player.unit());
            if (Core.input.keyTap(Binding.respawn)) {
                this.controlledType = null;
                this.recentRespawnTimer = 1.0f;
                Call.unitClear(Vars.player);
            }
        }
        if (Core.input.keyRelease(Binding.select)) {
            Vars.player.shooting = false;
        }
        if (Vars.state.isGame() && !Core.scene.hasDialog() && !Core.scene.hasField()) {
            if (Core.input.keyTap(Binding.minimap)) {
                Vars.ui.minimapfrag.toggle();
            }
            if (Core.input.keyTap(Binding.planet_map) && Vars.state.isCampaign()) {
                Vars.ui.planet.toggle();
            }
            if (Core.input.keyTap(Binding.research) && Vars.state.isCampaign()) {
                Vars.ui.research.toggle();
            }
        }
        if (Vars.state.isMenu() || Core.scene.hasDialog()) {
            return;
        }
        if (!(Core.scene.hasScroll() && !Core.input.keyDown(Binding.diagonal_placement) || Vars.ui.chatfrag.shown() || Vars.ui.consolefrag.shown() || !(Math.abs(Core.input.axisTap(Binding.zoom)) > 0.0f) || Core.input.keyDown(Binding.rotateplaced) || !Core.input.keyDown(Binding.diagonal_placement) && Core.keybinds.get(Binding.zoom).equals(Core.keybinds.get(Binding.rotate)) && (Vars.player.isBuilder() && this.isPlacing() && this.block.rotate || !this.selectPlans.isEmpty()))) {
            Vars.renderer.scaleCamera(Core.input.axisTap(Binding.zoom));
        }
        if (Core.input.keyTap(Binding.select) && !Core.scene.hasMouse() && (selected = Vars.world.tileWorld(Core.input.mouseWorldX(), Core.input.mouseWorldY())) != null) {
            Call.tileTap(Vars.player, selected);
        }
        if (Vars.player.dead() || locked) {
            this.cursorType = Graphics.Cursor.SystemCursor.arrow;
            if (!Core.scene.hasMouse()) {
                Core.graphics.cursor(this.cursorType);
            }
            return;
        }
        this.pollInput();
        if (!this.isPlacing() && this.mode == PlaceMode.placing) {
            this.mode = PlaceMode.none;
        }
        if (Vars.player.shooting && !this.canShoot()) {
            Vars.player.shooting = false;
        }
        if (this.isPlacing() && Vars.player.isBuilder()) {
            this.cursorType = Graphics.Cursor.SystemCursor.hand;
            this.selectScale = Mathf.lerpDelta(this.selectScale, 1.0f, 0.2f);
        } else {
            this.selectScale = 0.0f;
        }
        if (!Core.input.keyDown(Binding.diagonal_placement) && Math.abs((int)Core.input.axisTap(Binding.rotate)) > 0) {
            this.rotation = Mathf.mod(this.rotation + (int)Core.input.axisTap(Binding.rotate), 4);
            if (this.splan != null) {
                this.splan.rotation = Mathf.mod(this.splan.rotation + (int)Core.input.axisTap(Binding.rotate), 4);
            }
            if (this.isPlacing() && this.mode == PlaceMode.placing) {
                this.updateLine(this.selectX, this.selectY);
            } else if (!this.selectPlans.isEmpty() && !Vars.ui.chatfrag.shown()) {
                this.rotatePlans(this.selectPlans, Mathf.sign(Core.input.axisTap(Binding.rotate)));
            }
        }
        if ((cursor = this.tileAt(Core.input.mouseX(), Core.input.mouseY())) != null) {
            if (cursor.build != null) {
                this.cursorType = cursor.build.getCursor();
            }
            if (this.isPlacing() && Vars.player.isBuilder() || !this.selectPlans.isEmpty()) {
                this.cursorType = Graphics.Cursor.SystemCursor.hand;
            }
            if (!this.isPlacing() && this.canMine(cursor)) {
                this.cursorType = Vars.ui.drillCursor;
            }
            if (this.commandMode && this.selectedUnits.any() && (cursor.build != null && !cursor.build.inFogTo(Vars.player.team()) && cursor.build.team != Vars.player.team() || this.selectedEnemyUnit(Core.input.mouseWorldX(), Core.input.mouseWorldY()) != null)) {
                this.cursorType = Vars.ui.targetCursor;
            }
            if (this.getPlan(cursor.x, cursor.y) != null && this.mode == PlaceMode.none) {
                this.cursorType = Graphics.Cursor.SystemCursor.hand;
            }
            if (this.canTapPlayer(Core.input.mouseWorld().x, Core.input.mouseWorld().y)) {
                this.cursorType = Vars.ui.unloadCursor;
            }
            if (cursor.build != null && cursor.interactable(Vars.player.team()) && !this.isPlacing() && Math.abs(Core.input.axisTap(Binding.rotate)) > 0.0f && Core.input.keyDown(Binding.rotateplaced) && cursor.block().rotate && cursor.block().quickRotate) {
                Call.rotateBlock(Vars.player, cursor.build, Core.input.axisTap(Binding.rotate) > 0.0f);
            }
        }
        if (!Core.scene.hasMouse()) {
            Core.graphics.cursor(this.cursorType);
        }
        this.cursorType = Graphics.Cursor.SystemCursor.arrow;
    }

    @Override
    public void useSchematic(Schematic schem) {
        this.block = null;
        this.schematicX = this.tileX(this.getMouseX());
        this.schematicY = this.tileY(this.getMouseY());
        this.selectPlans.clear();
        this.selectPlans.addAll(Vars.schematics.toPlans(schem, this.schematicX, this.schematicY));
        this.mode = PlaceMode.none;
    }

    @Override
    public boolean isBreaking() {
        return this.mode == PlaceMode.breaking;
    }

    @Override
    public void buildPlacementUI(Table table) {
        table.image().color(Pal.gray).height(4.0f).colspan(4).growX();
        table.row();
        table.left().margin(0.0f).defaults().size(48.0f).left();
        table.button((Drawable)Icon.paste, Styles.clearNonei, () -> Vars.ui.schematics.show()).tooltip("@schematics");
        table.button((Drawable)Icon.book, Styles.clearNonei, () -> Vars.ui.database.show()).tooltip("@database");
        table.button((Drawable)Icon.tree, Styles.clearNonei, () -> Vars.ui.research.show()).visible(() -> Vars.state.isCampaign()).tooltip("@research");
        table.button((Drawable)Icon.map, Styles.clearNonei, () -> Vars.ui.planet.show()).visible(() -> Vars.state.isCampaign()).tooltip("@planetmap");
    }

    void pollInput() {
        if (Core.scene.hasField()) {
            return;
        }
        Tile selected = this.tileAt(Core.input.mouseX(), Core.input.mouseY());
        int cursorX = this.tileX(Core.input.mouseX());
        int cursorY = this.tileY(Core.input.mouseY());
        int rawCursorX = World.toTile(Core.input.mouseWorld().x);
        int rawCursorY = World.toTile(Core.input.mouseWorld().y);
        if (Core.settings.getBool("buildautopause") && this.isBuilding && !Vars.player.unit().isBuilding()) {
            this.isBuilding = false;
            this.buildWasAutoPaused = true;
        }
        if (!this.selectPlans.isEmpty()) {
            int shiftX = rawCursorX - this.schematicX;
            int shiftY = rawCursorY - this.schematicY;
            this.selectPlans.each(s -> {
                s.x += shiftX;
                s.y += shiftY;
            });
            this.schematicX += shiftX;
            this.schematicY += shiftY;
        }
        if (Core.input.keyTap(Binding.deselect) && !this.isPlacing() && Vars.player.unit().plans.isEmpty() && !this.commandMode) {
            Vars.player.unit().mineTile = null;
        }
        if (Core.input.keyTap(Binding.clear_building)) {
            Vars.player.unit().clearBuilding();
        }
        if ((Core.input.keyTap(Binding.schematic_select) || Core.input.keyTap(Binding.rebuild_select)) && !Core.scene.hasKeyboard() && this.mode != PlaceMode.breaking) {
            this.schemX = rawCursorX;
            this.schemY = rawCursorY;
        }
        if (Core.input.keyTap(Binding.schematic_menu) && !Core.scene.hasKeyboard()) {
            if (Vars.ui.schematics.isShown()) {
                Vars.ui.schematics.hide();
            } else {
                Vars.ui.schematics.show();
            }
        }
        if (Core.input.keyTap(Binding.clear_building) || this.isPlacing()) {
            this.lastSchematic = null;
            this.selectPlans.clear();
        }
        if (!Core.scene.hasKeyboard() && this.selectX == -1 && this.selectY == -1 && this.schemX != -1 && this.schemY != -1) {
            if (Core.input.keyRelease(Binding.schematic_select)) {
                this.lastSchematic = Vars.schematics.create(this.schemX, this.schemY, rawCursorX, rawCursorY);
                this.useSchematic(this.lastSchematic);
                if (this.selectPlans.isEmpty()) {
                    this.lastSchematic = null;
                }
                this.schemX = -1;
                this.schemY = -1;
            } else if (Core.input.keyRelease(Binding.rebuild_select)) {
                this.rebuildArea(this.schemX, this.schemY, rawCursorX, rawCursorY);
                this.schemX = -1;
                this.schemY = -1;
            }
        }
        if (!this.selectPlans.isEmpty()) {
            if (Core.input.keyTap(Binding.schematic_flip_x)) {
                this.flipPlans(this.selectPlans, true);
            }
            if (Core.input.keyTap(Binding.schematic_flip_y)) {
                this.flipPlans(this.selectPlans, false);
            }
        }
        if (this.splan != null) {
            float offset = (float)((this.splan.block.size + 2) % 2 * 8) / 2.0f;
            float x = Core.input.mouseWorld().x + offset;
            float y = Core.input.mouseWorld().y + offset;
            this.splan.x = (int)(x / 8.0f);
            this.splan.y = (int)(y / 8.0f);
        }
        if (this.block == null || this.mode != PlaceMode.placing) {
            this.linePlans.clear();
        }
        if (Core.input.keyTap(Binding.pause_building)) {
            this.isBuilding = !this.isBuilding;
            this.buildWasAutoPaused = false;
            if (this.isBuilding) {
                Vars.player.shooting = false;
            }
        }
        if ((cursorX != this.lastLineX || cursorY != this.lastLineY) && this.isPlacing() && this.mode == PlaceMode.placing) {
            this.updateLine(this.selectX, this.selectY);
            this.lastLineX = cursorX;
            this.lastLineY = cursorY;
        }
        if (Core.input.keyRelease(Binding.select) && this.commandRect) {
            this.selectUnitsRect();
        }
        if (Core.input.keyTap(Binding.select) && !Core.scene.hasMouse()) {
            this.tappedOne = false;
            BuildPlan plan = this.getPlan(cursorX, cursorY);
            if (Core.input.keyDown(Binding.break_block)) {
                this.mode = PlaceMode.none;
            } else if (!this.selectPlans.isEmpty()) {
                this.flushPlans(this.selectPlans);
            } else if (this.isPlacing()) {
                this.selectX = cursorX;
                this.selectY = cursorY;
                this.lastLineX = cursorX;
                this.lastLineY = cursorY;
                this.mode = PlaceMode.placing;
                this.updateLine(this.selectX, this.selectY);
            } else if (plan != null && !plan.breaking && this.mode == PlaceMode.none && !plan.initialized) {
                this.splan = plan;
            } else if (plan != null && plan.breaking) {
                this.deleting = true;
            } else if (this.commandMode) {
                this.commandRect = true;
                this.commandRectX = Core.input.mouseWorldX();
                this.commandRectY = Core.input.mouseWorldY();
            } else if (!this.checkConfigTap() && selected != null) {
                if (!(this.tryTapPlayer(Core.input.mouseWorld().x, Core.input.mouseWorld().y) || this.tileTapped(selected.build) || Vars.player.unit().activelyBuilding() || this.droppingItem || this.tryStopMine(selected) || (!Core.settings.getBool("doubletapmine") || selected == this.prevSelected && Time.timeSinceMillis(this.selectMillis) < 500L) && this.tryBeginMine(selected) || Core.scene.hasKeyboard())) {
                    Vars.player.shooting = this.shouldShoot;
                }
            } else if (!Core.scene.hasKeyboard()) {
                Vars.player.shooting = this.shouldShoot;
            }
            this.selectMillis = Time.millis();
            this.prevSelected = selected;
        } else if (Core.input.keyTap(Binding.deselect) && this.isPlacing()) {
            this.block = null;
            this.mode = PlaceMode.none;
        } else if (Core.input.keyTap(Binding.deselect) && !this.selectPlans.isEmpty()) {
            this.selectPlans.clear();
            this.lastSchematic = null;
        } else if (Core.input.keyTap(Binding.break_block) && !Core.scene.hasMouse() && Vars.player.isBuilder() && !this.commandMode) {
            this.deleting = false;
            this.mode = PlaceMode.breaking;
            this.selectX = this.tileX(Core.input.mouseX());
            this.selectY = this.tileY(Core.input.mouseY());
            this.schemX = rawCursorX;
            this.schemY = rawCursorY;
        }
        if (Core.input.keyDown(Binding.select) && this.mode == PlaceMode.none && !this.isPlacing() && this.deleting) {
            BuildPlan plan = this.getPlan(cursorX, cursorY);
            if (plan != null && plan.breaking) {
                Vars.player.unit().plans().remove(plan);
            }
        } else {
            this.deleting = false;
        }
        if (this.mode == PlaceMode.placing && this.block != null) {
            if (!(this.overrideLineRotation || Core.input.keyDown(Binding.diagonal_placement) || this.selectX == cursorX && this.selectY == cursorY || (int)Core.input.axisTap(Binding.rotate) == 0)) {
                this.rotation = (int)((Angles.angle(this.selectX, this.selectY, cursorX, cursorY) + 45.0f) / 90.0f) % 4;
                this.overrideLineRotation = true;
            }
        } else {
            this.overrideLineRotation = false;
        }
        if (Core.input.keyRelease(Binding.break_block) && Core.input.keyDown(Binding.schematic_select) && this.mode == PlaceMode.breaking) {
            this.lastSchematic = Vars.schematics.create(this.schemX, this.schemY, rawCursorX, rawCursorY);
            this.schemX = -1;
            this.schemY = -1;
        }
        if (Core.input.keyRelease(Binding.break_block) || Core.input.keyRelease(Binding.select)) {
            if (this.mode == PlaceMode.placing && this.block != null) {
                if (Core.input.keyDown(Binding.boost)) {
                    this.flushPlansReverse(this.linePlans);
                } else {
                    this.flushPlans(this.linePlans);
                }
                this.linePlans.clear();
                Events.fire(new EventType.LineConfirmEvent());
            } else if (this.mode == PlaceMode.breaking) {
                this.removeSelection(this.selectX, this.selectY, cursorX, cursorY, !Core.input.keyDown(Binding.schematic_select) ? 100 : Vars.maxSchematicSize);
                if (this.lastSchematic != null) {
                    this.useSchematic(this.lastSchematic);
                    this.lastSchematic = null;
                }
            }
            this.selectX = -1;
            this.selectY = -1;
            this.tryDropItems(selected == null ? null : selected.build, Core.input.mouseWorld().x, Core.input.mouseWorld().y);
            if (this.splan != null) {
                if (this.getPlan(this.splan.x, this.splan.y, this.splan.block.size, this.splan) != null) {
                    Vars.player.unit().plans().remove(this.splan, true);
                }
                this.splan = null;
            }
            this.mode = PlaceMode.none;
        }
        if (Core.input.keyTap(Binding.toggle_block_status)) {
            Core.settings.put("blockstatus", !Core.settings.getBool("blockstatus"));
        }
        if (Core.input.keyTap(Binding.toggle_power_lines)) {
            if (Core.settings.getInt("lasersopacity") == 0) {
                Core.settings.put("lasersopacity", Core.settings.getInt("preferredlaseropacity", 100));
            } else {
                Core.settings.put("preferredlaseropacity", Core.settings.getInt("lasersopacity"));
                Core.settings.put("lasersopacity", 0);
            }
        }
    }

    @Override
    public boolean tap(float x, float y, int count, KeyCode button) {
        if (Core.scene.hasMouse() || !this.commandMode) {
            return false;
        }
        this.tappedOne = true;
        if (button == KeyCode.mouseLeft) {
            if (count >= 2) {
                this.selectTypedUnits();
            } else {
                this.tapCommandUnit();
            }
        }
        return super.tap(x, y, count, button);
    }

    @Override
    public boolean touchDown(float x, float y, int pointer, KeyCode button) {
        if (Core.scene.hasMouse() || !this.commandMode) {
            return false;
        }
        if (button == KeyCode.mouseRight) {
            this.commandTap(x, y);
        }
        return super.touchDown(x, y, pointer, button);
    }

    @Override
    public boolean selectedBlock() {
        return this.isPlacing() && this.mode != PlaceMode.breaking;
    }

    @Override
    public float getMouseX() {
        return Core.input.mouseX();
    }

    @Override
    public float getMouseY() {
        return Core.input.mouseY();
    }

    @Override
    public void updateState() {
        super.updateState();
        if (Vars.state.isMenu()) {
            this.lastSchematic = null;
            this.droppingItem = false;
            this.mode = PlaceMode.none;
            this.block = null;
            this.splan = null;
            this.selectPlans.clear();
        }
    }

    @Override
    public void panCamera(Vec2 position) {
        if (!this.locked()) {
            this.panning = true;
            Core.camera.position.set(position);
        }
    }

    protected void updateMovement(Unit unit) {
        boolean aimCursor;
        boolean omni = unit.type.omniMovement;
        float speed = unit.speed();
        float xa = Core.input.axis(Binding.move_x);
        float ya = Core.input.axis(Binding.move_y);
        boolean boosted = unit instanceof Mechc && unit.isFlying();
        this.movement.set(xa, ya).nor().scl(speed);
        if (Core.input.keyDown(Binding.mouse_move)) {
            this.movement.add(Core.input.mouseWorld().sub(Vars.player).scl(0.04f * speed)).limit(speed);
        }
        float mouseAngle = Angles.mouseAngle(unit.x, unit.y);
        boolean bl = aimCursor = omni && Vars.player.shooting && unit.type.hasWeapons() && unit.type.faceTarget && !boosted;
        if (aimCursor) {
            unit.lookAt(mouseAngle);
        } else {
            unit.lookAt(unit.prefRotation());
        }
        unit.movePref(this.movement);
        unit.aim(Core.input.mouseWorld());
        unit.controlWeapons(true, Vars.player.shooting && !boosted);
        Vars.player.boosting = Core.input.keyDown(Binding.boost);
        Vars.player.mouseX = unit.aimX();
        Vars.player.mouseY = unit.aimY();
        if (unit instanceof Payloadc) {
            if (Core.input.keyTap(Binding.pickupCargo)) {
                this.tryPickupPayload();
            }
            if (Core.input.keyTap(Binding.dropCargo)) {
                this.tryDropPayload();
            }
        }
    }
}

