/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.Core;
import arc.graphics.Color;
import arc.scene.style.Drawable;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;

public class LCategory
implements Comparable<LCategory> {
    public static final Seq<LCategory> all = new Seq();
    public static final LCategory unknown = new LCategory("unknown", Pal.darkishGray);
    public static final LCategory io = new LCategory("io", Pal.logicIo, Icon.logicSmall);
    public static final LCategory block = new LCategory("block", Pal.logicBlocks, Icon.effectSmall);
    public static final LCategory operation = new LCategory("operation", Pal.logicOperations, Icon.settingsSmall);
    public static final LCategory control = new LCategory("control", Pal.logicControl, Icon.rotateSmall);
    public static final LCategory unit = new LCategory("unit", Pal.logicUnits, Icon.unitsSmall);
    public static final LCategory world = new LCategory("world", Pal.logicWorld, Icon.terrainSmall);
    public final String name;
    public final int id;
    public final Color color;
    @Nullable
    public final Drawable icon;

    public LCategory(String name, Color color) {
        this(name, color, null);
    }

    public LCategory(String name, Color color, Drawable icon) {
        this.icon = icon;
        this.color = color;
        this.name = name;
        this.id = LCategory.all.size;
        all.add(this);
    }

    public String localized() {
        return Core.bundle.get("lcategory." + this.name);
    }

    public String description() {
        return Core.bundle.get("lcategory." + this.name + ".description");
    }

    @Override
    public int compareTo(LCategory o) {
        return this.id - o.id;
    }
}

