/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.Core;
import arc.func.Cons;
import arc.func.Cons2;
import arc.math.Interp;
import arc.scene.Element;
import arc.scene.actions.Actions;
import arc.scene.ui.Button;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.Label;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Tmp;
import mindustry.gen.LogicIO;
import mindustry.gen.Tex;
import mindustry.logic.LAssembler;
import mindustry.logic.LCanvas;
import mindustry.logic.LCategory;
import mindustry.logic.LExecutor;
import mindustry.ui.Styles;

public abstract class LStatement {
    @Nullable
    public transient LCanvas.StatementElem elem;

    public abstract void build(Table var1);

    public abstract LExecutor.LInstruction build(LAssembler var1);

    public LCategory category() {
        return LCategory.unknown;
    }

    public LStatement copy() {
        StringBuilder build = new StringBuilder();
        this.write(build);
        Seq<LStatement> read = LAssembler.read(build.toString(), true);
        return read.size == 0 ? null : read.first();
    }

    public boolean hidden() {
        return false;
    }

    public boolean privileged() {
        return false;
    }

    public boolean nonPrivileged() {
        return false;
    }

    protected void param(Cell<Label> label) {
        String text = this.name() + "." + label.get().getText().toString().trim();
        LCanvas.tooltip(label, text);
    }

    protected String sanitize(String value) {
        if (value.length() == 0) {
            return "";
        }
        if (value.length() == 1) {
            if (value.charAt(0) == '\"' || value.charAt(0) == ';' || value.charAt(0) == ' ') {
                return "invalid";
            }
        } else {
            StringBuilder res = new StringBuilder(value.length());
            if (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                res.append('\"');
                for (int i = 1; i < value.length() - 1; ++i) {
                    if (value.charAt(i) == '\"') {
                        res.append('\'');
                        continue;
                    }
                    res.append(value.charAt(i));
                }
                res.append('\"');
            } else {
                for (int i = 0; i < value.length(); ++i) {
                    char c;
                    char c2 = value.charAt(i);
                    switch (c2) {
                        case ';': {
                            c = 's';
                            break;
                        }
                        case '\"': {
                            c = '\'';
                            break;
                        }
                        case ' ': {
                            c = '_';
                            break;
                        }
                        default: {
                            c = c2;
                        }
                    }
                    res.append(c);
                }
            }
            return res.toString();
        }
        return value;
    }

    protected Cell<TextField> field(Table table, String value, Cons<String> setter) {
        return table.field(value, Styles.nodeField, (String s) -> setter.get(this.sanitize((String)s))).size(144.0f, 40.0f).pad(2.0f).color(table.color).maxTextLength(36);
    }

    protected Cell<TextField> fields(Table table, String desc, String value, Cons<String> setter) {
        table.add(desc).padLeft(10.0f).left().self(this::param);
        return this.field(table, value, setter).width(85.0f).padRight(10.0f).left();
    }

    protected Cell<TextField> fields(Table table, String value, Cons<String> setter) {
        return this.field(table, value, setter).width(85.0f);
    }

    protected void row(Table table) {
        if (LCanvas.useRows()) {
            table.row();
        }
    }

    protected <T> void showSelect(Button b, T[] values, T current, Cons<T> getter, int cols, Cons<Cell> sizer) {
        this.showSelectTable(b, (t, hide) -> {
            ButtonGroup group = new ButtonGroup();
            int i = 0;
            t.defaults().size(60.0f, 38.0f);
            for (Object p : values) {
                sizer.get(t.button(p.toString(), Styles.logicTogglet, () -> {
                    getter.get(p);
                    hide.run();
                }).self(c -> {
                    if (p instanceof Enum) {
                        Enum e = (Enum)p;
                        LCanvas.tooltip(c, e);
                    }
                }).checked(current == p).group(group));
                if (++i % cols != 0) continue;
                t.row();
            }
        });
    }

    protected <T> void showSelect(Button b, T[] values, T current, Cons<T> getter) {
        this.showSelect(b, values, current, getter, 4, c -> {});
    }

    protected void showSelectTable(Button b, Cons2<Table, Runnable> hideCons) {
        Table t = new Table(Tex.paneSolid){

            @Override
            public float getPrefHeight() {
                return Math.min(super.getPrefHeight(), (float)Core.graphics.getHeight());
            }

            @Override
            public float getPrefWidth() {
                return Math.min(super.getPrefWidth(), (float)Core.graphics.getWidth());
            }
        };
        t.margin(4.0f);
        Element hitter = new Element();
        Runnable hide = () -> {
            Core.app.post(hitter::remove);
            t.actions(Actions.fadeOut(0.3f, Interp.fade), Actions.remove());
        };
        hitter.fillParent = true;
        hitter.tapped(hide);
        Core.scene.add(hitter);
        Core.scene.add(t);
        t.update(() -> {
            if (b.parent == null || !b.isDescendantOf(Core.scene.root)) {
                Core.app.post(() -> {
                    hitter.remove();
                    t.remove();
                });
                return;
            }
            b.localToStageCoordinates(Tmp.v1.set(b.getWidth() / 2.0f, b.getHeight() / 2.0f));
            t.setPosition(Tmp.v1.x, Tmp.v1.y, 1);
            if (t.getWidth() > Core.scene.getWidth()) {
                t.setWidth(Core.graphics.getWidth());
            }
            if (t.getHeight() > Core.scene.getHeight()) {
                t.setHeight(Core.graphics.getHeight());
            }
            t.keepInStage();
            t.invalidateHierarchy();
            t.pack();
        });
        t.actions(Actions.alpha(0.0f), Actions.fadeIn(0.3f, Interp.fade));
        t.top().pane(inner -> {
            inner.top();
            hideCons.get((Table)inner, hide);
        }).pad(0.0f).top().scrollX(false);
        t.pack();
    }

    public void afterRead() {
    }

    public void write(StringBuilder builder) {
        LogicIO.write(this, builder);
    }

    public void setupUI() {
    }

    public void saveUI() {
    }

    public String name() {
        return Strings.insertSpaces(this.getClass().getSimpleName().replace("Statement", ""));
    }
}

