/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.Core;
import arc.func.Prov;
import arc.graphics.Color;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.Label;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Stack;
import arc.scene.ui.layout.Table;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.ctype.ContentType;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.logic.ConditionOp;
import mindustry.logic.CutsceneAction;
import mindustry.logic.FetchType;
import mindustry.logic.GlobalVars;
import mindustry.logic.LAccess;
import mindustry.logic.LAssembler;
import mindustry.logic.LCanvas;
import mindustry.logic.LCategory;
import mindustry.logic.LExecutor;
import mindustry.logic.LLocate;
import mindustry.logic.LStatement;
import mindustry.logic.LUnitControl;
import mindustry.logic.LogicFx;
import mindustry.logic.LogicOp;
import mindustry.logic.LogicRule;
import mindustry.logic.MessageType;
import mindustry.logic.RadarSort;
import mindustry.logic.RadarTarget;
import mindustry.logic.TileLayer;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.type.UnitType;
import mindustry.ui.Styles;
import mindustry.world.blocks.logic.LogicDisplay;
import mindustry.world.meta.BlockFlag;

public class LStatements {

    public static class SetPropStatement
    extends LStatement {
        public String type = "@copper";
        public String of = "block1";
        public String value = "0";
        private transient int selected = 0;
        private transient TextField tfield;

        @Override
        public void build(Table table) {
            table.add(" set ");
            this.tfield = this.field(table, this.type, str -> {
                this.type = str;
            }).padRight(0.0f).get();
            table.button(b -> {
                b.image(Icon.pencilSmall);
                b.clicked(() -> this.showSelectTable((Button)b, (t, hide) -> {
                    Table[] tables = new Table[]{new Table(i -> {
                        i.left();
                        int c = 0;
                        for (Item item : Vars.content.items()) {
                            if (item.hidden) continue;
                            i.button(new TextureRegionDrawable(item.uiIcon), Styles.flati, 24.0f, () -> {
                                this.stype("@" + item.name);
                                hide.run();
                            }).size(40.0f);
                            if (++c % 6 != 0) continue;
                            i.row();
                        }
                    }), new Table(i -> {
                        i.left();
                        int c = 0;
                        for (Liquid item : Vars.content.liquids()) {
                            if (!item.unlockedNow() || item.hidden) continue;
                            i.button(new TextureRegionDrawable(item.uiIcon), Styles.flati, 24.0f, () -> {
                                this.stype("@" + item.name);
                                hide.run();
                            }).size(40.0f);
                            if (++c % 6 != 0) continue;
                            i.row();
                        }
                    }), new Table(i -> {
                        for (LAccess property : LAccess.settable) {
                            i.button(property.name(), Styles.flatt, () -> {
                                this.stype("@" + property.name());
                                hide.run();
                            }).size(240.0f, 40.0f).self(c -> LCanvas.tooltip(c, property)).row();
                        }
                    })};
                    Drawable[] icons = new Drawable[]{Icon.box, Icon.liquid, Icon.tree};
                    Stack stack = new Stack(tables[this.selected]);
                    ButtonGroup group = new ButtonGroup();
                    for (int i2 = 0; i2 < tables.length; ++i2) {
                        int fi = i2;
                        t.button(icons[i2], Styles.squareTogglei, () -> {
                            this.selected = fi;
                            stack.clearChildren();
                            stack.addChild(tables[this.selected]);
                            t.parent.parent.pack();
                            t.parent.parent.invalidateHierarchy();
                        }).height(50.0f).growX().checked(this.selected == fi).group(group);
                    }
                    t.row();
                    t.add(stack).colspan(3).width(240.0f).left();
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(40.0f).padLeft(-1.0f).color(table.color);
            this.row(table);
            table.add(" of ").self(this::param);
            this.field(table, this.of, str -> {
                this.of = str;
            }).colspan(2);
            this.row(table);
            table.add(" to ");
            this.field(table, this.value, str -> {
                this.value = str;
            }).colspan(2);
        }

        private void stype(String text) {
            this.tfield.setText(text);
            this.type = text;
        }

        @Override
        public boolean privileged() {
            return true;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SetPropI(builder.var(this.type), builder.var(this.of), builder.var(this.value));
        }

        @Override
        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class SetFlagStatement
    extends LStatement {
        public String flag = "\"flag\"";
        public String value = "true";

        @Override
        public void build(Table table) {
            float width = LCanvas.useRows() ? 100.0f : 190.0f;
            this.fields(table, this.flag, str -> {
                this.flag = str;
            }).width(width);
            table.add(" = ");
            this.fields(table, this.value, str -> {
                this.value = str;
            }).width(width);
        }

        @Override
        public boolean privileged() {
            return true;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SetFlagI(builder.var(this.flag), builder.var(this.value));
        }

        @Override
        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class GetFlagStatement
    extends LStatement {
        public String result = "result";
        public String flag = "\"flag\"";

        @Override
        public void build(Table table) {
            float width = LCanvas.useRows() ? 100.0f : 190.0f;
            this.fields(table, this.result, str -> {
                this.result = str;
            }).width(width);
            table.add(" = flag ");
            this.fields(table, this.flag, str -> {
                this.flag = str;
            }).width(width);
        }

        @Override
        public boolean privileged() {
            return true;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.GetFlagI(builder.var(this.result), builder.var(this.flag));
        }

        @Override
        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class SyncStatement
    extends LStatement {
        public String variable = "var";

        @Override
        public void build(Table table) {
            this.fields(table, this.variable, str -> {
                this.variable = str;
            }).width(190.0f);
        }

        @Override
        public boolean privileged() {
            return true;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SyncI(builder.var(this.variable));
        }

        @Override
        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class FetchStatement
    extends LStatement {
        public FetchType type = FetchType.unit;
        public String result = "result";
        public String team = "@sharded";
        public String index = "0";
        public String extra = "@conveyor";

        @Override
        public void build(Table table) {
            this.rebuild(table);
        }

        void rebuild(Table table) {
            table.clearChildren();
            this.fields(table, this.result, r -> {
                this.result = r;
            });
            table.add(" = ");
            table.button(b -> {
                b.label(() -> this.type.name()).growX().wrap().labelAlign(1);
                b.clicked(() -> this.showSelect((Button)b, (T[])FetchType.all, this.type, o -> {
                    this.type = o;
                    this.rebuild(table);
                }, 2, c -> c.width(150.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(160.0f, 40.0f).margin(5.0f).pad(4.0f).color(table.color);
            this.row(table);
            this.fields(table, "team", this.team, s -> {
                this.team = s;
            });
            if (this.type != FetchType.coreCount && this.type != FetchType.playerCount && this.type != FetchType.unitCount && this.type != FetchType.buildCount) {
                table.add(" # ");
                this.row(table);
                this.fields(table, this.index, i -> {
                    this.index = i;
                });
            }
            if (this.type == FetchType.buildCount || this.type == FetchType.build) {
                this.row(table);
                this.fields(table, "block", this.extra, i -> {
                    this.extra = i;
                });
            }
        }

        @Override
        public boolean privileged() {
            return true;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.FetchI(this.type, builder.var(this.result), builder.var(this.team), builder.var(this.extra), builder.var(this.index));
        }

        @Override
        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class SetRateStatement
    extends LStatement {
        public String amount = "10";

        @Override
        public void build(Table table) {
            this.fields(table, "ipt = ", this.amount, str -> {
                this.amount = str;
            });
        }

        @Override
        public boolean privileged() {
            return true;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SetRateI(builder.var(this.amount));
        }

        @Override
        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class ExplosionStatement
    extends LStatement {
        public String team = "@crux";
        public String x = "0";
        public String y = "0";
        public String radius = "5";
        public String damage = "50";
        public String air = "true";
        public String ground = "true";
        public String pierce = "false";

        @Override
        public void build(Table table) {
            this.fields(table, "team", this.team, str -> {
                this.team = str;
            });
            this.fields(table, "x", this.x, str -> {
                this.x = str;
            });
            this.row(table);
            this.fields(table, "y", this.y, str -> {
                this.y = str;
            });
            this.fields(table, "radius", this.radius, str -> {
                this.radius = str;
            });
            table.row();
            this.fields(table, "damage", this.damage, str -> {
                this.damage = str;
            });
            this.fields(table, "air", this.air, str -> {
                this.air = str;
            });
            this.row(table);
            this.fields(table, "ground", this.ground, str -> {
                this.ground = str;
            });
            this.fields(table, "pierce", this.pierce, str -> {
                this.pierce = str;
            });
        }

        @Override
        public boolean privileged() {
            return true;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler b) {
            return new LExecutor.ExplosionI(b.var(this.team), b.var(this.x), b.var(this.y), b.var(this.radius), b.var(this.damage), b.var(this.air), b.var(this.ground), b.var(this.pierce));
        }

        @Override
        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class EffectStatement
    extends LStatement {
        public String type = "warn";
        public String x = "0";
        public String y = "0";
        public String sizerot = "2";
        public String color = "%ffaaff";
        public String data = "";

        @Override
        public void build(Table table) {
            table.clearChildren();
            table.button(b -> {
                b.label(() -> this.type).growX().wrap().labelAlign(1);
                b.clicked(() -> Vars.ui.effects.show(entry -> {
                    this.type = entry.name;
                    this.build(table);
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(150.0f, 40.0f).margin(5.0f).pad(4.0f).color(table.color).colspan(2);
            LogicFx.EffectEntry entry = LogicFx.get(this.type);
            this.row(table);
            this.fields(table, "x", this.x, str -> {
                this.x = str;
            });
            this.fields(table, "y", this.y, str -> {
                this.y = str;
            });
            this.row(table);
            if (entry != null) {
                if (entry.color) {
                    this.fields(table, "color", this.color, str -> {
                        this.color = str;
                    }).width(120.0f);
                    table.button(b -> {
                        b.image(Icon.pencilSmall);
                        b.clicked(() -> {
                            Color current = Pal.accent.cpy();
                            if (this.color.startsWith("%")) {
                                try {
                                    current = Color.valueOf(this.color.substring(1));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            Vars.ui.picker.show(current, result -> {
                                this.color = "%" + result.toString().substring(0, result.a >= 1.0f ? 6 : 8);
                                this.build(table);
                            });
                        });
                    }, (Button.ButtonStyle)Styles.logict, () -> {}).size(40.0f).padLeft(-11.0f).color(table.color);
                }
                this.row(table);
                if (entry.size || entry.rotate) {
                    this.fields(table, entry.size ? "size" : "rotation", this.sizerot, str -> {
                        this.sizerot = str;
                    });
                }
                if (entry.data != null) {
                    this.fields(table, "data", this.data, str -> {
                        this.data = str;
                    });
                }
            }
        }

        @Override
        public boolean privileged() {
            return true;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler b) {
            return new LExecutor.EffectI(LogicFx.get(this.type), b.var(this.x), b.var(this.y), b.var(this.sizerot), b.var(this.color), b.var(this.data));
        }

        @Override
        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class CutsceneStatement
    extends LStatement {
        public CutsceneAction action = CutsceneAction.pan;
        public String p1 = "100";
        public String p2 = "100";
        public String p3 = "0.06";
        public String p4 = "0";

        @Override
        public void build(Table table) {
            this.rebuild(table);
        }

        void rebuild(Table table) {
            table.clearChildren();
            table.button(b -> {
                b.label(() -> this.action.name()).growX().wrap().labelAlign(1);
                b.clicked(() -> this.showSelect((Button)b, (T[])CutsceneAction.all, this.action, o -> {
                    this.action = o;
                    this.rebuild(table);
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(90.0f, 40.0f).padLeft(2.0f).color(table.color);
            switch (this.action) {
                case pan: {
                    table.add(" x ");
                    this.fields(table, this.p1, str -> {
                        this.p1 = str;
                    });
                    table.add(" y ");
                    this.fields(table, this.p2, str -> {
                        this.p2 = str;
                    });
                    this.row(table);
                    table.add(" speed ");
                    this.fields(table, this.p3, str -> {
                        this.p3 = str;
                    });
                    break;
                }
                case zoom: {
                    table.add(" level ");
                    this.fields(table, this.p1, str -> {
                        this.p1 = str;
                    });
                }
            }
        }

        @Override
        public boolean privileged() {
            return true;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.CutsceneI(this.action, builder.var(this.p1), builder.var(this.p2), builder.var(this.p3), builder.var(this.p4));
        }

        @Override
        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class FlushMessageStatement
    extends LStatement {
        public MessageType type = MessageType.announce;
        public String duration = "3";

        @Override
        public void build(Table table) {
            this.rebuild(table);
        }

        void rebuild(Table table) {
            table.clearChildren();
            table.button(b -> {
                b.label(() -> this.type.name()).growX().wrap().labelAlign(1);
                b.clicked(() -> this.showSelect((Button)b, (T[])MessageType.all, this.type, o -> {
                    this.type = o;
                    this.rebuild(table);
                }, 2, c -> c.width(150.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(160.0f, 40.0f).padLeft(2.0f).color(table.color);
            switch (this.type) {
                case announce: 
                case toast: {
                    table.add(" for ");
                    this.fields(table, this.duration, str -> {
                        this.duration = str;
                    });
                    table.add(" secs ");
                }
            }
        }

        @Override
        public boolean privileged() {
            return true;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.FlushMessageI(this.type, builder.var(this.duration));
        }

        @Override
        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class SetRuleStatement
    extends LStatement {
        public LogicRule rule = LogicRule.waveSpacing;
        public String value = "10";
        public String p1 = "0";
        public String p2 = "0";
        public String p3 = "100";
        public String p4 = "100";

        @Override
        public void build(Table table) {
            this.rebuild(table);
        }

        void rebuild(Table table) {
            table.clearChildren();
            table.button(b -> {
                b.label(() -> this.rule.name()).growX().wrap().labelAlign(1);
                b.clicked(() -> this.showSelect((Button)b, (T[])LogicRule.all, this.rule, o -> {
                    this.rule = o;
                    this.rebuild(table);
                }, 2, c -> c.width(150.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(160.0f, 40.0f).margin(5.0f).pad(4.0f).color(table.color);
            switch (this.rule) {
                case mapArea: {
                    table.add(" = ");
                    this.fields(table, "x", this.p1, s -> {
                        this.p1 = s;
                    });
                    this.fields(table, "y", this.p2, s -> {
                        this.p2 = s;
                    });
                    this.row(table);
                    this.fields(table, "w", this.p3, s -> {
                        this.p3 = s;
                    });
                    this.fields(table, "h", this.p4, s -> {
                        this.p4 = s;
                    });
                    break;
                }
                case buildSpeed: 
                case unitHealth: 
                case unitBuildSpeed: 
                case unitCost: 
                case unitDamage: 
                case blockHealth: 
                case blockDamage: 
                case rtsMinSquad: 
                case rtsMinWeight: {
                    if (this.p1.equals("0")) {
                        this.p1 = "@sharded";
                    }
                    this.fields(table, "of", this.p1, s -> {
                        this.p1 = s;
                    });
                    table.add(" = ");
                    this.row(table);
                    this.field(table, this.value, s -> {
                        this.value = s;
                    });
                    break;
                }
                default: {
                    table.add(" = ");
                    this.field(table, this.value, s -> {
                        this.value = s;
                    });
                }
            }
        }

        @Override
        public boolean privileged() {
            return true;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SetRuleI(this.rule, builder.var(this.value), builder.var(this.p1), builder.var(this.p2), builder.var(this.p3), builder.var(this.p4));
        }

        @Override
        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class SpawnWaveStatement
    extends LStatement {
        public String x = "10";
        public String y = "10";
        public String natural = "false";

        @Override
        public void build(Table table) {
            table.add("natural ");
            this.fields(table, this.natural, str -> {
                this.natural = str;
            });
            table.add("x ").visible(() -> this.natural.equals("false"));
            this.fields(table, this.x, str -> {
                this.x = str;
            }).visible(() -> this.natural.equals("false"));
            table.add(" y ").visible(() -> this.natural.equals("false"));
            this.fields(table, this.y, str -> {
                this.y = str;
            }).visible(() -> this.natural.equals("false"));
        }

        @Override
        public boolean privileged() {
            return true;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SpawnWaveI(builder.var(this.natural), builder.var(this.x), builder.var(this.y));
        }

        @Override
        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class ApplyStatusStatement
    extends LStatement {
        public boolean clear;
        public String effect = "wet";
        public String unit = "unit";
        public String duration = "10";
        @Nullable
        private static String[] statusNames;

        @Override
        public void build(Table table) {
            this.rebuild(table);
        }

        void rebuild(Table table) {
            table.clearChildren();
            table.button(this.clear ? "clear" : "apply", Styles.logict, () -> {
                this.clear = !this.clear;
                this.rebuild(table);
            }).size(80.0f, 40.0f).pad(4.0f).color(table.color);
            if (statusNames == null) {
                statusNames = (String[])Vars.content.statusEffects().select(s -> !s.isHidden()).map(s -> s.name).toArray(String.class);
            }
            table.button(b -> {
                b.label(() -> this.effect).grow().wrap().labelAlign(1).center();
                b.clicked(() -> this.showSelect((Button)b, (T[])statusNames, this.effect, o -> {
                    this.effect = o;
                }, 2, c -> c.size(120.0f, 38.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(120.0f, 40.0f).pad(4.0f).color(table.color);
            table.add(this.clear ? " from " : " to ");
            this.row(table);
            this.fields(table, this.unit, str -> {
                this.unit = str;
            });
            if (!(this.clear || Vars.content.statusEffect(this.effect) != null && Vars.content.statusEffect((String)this.effect).permanent)) {
                table.add(" for ");
                this.fields(table, this.duration, str -> {
                    this.duration = str;
                });
                table.add(" sec");
            }
        }

        @Override
        public boolean privileged() {
            return true;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.ApplyEffectI(this.clear, this.effect, builder.var(this.unit), builder.var(this.duration));
        }

        @Override
        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class SpawnUnitStatement
    extends LStatement {
        public String type = "@dagger";
        public String x = "10";
        public String y = "10";
        public String rotation = "90";
        public String team = "@sharded";
        public String result = "result";

        @Override
        public void build(Table table) {
            this.fields(table, this.result, str -> {
                this.result = str;
            });
            table.add(" = spawn ");
            this.field(table, this.type, str -> {
                this.type = str;
            }).colspan(!LCanvas.useRows() ? 1 : 2);
            this.row(table);
            table.add(" at ");
            this.fields(table, this.x, str -> {
                this.x = str;
            });
            table.add(", ");
            this.fields(table, this.y, str -> {
                this.y = str;
            });
            table.row();
            if (!LCanvas.useRows()) {
                table.add();
            }
            table.add("team ");
            this.field(table, this.team, str -> {
                this.team = str;
            });
            table.add(" rot ");
            this.fields(table, this.rotation, str -> {
                this.rotation = str;
            }).left();
        }

        @Override
        public boolean privileged() {
            return true;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SpawnUnitI(builder.var(this.type), builder.var(this.x), builder.var(this.y), builder.var(this.rotation), builder.var(this.team), builder.var(this.result));
        }

        @Override
        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class SetBlockStatement
    extends LStatement {
        public TileLayer layer = TileLayer.block;
        public String block = "@air";
        public String x = "0";
        public String y = "0";
        public String team = "@derelict";
        public String rotation = "0";

        @Override
        public void build(Table table) {
            this.rebuild(table);
        }

        void rebuild(Table table) {
            table.clearChildren();
            table.add("set");
            table.button(b -> {
                b.label(() -> this.layer.name());
                b.clicked(() -> this.showSelect((Button)b, (T[])TileLayer.settable, this.layer, o -> {
                    this.layer = o;
                    this.rebuild(table);
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(64.0f, 40.0f).pad(4.0f).color(table.color);
            this.row(table);
            table.add(" at ");
            this.fields(table, this.x, str -> {
                this.x = str;
            });
            table.add(", ");
            this.fields(table, this.y, str -> {
                this.y = str;
            });
            this.row(table);
            table.add(" to ");
            this.fields(table, this.block, str -> {
                this.block = str;
            });
            if (this.layer == TileLayer.block) {
                this.row(table);
                table.add("team ");
                this.fields(table, this.team, str -> {
                    this.team = str;
                });
                table.add(" rotation ");
                this.fields(table, this.rotation, str -> {
                    this.rotation = str;
                });
            }
        }

        @Override
        public boolean privileged() {
            return true;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SetBlockI(builder.var(this.x), builder.var(this.y), builder.var(this.block), builder.var(this.team), builder.var(this.rotation), this.layer);
        }

        @Override
        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class GetBlockStatement
    extends LStatement {
        public TileLayer layer = TileLayer.block;
        public String result = "result";
        public String x = "0";
        public String y = "0";

        @Override
        public void build(Table table) {
            this.fields(table, this.result, str -> {
                this.result = str;
            });
            table.add(" = get ");
            this.row(table);
            table.button(b -> {
                b.label(() -> this.layer.name());
                b.clicked(() -> this.showSelect((Button)b, (T[])TileLayer.all, this.layer, o -> {
                    this.layer = o;
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(64.0f, 40.0f).pad(4.0f).color(table.color);
            table.add(" at ");
            this.fields(table, this.x, str -> {
                this.x = str;
            });
            table.add(", ");
            this.fields(table, this.y, str -> {
                this.y = str;
            });
        }

        @Override
        public boolean privileged() {
            return true;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.GetBlockI(builder.var(this.x), builder.var(this.y), builder.var(this.result), this.layer);
        }

        @Override
        public LCategory category() {
            return LCategory.world;
        }
    }

    public static class UnitLocateStatement
    extends LStatement {
        public LLocate locate = LLocate.building;
        public BlockFlag flag = BlockFlag.core;
        public String enemy = "true";
        public String ore = "@copper";
        public String outX = "outx";
        public String outY = "outy";
        public String outFound = "found";
        public String outBuild = "building";

        @Override
        public void build(Table table) {
            this.rebuild(table);
        }

        void rebuild(Table table) {
            table.clearChildren();
            table.add(" find ").left().self(this::param);
            table.button(b -> {
                b.label(() -> this.locate.name());
                b.clicked(() -> this.showSelect((Button)b, (T[])LLocate.all, this.locate, t -> {
                    this.locate = t;
                    this.rebuild(table);
                }, 2, cell -> cell.size(110.0f, 50.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(110.0f, 40.0f).color(table.color).left().padLeft(2.0f);
            switch (this.locate) {
                case building: {
                    this.row(table);
                    table.add(" group ").left().self(this::param);
                    table.button(b -> {
                        b.label(() -> this.flag.name());
                        b.clicked(() -> this.showSelect((Button)b, (T[])BlockFlag.allLogic, this.flag, t -> {
                            this.flag = t;
                        }, 2, cell -> cell.size(110.0f, 50.0f)));
                    }, (Button.ButtonStyle)Styles.logict, () -> {}).size(110.0f, 40.0f).color(table.color).left().padLeft(2.0f);
                    this.row(table);
                    table.add(" enemy ").left().self(this::param);
                    this.fields(table, this.enemy, str -> {
                        this.enemy = str;
                    });
                    table.row();
                    break;
                }
                case ore: {
                    table.add(" ore ").left().self(this::param);
                    table.table(ts -> {
                        ts.color.set(table.color);
                        this.fields((Table)ts, this.ore, str -> {
                            this.ore = str;
                        });
                        ts.button(b -> {
                            b.image(Icon.pencilSmall);
                            b.clicked(() -> this.showSelectTable((Button)b, (t, hide) -> {
                                t.row();
                                t.table(i -> {
                                    i.left();
                                    int c = 0;
                                    for (Item item : Vars.content.items()) {
                                        if (!item.unlockedNow()) continue;
                                        i.button(new TextureRegionDrawable(item.uiIcon), Styles.flati, 24.0f, () -> {
                                            this.ore = "@" + item.name;
                                            this.rebuild(table);
                                            hide.run();
                                        }).size(40.0f);
                                        if (++c % 6 != 0) continue;
                                        i.row();
                                    }
                                }).colspan(3).width(240.0f).left();
                            }));
                        }, (Button.ButtonStyle)Styles.logict, () -> {}).size(40.0f).padLeft(-2.0f).color(table.color);
                    });
                    table.row();
                    break;
                }
                case spawn: 
                case damaged: {
                    table.row();
                }
            }
            table.add(" outX ").left().self(this::param);
            this.fields(table, this.outX, str -> {
                this.outX = str;
            });
            table.add(" outY ").left().self(this::param);
            this.fields(table, this.outY, str -> {
                this.outY = str;
            });
            this.row(table);
            table.add(" found ").left().self(this::param);
            this.fields(table, this.outFound, str -> {
                this.outFound = str;
            });
            if (this.locate != LLocate.ore) {
                table.add(" building ").left().self(this::param);
                this.fields(table, this.outBuild, str -> {
                    this.outBuild = str;
                });
            }
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.UnitLocateI(this.locate, this.flag, builder.var(this.enemy), builder.var(this.ore), builder.var(this.outX), builder.var(this.outY), builder.var(this.outFound), builder.var(this.outBuild));
        }

        @Override
        public LCategory category() {
            return LCategory.unit;
        }
    }

    public static class UnitRadarStatement
    extends RadarStatement {
        public UnitRadarStatement() {
            this.radar = "0";
        }

        @Override
        public boolean buildFrom() {
            return false;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.RadarI(this.target1, this.target2, this.target3, this.sort, 1, builder.var(this.sortOrder), builder.var(this.output));
        }

        @Override
        public LCategory category() {
            return LCategory.unit;
        }
    }

    public static class UnitControlStatement
    extends LStatement {
        public LUnitControl type = LUnitControl.move;
        public String p1 = "0";
        public String p2 = "0";
        public String p3 = "0";
        public String p4 = "0";
        public String p5 = "0";

        @Override
        public void build(Table table) {
            this.rebuild(table);
        }

        void rebuild(Table table) {
            table.clearChildren();
            table.left();
            table.add(" ");
            table.button(b -> {
                b.label(() -> this.type.name());
                b.clicked(() -> this.showSelect((Button)b, (T[])LUnitControl.all, this.type, t -> {
                    if (t == LUnitControl.build && !Vars.state.rules.logicUnitBuild) {
                        Vars.ui.showInfo("@logic.nounitbuild");
                    } else {
                        this.type = t;
                    }
                    this.rebuild(table);
                }, 2, cell -> cell.size(120.0f, 50.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(120.0f, 40.0f).color(table.color).left().padLeft(2.0f);
            this.row(table);
            int c = 0;
            for (int i = 0; i < this.type.params.length; ++i) {
                this.fields(table, this.type.params[i], i == 0 ? this.p1 : (i == 1 ? this.p2 : (i == 2 ? this.p3 : (i == 3 ? this.p4 : this.p5))), i == 0 ? v -> {
                    this.p1 = v;
                } : (i == 1 ? v -> {
                    this.p2 = v;
                } : (i == 2 ? v -> {
                    this.p3 = v;
                } : (i == 3 ? v -> {
                    this.p4 = v;
                } : v -> {
                    this.p5 = v;
                })))).width(100.0f);
                if (++c % 2 == 0) {
                    this.row(table);
                }
                if (i != 3) continue;
                table.row();
            }
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.UnitControlI(this.type, builder.var(this.p1), builder.var(this.p2), builder.var(this.p3), builder.var(this.p4), builder.var(this.p5));
        }

        @Override
        public LCategory category() {
            return LCategory.unit;
        }
    }

    public static class UnitBindStatement
    extends LStatement {
        public String type = "@poly";

        @Override
        public void build(Table table) {
            table.add(" type ");
            TextField field = this.field(table, this.type, str -> {
                this.type = str;
            }).get();
            table.button(b -> {
                b.image(Icon.pencilSmall);
                b.clicked(() -> this.showSelectTable((Button)b, (t, hide) -> {
                    t.row();
                    t.table(i -> {
                        i.left();
                        int c = 0;
                        for (UnitType item : Vars.content.units()) {
                            if (!item.unlockedNow() || item.isHidden() || !item.logicControllable) continue;
                            i.button(new TextureRegionDrawable(item.uiIcon), Styles.flati, 24.0f, () -> {
                                this.type = "@" + item.name;
                                field.setText(this.type);
                                hide.run();
                            }).size(40.0f);
                            if (++c % 6 != 0) continue;
                            i.row();
                        }
                    }).colspan(3).width(240.0f).left();
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(40.0f).padLeft(-2.0f).color(table.color);
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.UnitBindI(builder.var(this.type));
        }

        @Override
        public LCategory category() {
            return LCategory.unit;
        }
    }

    public static class JumpStatement
    extends LStatement {
        private static Color last = new Color();
        public transient LCanvas.StatementElem dest;
        public int destIndex;
        public ConditionOp op = ConditionOp.notEqual;
        public String value = "x";
        public String compare = "false";

        @Override
        public void build(Table table) {
            table.add("if ").padLeft(4.0f);
            last = table.color;
            table.table(this::rebuild);
            table.add().growX();
            table.add(new LCanvas.JumpButton(() -> this.dest, s -> {
                this.dest = s;
            })).size(30.0f).right().padLeft(-8.0f);
            String name = this.name();
            Core.app.post(() -> {
                Label title;
                if (table.parent != null && (title = (Label)table.parent.find("statement-name")) != null) {
                    title.update(() -> title.setText(this.dest != null ? name + " -> " + this.dest.index : name));
                }
            });
        }

        void rebuild(Table table) {
            table.clearChildren();
            table.setColor(last);
            if (this.op != ConditionOp.always) {
                this.field(table, this.value, str -> {
                    this.value = str;
                });
            }
            table.button(b -> {
                b.label(() -> this.op.symbol);
                b.clicked(() -> this.showSelect((Button)b, (T[])ConditionOp.all, this.op, o -> {
                    this.op = o;
                    this.rebuild(table);
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(this.op == ConditionOp.always ? 80.0f : 48.0f, 40.0f).pad(4.0f).color(table.color);
            if (this.op != ConditionOp.always) {
                this.field(table, this.compare, str -> {
                    this.compare = str;
                });
            }
        }

        @Override
        public void setupUI() {
            if (this.elem != null && this.destIndex >= 0 && this.destIndex < this.elem.parent.getChildren().size) {
                this.dest = (LCanvas.StatementElem)this.elem.parent.getChildren().get(this.destIndex);
            }
        }

        @Override
        public void saveUI() {
            if (this.elem != null) {
                this.destIndex = this.dest == null ? -1 : this.dest.parent.getChildren().indexOf(this.dest);
            }
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.JumpI(this.op, builder.var(this.value), builder.var(this.compare), this.destIndex);
        }

        @Override
        public LCategory category() {
            return LCategory.control;
        }
    }

    public static class EndStatement
    extends LStatement {
        @Override
        public void build(Table table) {
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.EndI();
        }

        @Override
        public LCategory category() {
            return LCategory.control;
        }
    }

    public static class PackColorStatement
    extends LStatement {
        public String result = "result";
        public String r = "1";
        public String g = "0";
        public String b = "0";
        public String a = "1";

        @Override
        public void build(Table table) {
            this.fields(table, this.result, str -> {
                this.result = str;
            });
            table.add(" = pack ");
            this.row(table);
            this.fields(table, this.r, str -> {
                this.r = str;
            });
            this.fields(table, this.g, str -> {
                this.g = str;
            });
            this.fields(table, this.b, str -> {
                this.b = str;
            });
            this.fields(table, this.a, str -> {
                this.a = str;
            });
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.PackColorI(builder.var(this.result), builder.var(this.r), builder.var(this.g), builder.var(this.b), builder.var(this.a));
        }

        @Override
        public LCategory category() {
            return LCategory.operation;
        }
    }

    public static class LookupStatement
    extends LStatement {
        public ContentType type = ContentType.item;
        public String result = "result";
        public String id = "0";

        @Override
        public void build(Table table) {
            this.fields(table, this.result, str -> {
                this.result = str;
            }).width(120.0f);
            table.add(" = lookup ");
            this.row(table);
            table.button(b -> {
                b.label(() -> this.type.name());
                b.clicked(() -> this.showSelect((Button)b, (T[])GlobalVars.lookableContent, this.type, o -> {
                    this.type = o;
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(64.0f, 40.0f).pad(4.0f).color(table.color);
            table.add(" # ");
            this.fields(table, this.id, str -> {
                this.id = str;
            });
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.LookupI(builder.var(this.result), builder.var(this.id), this.type);
        }

        @Override
        public LCategory category() {
            return LCategory.operation;
        }
    }

    public static class StopStatement
    extends LStatement {
        @Override
        public void build(Table table) {
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.StopI();
        }

        @Override
        public LCategory category() {
            return LCategory.control;
        }
    }

    public static class WaitStatement
    extends LStatement {
        public String value = "0.5";

        @Override
        public void build(Table table) {
            this.field(table, this.value, str -> {
                this.value = str;
            });
            table.add(" sec");
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.WaitI(builder.var(this.value));
        }

        @Override
        public LCategory category() {
            return LCategory.control;
        }
    }

    public static class OperationStatement
    extends LStatement {
        public LogicOp op = LogicOp.add;
        public String dest = "result";
        public String a = "a";
        public String b = "b";

        @Override
        public void build(Table table) {
            this.rebuild(table);
        }

        void rebuild(Table table) {
            table.clearChildren();
            this.field(table, this.dest, str -> {
                this.dest = str;
            });
            table.add(" = ");
            if (this.op.unary) {
                this.opButton(table, table);
                this.field(table, this.a, str -> {
                    this.a = str;
                });
            } else {
                this.row(table);
                if (this.op.func) {
                    if (LCanvas.useRows()) {
                        table.left();
                        table.row();
                        table.table(c -> {
                            c.color.set(this.category().color);
                            c.left();
                            this.funcs((Table)c, table);
                        }).colspan(2).left();
                    } else {
                        this.funcs(table, table);
                    }
                } else {
                    this.field(table, this.a, str -> {
                        this.a = str;
                    });
                    this.opButton(table, table);
                    this.field(table, this.b, str -> {
                        this.b = str;
                    });
                }
            }
        }

        void funcs(Table table, Table parent) {
            this.opButton(table, parent);
            this.field(table, this.a, str -> {
                this.a = str;
            });
            this.field(table, this.b, str -> {
                this.b = str;
            });
        }

        void opButton(Table table, Table parent) {
            table.button(b -> {
                b.label(() -> this.op.symbol);
                b.clicked(() -> this.showSelect((Button)b, (T[])LogicOp.all, this.op, o -> {
                    this.op = o;
                    this.rebuild(parent);
                }, 4, c -> c.width(64.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(64.0f, 40.0f).pad(4.0f).color(table.color);
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.OpI(this.op, builder.var(this.a), builder.var(this.b), builder.var(this.dest));
        }

        @Override
        public LCategory category() {
            return LCategory.operation;
        }
    }

    public static class SetStatement
    extends LStatement {
        public String to = "result";
        public String from = "0";

        @Override
        public void build(Table table) {
            this.field(table, this.to, str -> {
                this.to = str;
            });
            table.add(" = ");
            this.field(table, this.from, str -> {
                this.from = str;
            });
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SetI(builder.var(this.from), builder.var(this.to));
        }

        @Override
        public LCategory category() {
            return LCategory.operation;
        }
    }

    public static class SensorStatement
    extends LStatement {
        public String to = "result";
        public String from = "block1";
        public String type = "@copper";
        private transient int selected = 0;
        private transient TextField tfield;

        @Override
        public void build(Table table) {
            this.field(table, this.to, str -> {
                this.to = str;
            });
            table.add(" = ");
            this.row(table);
            this.tfield = this.field(table, this.type, str -> {
                this.type = str;
            }).padRight(0.0f).get();
            table.button(b -> {
                b.image(Icon.pencilSmall);
                b.clicked(() -> this.showSelectTable((Button)b, (t, hide) -> {
                    Table[] tables = new Table[]{new Table(i -> {
                        i.left();
                        int c = 0;
                        for (Item item : Vars.content.items()) {
                            if (!item.unlockedNow() || item.hidden) continue;
                            i.button(new TextureRegionDrawable(item.uiIcon), Styles.flati, 24.0f, () -> {
                                this.stype("@" + item.name);
                                hide.run();
                            }).size(40.0f);
                            if (++c % 6 != 0) continue;
                            i.row();
                        }
                    }), new Table(i -> {
                        i.left();
                        int c = 0;
                        for (Liquid item : Vars.content.liquids()) {
                            if (!item.unlockedNow() || item.hidden) continue;
                            i.button(new TextureRegionDrawable(item.uiIcon), Styles.flati, 24.0f, () -> {
                                this.stype("@" + item.name);
                                hide.run();
                            }).size(40.0f);
                            if (++c % 6 != 0) continue;
                            i.row();
                        }
                    }), new Table(i -> {
                        for (LAccess sensor : LAccess.senseable) {
                            i.button(sensor.name(), Styles.flatt, () -> {
                                this.stype("@" + sensor.name());
                                hide.run();
                            }).size(240.0f, 40.0f).self(c -> LCanvas.tooltip(c, sensor)).row();
                        }
                    })};
                    Drawable[] icons = new Drawable[]{Icon.box, Icon.liquid, Icon.tree};
                    Stack stack = new Stack(tables[this.selected]);
                    ButtonGroup group = new ButtonGroup();
                    for (int i2 = 0; i2 < tables.length; ++i2) {
                        int fi = i2;
                        t.button(icons[i2], Styles.squareTogglei, () -> {
                            this.selected = fi;
                            stack.clearChildren();
                            stack.addChild(tables[this.selected]);
                            t.parent.parent.pack();
                            t.parent.parent.invalidateHierarchy();
                        }).height(50.0f).growX().checked(this.selected == fi).group(group);
                    }
                    t.row();
                    t.add(stack).colspan(3).width(240.0f).left();
                }));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(40.0f).padLeft(-1.0f).color(table.color);
            table.add(" in ").self(this::param);
            this.field(table, this.from, str -> {
                this.from = str;
            });
        }

        private void stype(String text) {
            this.tfield.setText(text);
            this.type = text;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.SenseI(builder.var(this.from), builder.var(this.to), builder.var(this.type));
        }

        @Override
        public LCategory category() {
            return LCategory.block;
        }
    }

    public static class RadarStatement
    extends LStatement {
        public RadarTarget target1 = RadarTarget.enemy;
        public RadarTarget target2 = RadarTarget.any;
        public RadarTarget target3 = RadarTarget.any;
        public RadarSort sort = RadarSort.distance;
        public String radar = "turret1";
        public String sortOrder = "1";
        public String output = "result";

        @Override
        public void build(Table table) {
            table.defaults().left();
            if (this.buildFrom()) {
                table.add(" from ").self(this::param);
                this.fields(table, this.radar, v -> {
                    this.radar = v;
                });
                this.row(table);
            }
            for (int i = 0; i < 3; ++i) {
                int fi = i;
                Prov<RadarTarget> get = () -> fi == 0 ? this.target1 : (fi == 1 ? this.target2 : this.target3);
                table.add(i == 0 ? " target " : " and ").self(this::param);
                table.button(b -> {
                    b.label(() -> ((RadarTarget)((Object)((Object)((Object)get.get())))).name());
                    b.clicked(() -> this.showSelect((Button)b, (T[])RadarTarget.all, (RadarTarget)((Object)((Object)((Object)get.get()))), t -> {
                        if (fi == 0) {
                            this.target1 = t;
                        } else if (fi == 1) {
                            this.target2 = t;
                        } else {
                            this.target3 = t;
                        }
                    }, 2, cell -> cell.size(100.0f, 50.0f)));
                }, (Button.ButtonStyle)Styles.logict, () -> {}).size(90.0f, 40.0f).color(table.color).left().padLeft(2.0f);
                if (i != 1) continue;
                this.row(table);
            }
            table.add(" order ").self(this::param);
            this.fields(table, this.sortOrder, v -> {
                this.sortOrder = v;
            });
            table.row();
            table.add(" sort ").self(this::param);
            table.button(b -> {
                b.label(() -> this.sort.name());
                b.clicked(() -> this.showSelect((Button)b, (T[])RadarSort.all, this.sort, t -> {
                    this.sort = t;
                }, 2, cell -> cell.size(100.0f, 50.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(90.0f, 40.0f).color(table.color).left().padLeft(2.0f);
            table.add(" output ").self(this::param);
            this.fields(table, this.output, v -> {
                this.output = v;
            });
        }

        public boolean buildFrom() {
            return true;
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.RadarI(this.target1, this.target2, this.target3, this.sort, builder.var(this.radar), builder.var(this.sortOrder), builder.var(this.output));
        }

        @Override
        public LCategory category() {
            return LCategory.block;
        }
    }

    public static class ControlStatement
    extends LStatement {
        public LAccess type = LAccess.enabled;
        public String target = "block1";
        public String p1 = "0";
        public String p2 = "0";
        public String p3 = "0";
        public String p4 = "0";

        @Override
        public void build(Table table) {
            this.rebuild(table);
        }

        void rebuild(Table table) {
            table.clearChildren();
            table.left();
            table.add(" set ");
            table.button(b -> {
                b.label(() -> this.type.name());
                b.clicked(() -> this.showSelect((Button)b, (T[])LAccess.controls, this.type, t -> {
                    this.type = t;
                    this.rebuild(table);
                }, 2, cell -> cell.size(100.0f, 50.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(90.0f, 40.0f).color(table.color).left().padLeft(2.0f);
            table.add(" of ").self(this::param);
            this.field(table, this.target, v -> {
                this.target = v;
            });
            this.row(table);
            int c = 0;
            for (int i = 0; i < this.type.params.length; ++i) {
                this.fields(table, this.type.params[i], i == 0 ? this.p1 : (i == 1 ? this.p2 : (i == 2 ? this.p3 : this.p4)), i == 0 ? v -> {
                    this.p1 = v;
                } : (i == 1 ? v -> {
                    this.p2 = v;
                } : (i == 2 ? v -> {
                    this.p3 = v;
                } : v -> {
                    this.p4 = v;
                })));
                if (++c % 2 != 0) continue;
                this.row(table);
            }
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.ControlI(this.type, builder.var(this.target), builder.var(this.p1), builder.var(this.p2), builder.var(this.p3), builder.var(this.p4));
        }

        @Override
        public LCategory category() {
            return LCategory.block;
        }
    }

    public static class GetLinkStatement
    extends LStatement {
        public String output = "result";
        public String address = "0";

        @Override
        public void build(Table table) {
            this.field(table, this.output, str -> {
                this.output = str;
            });
            table.add(" = link# ");
            this.field(table, this.address, str -> {
                this.address = str;
            });
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.GetLinkI(builder.var(this.output), builder.var(this.address));
        }

        @Override
        public LCategory category() {
            return LCategory.block;
        }
    }

    public static class PrintFlushStatement
    extends LStatement {
        public String target = "message1";

        @Override
        public void build(Table table) {
            table.add(" to ");
            this.field(table, this.target, str -> {
                this.target = str;
            });
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.PrintFlushI(builder.var(this.target));
        }

        @Override
        public LCategory category() {
            return LCategory.block;
        }
    }

    public static class DrawFlushStatement
    extends LStatement {
        public String target = "display1";

        @Override
        public void build(Table table) {
            table.add(" to ");
            this.field(table, this.target, str -> {
                this.target = str;
            });
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.DrawFlushI(builder.var(this.target));
        }

        @Override
        public LCategory category() {
            return LCategory.block;
        }
    }

    public static class PrintStatement
    extends LStatement {
        public String value = "\"frog\"";

        @Override
        public void build(Table table) {
            this.field(table, this.value, str -> {
                this.value = str;
            }).width(0.0f).growX().padRight(3.0f);
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.PrintI(builder.var(this.value));
        }

        @Override
        public LCategory category() {
            return LCategory.io;
        }
    }

    public static class DrawStatement
    extends LStatement {
        public LogicDisplay.GraphicsType type = LogicDisplay.GraphicsType.clear;
        public String x = "0";
        public String y = "0";
        public String p1 = "0";
        public String p2 = "0";
        public String p3 = "0";
        public String p4 = "0";

        @Override
        public void build(Table table) {
            this.rebuild(table);
        }

        void rebuild(Table table) {
            table.clearChildren();
            table.left();
            table.button(b -> {
                b.label(() -> this.type.name());
                b.clicked(() -> this.showSelect((Button)b, (T[])LogicDisplay.GraphicsType.all, this.type, t -> {
                    this.type = t;
                    if (this.type == LogicDisplay.GraphicsType.color) {
                        this.p2 = "255";
                    }
                    if (this.type == LogicDisplay.GraphicsType.image) {
                        this.p1 = "@copper";
                        this.p2 = "32";
                        this.p3 = "0";
                    }
                    this.rebuild(table);
                }, 2, cell -> cell.size(100.0f, 50.0f)));
            }, (Button.ButtonStyle)Styles.logict, () -> {}).size(90.0f, 40.0f).color(table.color).left().padLeft(2.0f);
            if (this.type != LogicDisplay.GraphicsType.stroke) {
                this.row(table);
            }
            table.table(s -> {
                s.left();
                s.setColor(table.color);
                switch (this.type) {
                    case clear: {
                        this.fields((Table)s, "r", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "g", this.y, v -> {
                            this.y = v;
                        });
                        this.fields((Table)s, "b", this.p1, v -> {
                            this.p1 = v;
                        });
                        break;
                    }
                    case color: {
                        this.fields((Table)s, "r", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "g", this.y, v -> {
                            this.y = v;
                        });
                        this.fields((Table)s, "b", this.p1, v -> {
                            this.p1 = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "a", this.p2, v -> {
                            this.p2 = v;
                        });
                        break;
                    }
                    case col: {
                        this.fields((Table)s, "color", this.x, v -> {
                            this.x = v;
                        }).width(144.0f);
                        break;
                    }
                    case stroke: {
                        s.add().width(4.0f);
                        this.fields((Table)s, this.x, v -> {
                            this.x = v;
                        });
                        break;
                    }
                    case line: {
                        this.fields((Table)s, "x", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "y", this.y, v -> {
                            this.y = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "x2", this.p1, v -> {
                            this.p1 = v;
                        });
                        this.fields((Table)s, "y2", this.p2, v -> {
                            this.p2 = v;
                        });
                        break;
                    }
                    case rect: 
                    case lineRect: {
                        this.fields((Table)s, "x", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "y", this.y, v -> {
                            this.y = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "width", this.p1, v -> {
                            this.p1 = v;
                        });
                        this.fields((Table)s, "height", this.p2, v -> {
                            this.p2 = v;
                        });
                        break;
                    }
                    case poly: 
                    case linePoly: {
                        this.fields((Table)s, "x", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "y", this.y, v -> {
                            this.y = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "sides", this.p1, v -> {
                            this.p1 = v;
                        });
                        this.fields((Table)s, "radius", this.p2, v -> {
                            this.p2 = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "rotation", this.p3, v -> {
                            this.p3 = v;
                        });
                        break;
                    }
                    case triangle: {
                        this.fields((Table)s, "x", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "y", this.y, v -> {
                            this.y = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "x2", this.p1, v -> {
                            this.p1 = v;
                        });
                        this.fields((Table)s, "y2", this.p2, v -> {
                            this.p2 = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "x3", this.p3, v -> {
                            this.p3 = v;
                        });
                        this.fields((Table)s, "y3", this.p4, v -> {
                            this.p4 = v;
                        });
                        break;
                    }
                    case image: {
                        this.fields((Table)s, "x", this.x, v -> {
                            this.x = v;
                        });
                        this.fields((Table)s, "y", this.y, v -> {
                            this.y = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "image", this.p1, v -> {
                            this.p1 = v;
                        });
                        this.fields((Table)s, "size", this.p2, v -> {
                            this.p2 = v;
                        });
                        this.row((Table)s);
                        this.fields((Table)s, "rotation", this.p3, v -> {
                            this.p3 = v;
                        });
                    }
                }
            }).expand().left();
        }

        @Override
        public void afterRead() {
            if (this.type == LogicDisplay.GraphicsType.color && this.p2.equals("0")) {
                this.p2 = "255";
            }
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.DrawI((byte)this.type.ordinal(), 0, builder.var(this.x), builder.var(this.y), builder.var(this.p1), builder.var(this.p2), builder.var(this.p3), builder.var(this.p4));
        }

        @Override
        public LCategory category() {
            return LCategory.io;
        }
    }

    public static class WriteStatement
    extends LStatement {
        public String input = "result";
        public String target = "cell1";
        public String address = "0";

        @Override
        public void build(Table table) {
            table.add(" write ");
            this.field(table, this.input, str -> {
                this.input = str;
            });
            table.add(" to ");
            this.fields(table, this.target, str -> {
                this.target = str;
            });
            this.row(table);
            table.add(" at ");
            this.field(table, this.address, str -> {
                this.address = str;
            });
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.WriteI(builder.var(this.target), builder.var(this.address), builder.var(this.input));
        }

        @Override
        public LCategory category() {
            return LCategory.io;
        }
    }

    public static class ReadStatement
    extends LStatement {
        public String output = "result";
        public String target = "cell1";
        public String address = "0";

        @Override
        public void build(Table table) {
            table.add(" read ");
            this.field(table, this.output, str -> {
                this.output = str;
            });
            table.add(" = ");
            this.fields(table, this.target, str -> {
                this.target = str;
            });
            this.row(table);
            table.add(" at ");
            this.field(table, this.address, str -> {
                this.address = str;
            });
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.ReadI(builder.var(this.target), builder.var(this.address), builder.var(this.output));
        }

        @Override
        public LCategory category() {
            return LCategory.io;
        }
    }

    public static class InvalidStatement
    extends LStatement {
        @Override
        public void build(Table table) {
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return new LExecutor.NoopI();
        }
    }

    public static class CommentStatement
    extends LStatement {
        public String comment = "";

        @Override
        public void build(Table table) {
            table.area(this.comment, Styles.nodeArea, v -> {
                this.comment = v;
            }).growX().height(90.0f).padLeft(2.0f).padRight(6.0f).color(table.color);
        }

        @Override
        public LExecutor.LInstruction build(LAssembler builder) {
            return null;
        }
    }
}

