/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.struct.OrderedMap;
import arc.util.Nullable;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.world.Block;

public class LogicFx {
    private static OrderedMap<String, EffectEntry> map = new OrderedMap();

    public static Iterable<EffectEntry> entries() {
        return map.orderedKeys().map(s -> (EffectEntry)map.get((String)s));
    }

    @Nullable
    public static EffectEntry get(String name) {
        return (EffectEntry)map.get(name);
    }

    public static String[] all() {
        return (String[])map.orderedKeys().toArray(String.class);
    }

    static {
        map.putAll("warn", new EffectEntry(Fx.unitCapKill), "cross", new EffectEntry(Fx.unitEnvKill), "blockFall", new EffectEntry(Fx.blockCrash).data(Block.class).bounds(100.0f), "placeBlock", new EffectEntry(Fx.placeBlock).size(), "placeBlockSpark", new EffectEntry(Fx.coreLaunchConstruct).size(), "breakBlock", new EffectEntry(Fx.breakBlock).size(), "spawn", new EffectEntry(Fx.spawn), "trail", new EffectEntry(Fx.colorTrail).size().color(), "breakProp", new EffectEntry(Fx.breakProp).size().color(), "smokeCloud", new EffectEntry(Fx.missileTrailSmoke).color(), "vapor", new EffectEntry(Fx.vapor).color(), "hit", new EffectEntry(Fx.hitBulletColor).color(), "hitSquare", new EffectEntry(Fx.hitSquaresColor).color(), "shootSmall", new EffectEntry(Fx.shootSmall).color().rotate(), "shootBig", new EffectEntry(Fx.shootTitan).color().rotate(), "smokeSmall", new EffectEntry(Fx.shootSmallSmoke).rotate(), "smokeBig", new EffectEntry(Fx.shootBigSmoke).rotate(), "smokeColor", new EffectEntry(Fx.shootSmokeTitan).rotate().color(), "smokeSquare", new EffectEntry(Fx.shootSmokeSquare).rotate().color(), "smokeSquareBig", new EffectEntry(Fx.shootSmokeSquareBig).rotate().color(), "spark", new EffectEntry(Fx.hitLaserBlast).color(), "sparkBig", new EffectEntry(Fx.circleColorSpark).color(), "sparkShoot", new EffectEntry(Fx.colorSpark).rotate().color(), "sparkShootBig", new EffectEntry(Fx.randLifeSpark).rotate().color(), "drill", new EffectEntry(Fx.mine).color(), "drillBig", new EffectEntry(Fx.mineHuge).color(), "lightBlock", new EffectEntry(Fx.lightBlock).size().color(), "explosion", new EffectEntry(Fx.dynamicExplosion).size(), "smokePuff", new EffectEntry(Fx.smokePuff).color(), "sparkExplosion", new EffectEntry(Fx.titanExplosion).color(), "crossExplosion", new EffectEntry(Fx.dynamicSpikes).size().color(), "wave", new EffectEntry(Fx.dynamicWave).size().color(), "bubble", new EffectEntry(Fx.airBubble));
        map.each((n, e) -> {
            e.name = n;
        });
    }

    public static class EffectEntry {
        public String name = "";
        public Effect effect;
        public boolean size;
        public boolean rotate;
        public boolean color;
        @Nullable
        public Class<?> data;
        public float bounds = -1.0f;

        public EffectEntry(Effect effect) {
            this.effect = effect;
        }

        public EffectEntry bounds(float bounds) {
            this.bounds = bounds;
            return this;
        }

        public EffectEntry name(String name) {
            this.name = name;
            return this;
        }

        public EffectEntry size() {
            this.size = true;
            return this;
        }

        public EffectEntry rotate() {
            this.rotate = true;
            return this;
        }

        public EffectEntry color() {
            this.color = true;
            return this;
        }

        public EffectEntry data(Class<?> data) {
            this.data = data;
            return this;
        }
    }
}

