/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import mindustry.content.Blocks;
import mindustry.maps.filters.FilterOption;
import mindustry.maps.filters.GenerateFilter;
import mindustry.world.Block;
import mindustry.world.Tile;

public class BlendFilter
extends GenerateFilter {
    public float radius = 2.0f;
    public Block block = Blocks.sand;
    public Block floor = Blocks.sandWater;
    public Block ignore = Blocks.air;

    @Override
    public FilterOption[] options() {
        return new FilterOption[]{new FilterOption.SliderOption("radius", () -> this.radius, f -> {
            this.radius = f;
        }, 1.0f, 10.0f), new FilterOption.BlockOption("block", () -> this.block, b -> {
            this.block = b;
        }, FilterOption.anyOptional), new FilterOption.BlockOption("floor", () -> this.floor, b -> {
            this.floor = b;
        }, FilterOption.anyOptional), new FilterOption.BlockOption("ignore", () -> this.ignore, b -> {
            this.ignore = b;
        }, FilterOption.anyOptional)};
    }

    @Override
    public boolean isBuffered() {
        return true;
    }

    @Override
    public char icon() {
        return '\uf8f1';
    }

    @Override
    public void apply(GenerateFilter.GenerateInput in) {
        if (in.floor == this.block || this.block == Blocks.air || in.floor == this.ignore || !this.floor.isFloor() && (in.block == this.block || in.block == this.ignore)) {
            return;
        }
        int rad = (int)this.radius;
        boolean found = false;
        block0: for (int x = -rad; x <= rad; ++x) {
            for (int y = -rad; y <= rad; ++y) {
                Tile tile;
                if (x * x + y * y > rad * rad || (tile = in.tile(in.x + x, in.y + y)).floor() != this.block && tile.block() != this.block && tile.overlay() != this.block) continue;
                found = true;
                break block0;
            }
        }
        if (found) {
            if (!this.floor.isFloor()) {
                in.block = this.floor;
            } else {
                in.floor = this.floor;
            }
        }
    }
}

