/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import arc.math.Mathf;
import arc.struct.Seq;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.ai.Astar;
import mindustry.content.Blocks;
import mindustry.maps.filters.FilterOption;
import mindustry.maps.filters.GenerateFilter;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.Tiles;
import mindustry.world.blocks.storage.CoreBlock;

public class SpawnPathFilter
extends GenerateFilter {
    public int radius = 3;
    public Block block = Blocks.air;

    @Override
    public FilterOption[] options() {
        return new FilterOption[]{new FilterOption.SliderOption("radius", () -> this.radius, f -> {
            this.radius = (int)f;
        }, 1.0f, 20.0f).display(), new FilterOption.BlockOption("wall", () -> this.block, b -> {
            this.block = b;
        }, FilterOption.wallsOnly)};
    }

    @Override
    public char icon() {
        return '\uf850';
    }

    @Override
    public void apply(Tiles tiles, GenerateFilter.GenerateInput in) {
        Seq<Tile> cores = new Seq<Tile>();
        Seq<Tile> spawns = new Seq<Tile>();
        for (Tile tile2 : tiles) {
            if (tile2.overlay() == Blocks.spawn) {
                spawns.add(tile2);
            }
            if (!(tile2.block() instanceof CoreBlock) || tile2.team() == Vars.state.rules.waveTeam) continue;
            cores.add(tile2);
        }
        for (Tile core : cores) {
            for (Tile spawn : spawns) {
                Seq<Tile> path = Astar.pathfind(core.x, core.y, spawn.x, spawn.y, t -> t.solid() ? 100.0f : 1.0f, Astar.manhattan, tile -> !tile.floor().isDeep());
                for (Tile tile3 : path) {
                    for (int x = -this.radius; x <= this.radius; ++x) {
                        for (int y = -this.radius; y <= this.radius; ++y) {
                            Tile other;
                            int wx = tile3.x + x;
                            int wy = tile3.y + y;
                            if (!Structs.inBounds(wx, wy, Vars.world.width(), Vars.world.height()) || !Mathf.within(x, y, this.radius) || (other = tiles.getn(wx, wy)).synthetic()) continue;
                            other.setBlock(this.block);
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean isPost() {
        return true;
    }
}

