/*
 * Decompiled with CFR 0.152.
 */
package mindustry.net;

import arc.Core;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Ratekeeper;
import arc.util.Time;
import java.io.IOException;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Call;
import mindustry.gen.Player;
import mindustry.net.Net;
import mindustry.net.Packets;
import mindustry.net.Streamable;

public abstract class NetConnection {
    public final String address;
    public String uuid;
    public String usid;
    public boolean mobile;
    public boolean modclient;
    @Nullable
    public Player player;
    public boolean kicked;
    public long syncTime;
    public long connectTime;
    public int lastReceivedClientSnapshot;
    public int snapshotsSent;
    public long lastReceivedClientTime;
    public Seq<BuildPlan> rejectedRequests;
    public Ratekeeper chatRate;
    public Ratekeeper packetRate;
    public boolean hasConnected;
    public boolean hasBegunConnecting;
    public boolean hasDisconnected;
    public float viewWidth;
    public float viewHeight;
    public float viewX;
    public float viewY;

    public NetConnection(String address) {
        this.usid = this.uuid = "AAAAAAAA";
        this.kicked = false;
        this.connectTime = Time.millis();
        this.lastReceivedClientSnapshot = -1;
        this.rejectedRequests = new Seq();
        this.chatRate = new Ratekeeper();
        this.packetRate = new Ratekeeper();
        this.address = address;
    }

    public void kick() {
        this.kick(Packets.KickReason.kick);
    }

    public void kick(Packets.KickReason reason) {
        this.kick(reason, reason == Packets.KickReason.kick || reason == Packets.KickReason.banned || reason == Packets.KickReason.vote ? 30000L : 0L);
    }

    public void kick(Packets.KickReason reason, long kickDuration) {
        this.kick(null, reason, kickDuration);
    }

    public void kick(String reason) {
        this.kick(reason, null, 30000L);
    }

    public void kick(String reason, long duration) {
        this.kick(reason, null, duration);
    }

    private void kick(String reason, @Nullable Packets.KickReason kickType, long kickDuration) {
        if (this.kicked) {
            return;
        }
        Log.info("Kicking connection @ / @; Reason: @", this.address, this.uuid, reason == null ? kickType.name() : reason.replace("\n", " "));
        if (kickDuration > 0L) {
            Vars.netServer.admins.handleKicked(this.uuid, this.address, kickDuration);
        }
        if (reason == null) {
            Call.kick(this, kickType);
        } else {
            Call.kick(this, reason);
        }
        if (this.uuid.startsWith("steam:")) {
            Core.app.post(() -> Core.app.post(this::close));
        } else {
            this.close();
        }
        Vars.netServer.admins.save();
        this.kicked = true;
    }

    public boolean isConnected() {
        return true;
    }

    public void sendStream(Streamable stream) {
        try {
            Packets.StreamBegin begin = new Packets.StreamBegin();
            begin.total = stream.stream.available();
            begin.type = Net.getPacketId(stream);
            this.send(begin, true);
            int cid = begin.id;
            while (stream.stream.available() > 0) {
                byte[] bytes = new byte[Math.min(900, stream.stream.available())];
                stream.stream.read(bytes);
                Packets.StreamChunk chunk = new Packets.StreamChunk();
                chunk.id = cid;
                chunk.data = bytes;
                this.send(chunk, true);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract void send(Object var1, boolean var2);

    public abstract void close();
}

