/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Liquids;
import mindustry.entities.Puddles;
import mindustry.game.EventType;
import mindustry.gen.Puddle;
import mindustry.type.Liquid;
import mindustry.world.Tile;

public class CellLiquid
extends Liquid {
    public Color colorFrom = Color.white.cpy();
    public Color colorTo = Color.white.cpy();
    public int cells = 8;
    @Nullable
    public Liquid spreadTarget;
    public float maxSpread = 0.75f;
    public float spreadConversion = 1.2f;
    public float spreadDamage = 0.11f;
    public float removeScaling = 0.25f;

    public CellLiquid(String name, Color color) {
        super(name, color);
    }

    public CellLiquid(String name) {
        super(name);
    }

    @Override
    public void update(Puddle puddle) {
        if (!Vars.state.rules.fire) {
            return;
        }
        if (this.spreadTarget != null) {
            Tile tile;
            float scaling = Mathf.pow(Mathf.clamp(puddle.amount / 70.0f), 2.0f);
            boolean reacted = false;
            for (Point2 point : Geometry.d4c) {
                tile = puddle.tile.nearby(point);
                if (tile == null || tile.build == null || tile.build.liquids == null || !(tile.build.liquids.get(this.spreadTarget) > 1.0E-4f)) continue;
                float amount = Math.min(tile.build.liquids.get(this.spreadTarget), this.maxSpread * Time.delta * scaling);
                tile.build.liquids.remove(this.spreadTarget, amount * this.removeScaling);
                Puddles.deposit(tile, this, amount * this.spreadConversion);
                reacted = true;
            }
            if (this.spreadDamage > 0.0f && puddle.tile.build != null && puddle.tile.build.liquids != null && puddle.tile.build.liquids.get(this.spreadTarget) > 1.0E-4f) {
                reacted = true;
                float amountSpread = Math.min(puddle.tile.build.liquids.get(this.spreadTarget) * this.spreadConversion, this.maxSpread * Time.delta) / 2.0f;
                Point2[] point2Array = Geometry.d4;
                int n = point2Array.length;
                for (int point = 0; point < n; ++point) {
                    Point2 dir = point2Array[point];
                    Tile other = puddle.tile.nearby(dir);
                    if (other == null) continue;
                    Puddles.deposit(puddle.tile, other, puddle.liquid, amountSpread);
                }
                puddle.tile.build.damage(this.spreadDamage * Time.delta * scaling);
            }
            for (Point2 point : Geometry.d4) {
                Puddle other;
                tile = puddle.tile.nearby(point);
                if (tile == null || (other = Puddles.get(tile)) == null || other.liquid != this.spreadTarget) continue;
                float amount = Math.min(other.amount, Math.max(this.maxSpread * Time.delta * scaling, other.amount * 0.25f * scaling));
                other.amount -= amount;
                puddle.amount += amount;
                reacted = true;
                if (!(other.amount <= 23.333334f)) continue;
                other.remove();
                Puddles.deposit(tile, puddle.tile, this, Math.max(amount, 23.333334f));
            }
            if (reacted && this == Liquids.neoplasm) {
                Events.fire(EventType.Trigger.neoplasmReact);
            }
        }
    }

    @Override
    public float react(Liquid other, float amount, Tile tile, float x, float y) {
        if (other == this.spreadTarget) {
            return amount;
        }
        return 0.0f;
    }

    @Override
    public void drawPuddle(Puddle puddle) {
        super.drawPuddle(puddle);
        float baseLayer = puddle.tile != null && puddle.tile.block().solid || puddle.tile.build != null ? 35.0f : 19.5f;
        int id = puddle.id;
        float amount = puddle.amount;
        float x = puddle.x;
        float y = puddle.y;
        float f = Mathf.clamp(amount / 46.666668f);
        float smag = puddle.tile.floor().isLiquid ? 0.8f : 0.0f;
        float sscl = 25.0f;
        float length = Math.max(f, 0.3f) * 9.0f;
        rand.setSeed(id);
        for (int i = 0; i < this.cells; ++i) {
            Draw.z(baseLayer + (float)i / 1000.0f + (float)(id % 100) / 10000.0f);
            Tmp.v1.trns(rand.random(360.0f), rand.random(length));
            float vx = x + Tmp.v1.x;
            float vy = y + Tmp.v1.y;
            Draw.color(this.colorFrom, this.colorTo, rand.random(1.0f));
            Fill.circle(vx + Mathf.sin(Time.time + (float)(i * 532), sscl, smag), vy + Mathf.sin(Time.time + (float)(i * 53), sscl, smag), f * 3.8f * rand.random(0.2f, 1.0f) * Mathf.absin(Time.time + (float)((i + id) % 60 * 54), 75.0f * rand.random(1.0f, 2.0f), 1.0f));
        }
        Draw.color();
    }
}

