/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.func.Boolf;
import arc.struct.ObjectIntMap;
import arc.struct.Seq;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.util.Iterator;
import mindustry.Vars;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.type.PayloadStack;

public class PayloadSeq {
    private ObjectIntMap<UnlockableContent> payloads = new ObjectIntMap();
    private int total;

    public boolean isEmpty() {
        return this.total == 0;
    }

    public boolean any() {
        return this.total > 0;
    }

    public int total() {
        return this.total;
    }

    public void add(UnlockableContent block) {
        this.add(block, 1);
    }

    public void add(UnlockableContent block, int amount) {
        if (block == null) {
            return;
        }
        this.payloads.increment(block, amount);
        this.total += amount;
    }

    public void remove(UnlockableContent block) {
        this.add(block, -1);
    }

    public void remove(UnlockableContent block, int amount) {
        this.add(block, -amount);
    }

    public void remove(Seq<PayloadStack> stacks) {
        stacks.each(b -> this.remove(b.item, b.amount));
    }

    public PayloadSeq removeAll(Boolf<UnlockableContent> pred) {
        Iterator iter = this.payloads.iterator();
        while (((ObjectIntMap.Entries)iter).hasNext()) {
            Object e = ((ObjectIntMap.Entries)iter).next();
            if (!pred.get((UnlockableContent)((ObjectIntMap.Entry)e).key)) continue;
            ((ObjectIntMap.Entries)iter).remove();
            this.total -= ((ObjectIntMap.Entry)e).value;
        }
        return this;
    }

    public void clear() {
        this.payloads.clear();
        this.total = 0;
    }

    public int get(UnlockableContent block) {
        return this.payloads.get(block);
    }

    public boolean contains(Seq<PayloadStack> stacks) {
        return !stacks.contains((PayloadStack)((Object)((Boolf<PayloadStack>)b -> this.get(b.item) < b.amount)));
    }

    public boolean contains(UnlockableContent block, int amount) {
        return this.get(block) >= amount;
    }

    public boolean contains(UnlockableContent block) {
        return this.get(block) >= 1;
    }

    public boolean contains(PayloadStack stack) {
        return this.get(stack.item) >= stack.amount;
    }

    public void write(Writes write) {
        write.s(-this.payloads.size);
        for (ObjectIntMap.Entry entry : this.payloads.entries()) {
            write.b(((UnlockableContent)entry.key).getContentType().ordinal());
            write.s(((UnlockableContent)entry.key).id);
            write.i(entry.value);
        }
    }

    public void read(Reads read) {
        this.total = 0;
        this.payloads.clear();
        int amount = read.s();
        if (amount >= 0) {
            for (int i = 0; i < amount; ++i) {
                this.add(Vars.content.block(read.s()), read.i());
            }
        } else {
            for (int i = 0; i < -amount; ++i) {
                this.add((UnlockableContent)Vars.content.getByID(ContentType.all[read.ub()], read.s()), read.i());
            }
        }
    }
}

