/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.Events;
import arc.flabel.FLabel;
import arc.math.Interp;
import arc.math.Mathf;
import arc.scene.Action;
import arc.scene.actions.Actions;
import arc.scene.ui.Label;
import arc.scene.ui.layout.Table;
import arc.util.Time;
import mindustry.Vars;
import mindustry.core.GameState;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class GameOverDialog
extends BaseDialog {
    private Team winner;
    private boolean hudShown;

    public GameOverDialog() {
        super("@gameover");
        this.setFillParent(true);
        this.titleTable.remove();
        this.shown(() -> {
            this.hudShown = Vars.ui.hudfrag.shown;
            Vars.ui.hudfrag.shown = false;
            this.rebuild();
        });
        this.hidden(() -> {
            Vars.ui.hudfrag.shown = this.hudShown;
        });
        Events.on(EventType.ResetEvent.class, e -> this.hide());
    }

    public void show(Team winner) {
        this.winner = winner;
        this.show();
        if (winner == Vars.player.team()) {
            Events.fire(new EventType.WinEvent());
        } else {
            Events.fire(new EventType.LoseEvent());
        }
    }

    void rebuild() {
        this.buttons.clear();
        this.cont.clear();
        this.buttons.margin(10.0f);
        this.cont.table((Table t) -> {
            if (Vars.state.rules.pvp && this.winner != null) {
                t.add(Core.bundle.format("gameover.pvp", this.winner.coloredName())).center().pad(6.0f);
            } else {
                t.add(Vars.state.isCampaign() ? Core.bundle.format("sector.lost", Vars.state.getSector().name()) : "@gameover").center().pad(6.0f);
            }
            t.row();
            if (Vars.control.isHighScore()) {
                t.add("@highscore").pad(6.0f);
                t.row();
            }
            t.pane((Table p) -> {
                p.margin(13.0f);
                p.left().defaults().left();
                p.setBackground(Styles.black3);
                p.table((Table stats) -> {
                    if (Vars.state.rules.waves) {
                        this.addStat((Table)stats, Core.bundle.get("stats.wave"), Vars.state.stats.wavesLasted, 0.0f);
                    }
                    this.addStat((Table)stats, Core.bundle.get("stats.unitsCreated"), Vars.state.stats.unitsCreated, 0.05f);
                    this.addStat((Table)stats, Core.bundle.get("stats.enemiesDestroyed"), Vars.state.stats.enemyUnitsDestroyed, 0.1f);
                    this.addStat((Table)stats, Core.bundle.get("stats.built"), Vars.state.stats.buildingsBuilt, 0.15f);
                    this.addStat((Table)stats, Core.bundle.get("stats.destroyed"), Vars.state.stats.buildingsDestroyed, 0.2f);
                    this.addStat((Table)stats, Core.bundle.get("stats.deconstructed"), Vars.state.stats.buildingsDeconstructed, 0.25f);
                }).top().grow().row();
                if (Vars.control.saves.getCurrent() != null) {
                    p.table((Table pt) -> {
                        pt.add(new FLabel(Core.bundle.get("stats.playtime"))).left().pad(5.0f).growX();
                        pt.add(new FLabel("[accent]" + Vars.control.saves.getCurrent().getPlayTime())).right().pad(5.0f);
                    }).growX();
                }
            }).grow().pad(12.0f).top();
        }).center().minWidth(370.0f).maxSize(600.0f, 550.0f).grow();
        if (Vars.state.isCampaign() && Vars.net.client()) {
            this.cont.row();
            this.cont.add("@gameover.waiting").padTop(20.0f).row();
        }
        if (Vars.state.isCampaign()) {
            if (Vars.net.client()) {
                this.buttons.button("@gameover.disconnect", () -> {
                    Vars.logic.reset();
                    Vars.net.reset();
                    this.hide();
                    Vars.state.set(GameState.State.menu);
                }).size(170.0f, 60.0f);
            } else {
                this.buttons.button("@continue", () -> {
                    this.hide();
                    Vars.ui.planet.show();
                }).size(170.0f, 60.0f);
            }
        } else {
            this.buttons.button("@menu", () -> {
                this.hide();
                if (!Vars.ui.paused.checkPlaytest()) {
                    Vars.logic.reset();
                }
            }).size(140.0f, 60.0f);
        }
    }

    private void addStat(Table parent, String stat, int value, float delay) {
        parent.add(new StatLabel(stat, value, delay)).top().pad(5.0f).growX().height(50.0f).row();
    }

    private static class StatLabel
    extends Table {
        private float progress = 0.0f;

        public StatLabel(String stat, int value, float delay) {
            this.setTransform(true);
            this.setClip(true);
            this.setBackground(Tex.whiteui);
            this.setColor(Pal.accent);
            this.margin(2.0f);
            FLabel statLabel = new FLabel(stat);
            statLabel.setStyle(Styles.outlineLabel);
            statLabel.setWrap(true);
            statLabel.pause();
            Label valueLabel = new Label("", Styles.outlineLabel);
            valueLabel.setAlignment(16);
            this.add(statLabel).left().growX().padLeft(5.0f);
            this.add(valueLabel).right().growX().padRight(5.0f);
            this.actions(Actions.scaleTo(0.0f, 1.0f), Actions.delay(delay), Actions.parallel((Action)Actions.scaleTo(1.0f, 1.0f, 0.3f, Interp.pow3Out), (Action)Actions.color(Pal.darkestGray, 0.3f, Interp.pow3Out), (Action)Actions.sequence((Action)Actions.delay(0.3f), (Action)Actions.run(() -> {
                valueLabel.update(() -> {
                    this.progress = Math.min(1.0f, this.progress + Time.delta / 60.0f);
                    valueLabel.setText("" + (int)Mathf.lerp(0.0f, value, value < 10 ? this.progress : Interp.slowFast.apply(this.progress)));
                });
                statLabel.resume();
            }))));
        }
    }
}

