/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import mindustry.Vars;
import mindustry.gen.Icon;
import mindustry.maps.Map;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.LoadDialog;
import mindustry.ui.dialogs.SaveDialog;

public class PausedDialog
extends BaseDialog {
    private SaveDialog save = new SaveDialog();
    private LoadDialog load = new LoadDialog();
    private boolean wasClient = false;

    public PausedDialog() {
        super("@menu");
        this.shouldPause = true;
        this.shown(this::rebuild);
        this.addCloseListener();
    }

    void rebuild() {
        this.cont.clear();
        this.update(() -> {
            if (Vars.state.isMenu() && this.isShown()) {
                this.hide();
            }
        });
        if (!Vars.mobile) {
            float dw = 220.0f;
            this.cont.defaults().width(dw).height(55.0f).pad(5.0f);
            this.cont.button("@objective", Icon.info, () -> Vars.ui.fullText.show("@objective", Vars.state.rules.sector.preset.description)).visible(() -> Vars.state.rules.sector != null && Vars.state.rules.sector.preset != null && Vars.state.rules.sector.preset.description != null).padTop(-60.0f);
            this.cont.button("@abandon", Icon.cancel, () -> Vars.ui.planet.abandonSectorConfirm(Vars.state.rules.sector, this::hide)).padTop(-60.0f).disabled(b -> Vars.net.client()).visible(() -> Vars.state.rules.sector != null).row();
            this.cont.button("@back", Icon.left, this::hide).name("back");
            this.cont.button("@settings", Icon.settings, Vars.ui.settings::show).name("settings");
            if (!Vars.state.isCampaign() && !Vars.state.isEditor()) {
                this.cont.row();
                this.cont.button("@savegame", Icon.save, this.save::show);
                this.cont.button("@loadgame", Icon.upload, this.load::show).disabled(b -> Vars.net.active());
            }
            this.cont.row();
            this.cont.button("@hostserver", Icon.host, () -> {
                if (Vars.net.server() && Vars.steam) {
                    Vars.platform.inviteFriends();
                } else {
                    Vars.ui.host.show();
                }
            }).disabled(b -> (!Vars.steam || !Vars.net.server()) && Vars.net.active()).colspan(2).width(dw * 2.0f + 10.0f).update((T e) -> e.setText(Vars.net.server() && Vars.steam ? "@invitefriends" : "@hostserver"));
            this.cont.row();
            this.cont.button("@quit", Icon.exit, this::showQuitConfirm).colspan(2).width(dw + 10.0f).update((T s) -> s.setText(Vars.control.saves.getCurrent() != null && Vars.control.saves.getCurrent().isAutosave() ? "@save.quit" : "@quit"));
        } else {
            this.cont.defaults().size(130.0f).pad(5.0f);
            this.cont.buttonRow("@back", Icon.play, this::hide);
            this.cont.buttonRow("@settings", Icon.settings, Vars.ui.settings::show);
            if (!Vars.state.isCampaign() && !Vars.state.isEditor()) {
                this.cont.buttonRow("@save", Icon.save, this.save::show);
                this.cont.row();
                this.cont.buttonRow("@load", Icon.download, this.load::show).disabled(b -> Vars.net.active());
            } else if (Vars.state.isCampaign()) {
                this.cont.buttonRow("@research", Icon.tree, Vars.ui.research::show);
                this.cont.row();
                this.cont.buttonRow("@planetmap", Icon.map, () -> {
                    this.hide();
                    Vars.ui.planet.show();
                });
            } else {
                this.cont.row();
            }
            this.cont.buttonRow("@hostserver.mobile", Icon.host, Vars.ui.host::show).disabled(b -> Vars.net.active());
            this.cont.buttonRow("@quit", Icon.exit, this::showQuitConfirm).update((T s) -> {
                s.setText(Vars.control.saves.getCurrent() != null && Vars.control.saves.getCurrent().isAutosave() ? "@save.quit" : "@quit");
                s.getLabelCell().growX().wrap();
            });
        }
    }

    void showQuitConfirm() {
        Runnable quit = () -> {
            this.runExitSave();
            this.hide();
        };
        if (Vars.confirmExit) {
            Vars.ui.showConfirm("@confirm", "@quit.confirm", quit);
        } else {
            quit.run();
        }
    }

    public boolean checkPlaytest() {
        if (Vars.state.playtestingMap != null) {
            Map testing = Vars.state.playtestingMap;
            Vars.logic.reset();
            Vars.ui.editor.resumeAfterPlaytest(testing);
            return true;
        }
        return false;
    }

    public void runExitSave() {
        this.wasClient = Vars.net.client();
        if (Vars.net.client()) {
            Vars.netClient.disconnectQuietly();
        }
        if (Vars.state.isEditor() && !this.wasClient) {
            Vars.ui.editor.resumeEditing();
            return;
        }
        if (this.checkPlaytest()) {
            return;
        }
        if (Vars.control.saves.getCurrent() == null || !Vars.control.saves.getCurrent().isAutosave() || this.wasClient || Vars.state.gameOver) {
            Vars.logic.reset();
            return;
        }
        Vars.ui.loadAnd("@saving", () -> {
            try {
                Vars.control.saves.getCurrent().save();
            }
            catch (Throwable e) {
                e.printStackTrace();
                Vars.ui.showException("[accent]" + Core.bundle.get("savefail"), e);
            }
            Vars.logic.reset();
        });
    }
}

