/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.Events;
import arc.KeyBinds;
import arc.func.Boolf;
import arc.func.Boolp;
import arc.func.Cons;
import arc.func.Floatp;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Interp;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.actions.Actions;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.Tooltip;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Table;
import arc.struct.Bits;
import arc.struct.Seq;
import arc.util.Scaling;
import arc.util.Time;
import arc.util.Tmp;
import java.lang.invoke.LambdaMetafactory;
import mindustry.Vars;
import mindustry.content.StatusEffects;
import mindustry.core.GameState;
import mindustry.core.UI;
import mindustry.core.World;
import mindustry.ctype.UnlockableContent;
import mindustry.game.EventType;
import mindustry.game.MapObjectives;
import mindustry.game.SpawnGroup;
import mindustry.game.Team;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Call;
import mindustry.gen.Icon;
import mindustry.gen.Payloadc;
import mindustry.gen.Player;
import mindustry.gen.Sounds;
import mindustry.gen.Tex;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Binding;
import mindustry.net.Packets;
import mindustry.type.Item;
import mindustry.type.StatusEffect;
import mindustry.ui.Bar;
import mindustry.ui.CoreItemsDisplay;
import mindustry.ui.IntFormat;
import mindustry.ui.Minimap;
import mindustry.ui.Styles;
import mindustry.ui.fragments.PlacementFragment;

public class HudFragment {
    private static final float dsize = 65.0f;
    private static final float pauseHeight = 36.0f;
    public final PlacementFragment blockfrag = new PlacementFragment();
    public boolean shown = true;
    private ImageButton flip;
    private CoreItemsDisplay coreItems = new CoreItemsDisplay();
    private String hudText = "";
    private boolean showHudText;
    private Table lastUnlockTable;
    private Table lastUnlockLayout;
    private long lastToast;

    public void build(Group parent) {
        Events.on(EventType.WaveEvent.class, e -> {
            int max = 10;
            int winWave = Vars.state.rules.winWave > 0 ? Vars.state.rules.winWave : Integer.MAX_VALUE;
            block0: for (int i = Vars.state.wave - 1; i <= Math.min(Vars.state.wave + max, winWave - 2); ++i) {
                for (SpawnGroup group : Vars.state.rules.spawns) {
                    if (group.effect != StatusEffects.boss || group.getSpawned(i) <= 0) continue;
                    int diff = i + 2 - Vars.state.wave;
                    if (diff != 1 && diff != 2 && diff != 5 && diff != 10) break block0;
                    this.showToast(Icon.warning, group.type.emoji() + " " + Core.bundle.format("wave.guardianwarn" + (diff == 1 ? ".one" : ""), diff));
                    break block0;
                }
            }
        });
        Events.on(EventType.SectorCaptureEvent.class, e -> this.showToast(Core.bundle.format("sector.captured", e.sector.isBeingPlayed() ? "" : e.sector.name() + " ")));
        Events.on(EventType.SectorLoseEvent.class, e -> this.showToast(Icon.warning, Core.bundle.format("sector.lost", e.sector.name())));
        Events.on(EventType.SectorInvasionEvent.class, e -> this.showToast(Icon.warning, Core.bundle.format("sector.attacked", e.sector.name())));
        Events.on(EventType.ResetEvent.class, e -> {
            this.coreItems.resetUsed();
            this.coreItems.clear();
        });
        parent.fill(t -> {
            t.name = "paused";
            t.top().visible((Boolp)(Boolp)LambdaMetafactory.metafactory(null, null, null, ()Z, lambda$build$5(), ()Z)((HudFragment)this)).touchable = Touchable.disabled;
            t.table(Styles.black6, top -> top.label(() -> Vars.state.gameOver && Vars.state.isCampaign() ? "@sector.curlost" : "@paused").style(Styles.outlineLabel).pad(8.0f)).height(36.0f).growX();
        });
        parent.fill(t -> {
            t.name = "waiting";
            t.visible((Boolp)(Boolp)LambdaMetafactory.metafactory(null, null, null, ()Z, lambda$build$9(), ()Z)((HudFragment)this)).touchable = Touchable.disabled;
            t.table(Styles.black6, top -> top.add("@waiting.players").style(Styles.outlineLabel).pad(18.0f));
        });
        parent.fill(t -> {
            t.name = "minimap/position";
            t.visible(() -> Core.settings.getBool("minimap") && this.shown);
            t.add(new Minimap()).name("minimap");
            t.row();
            t.label(() -> (Core.settings.getBool("position") ? Vars.player.tileX() + "," + Vars.player.tileY() + "\n" : "") + (Core.settings.getBool("mouseposition") ? "[lightgray]" + World.toTile(Core.input.mouseWorldX()) + "," + World.toTile(Core.input.mouseWorldY()) : "")).visible(() -> Core.settings.getBool("position") || Core.settings.getBool("mouseposition")).touchable(Touchable.disabled).style(Styles.outlineLabel).name("position");
            t.top().right();
        });
        Vars.ui.hints.build(parent);
        parent.fill(cont -> {
            cont.name = "overlaymarker";
            cont.top().left();
            if (Vars.mobile) {
                cont.rect((x, y, w, h) -> {
                    if (Core.scene.marginTop > 0.0f) {
                        Tex.paneRight.draw(x, y, w, Core.scene.marginTop);
                    }
                }).fillX().row();
                cont.table(select -> {
                    select.name = "mobile buttons";
                    select.left();
                    select.defaults().size(65.0f).left();
                    ImageButton.ImageButtonStyle style = Styles.cleari;
                    select.button((Drawable)Icon.menu, style, Vars.ui.paused::show).name("menu");
                    this.flip = select.button((Drawable)Icon.upOpen, style, this::toggleMenus).get();
                    this.flip.name = "flip";
                    select.button((Drawable)Icon.paste, style, Vars.ui.schematics::show).name("schematics");
                    select.button((Drawable)Icon.pause, style, () -> {
                        if (Vars.net.active()) {
                            Vars.ui.listfrag.toggle();
                        } else {
                            Vars.state.set(Vars.state.isPaused() ? GameState.State.playing : GameState.State.paused);
                        }
                    }).name("pause").update(i -> {
                        if (Vars.net.active()) {
                            i.getStyle().imageUp = Icon.players;
                        } else {
                            i.setDisabled(false);
                            i.getStyle().imageUp = Vars.state.isPaused() ? Icon.play : Icon.pause;
                        }
                    });
                    select.button((Drawable)Icon.chat, style, () -> {
                        if (Vars.net.active() && Vars.mobile) {
                            if (Vars.ui.chatfrag.shown()) {
                                Vars.ui.chatfrag.hide();
                            } else {
                                Vars.ui.chatfrag.toggle();
                            }
                        } else if (Vars.state.isCampaign()) {
                            Vars.ui.research.show();
                        } else {
                            Vars.ui.database.show();
                        }
                    }).name("chat").update(i -> {
                        i.getStyle().imageUp = Vars.net.active() && Vars.mobile ? Icon.chat : (Vars.state.isCampaign() ? Icon.tree : Icon.book);
                    });
                    select.image().color(Pal.gray).width(4.0f).fillY();
                });
                cont.row();
                cont.image().height(4.0f).color(Pal.gray).fillX();
                cont.row();
            }
            cont.update(() -> {
                if (Core.input.keyTap(Binding.toggle_menus) && !Vars.ui.chatfrag.shown() && !Core.scene.hasDialog() && !Core.scene.hasField()) {
                    Core.settings.getBoolOnce("ui-hidden", () -> Vars.ui.announce(Core.bundle.format("showui", Core.keybinds.get((KeyBinds.KeyBind)Binding.toggle_menus).key.toString(), 11)));
                    this.toggleMenus();
                }
            });
            Element[] elementArray = new Element[2];
            Table wavesMain = new Table();
            elementArray[0] = wavesMain;
            Table editorMain = new Table();
            elementArray[1] = editorMain;
            cont.stack(elementArray).height(wavesMain.getPrefHeight()).name("waves/editor");
            wavesMain.visible(() -> this.shown && !Vars.state.isEditor());
            wavesMain.top().left().name = "waves";
            wavesMain.table(s -> {
                s.add(this.makeStatusTable()).grow().name("status");
                ImageButton.ImageButtonStyle rightStyle = new ImageButton.ImageButtonStyle(){
                    {
                        this.over = Tex.buttonRightOver;
                        this.down = Tex.buttonRightDown;
                        this.up = Tex.buttonRight;
                        this.disabled = Tex.buttonRightDisabled;
                        this.imageDisabledColor = Color.clear;
                        this.imageUpColor = Color.white;
                    }
                };
                s.button(Icon.play, rightStyle, 30.0f, () -> {
                    if (Vars.net.client() && Vars.player.admin) {
                        Call.adminRequest(Vars.player, Packets.AdminAction.wave, null);
                    } else {
                        Vars.logic.skipWave();
                    }
                }).growY().fillX().right().width(40.0f).disabled(b -> !this.canSkipWave()).name("skip").get().toBack();
            }).width(329.0f).name("statustable");
            wavesMain.row();
            this.addInfoTable(wavesMain.table().width(329.0f).left().get());
            editorMain.name = "editor";
            editorMain.table(Tex.buttonEdge4, t -> {
                t.name = "teams";
                t.add("@editor.teams").growX().left();
                t.row();
                t.table(teams -> {
                    teams.left();
                    int i = 0;
                    for (Team team : Team.baseTeams) {
                        ImageButton button = teams.button(Tex.whiteui, Styles.clearNoneTogglei, 40.0f, () -> Call.setPlayerTeamEditor(Vars.player, team)).size(50.0f).margin(6.0f).get();
                        button.getImageCell().grow();
                        button.getStyle().imageUpColor = team.color;
                        button.update(() -> button.setChecked(Vars.player.team() == team));
                        if (++i % 3 != 0) continue;
                        teams.row();
                    }
                }).left();
            }).width(329.0f);
            editorMain.visible(() -> this.shown && Vars.state.isEditor());
            cont.table(info -> {
                info.name = "fps/ping";
                info.touchable = Touchable.disabled;
                info.top().left().margin(4.0f).visible(() -> Core.settings.getBool("fps") && this.shown);
                IntFormat fps = new IntFormat("fps");
                IntFormat ping = new IntFormat("ping");
                IntFormat tps = new IntFormat("tps");
                IntFormat mem = new IntFormat("memory");
                IntFormat memnative = new IntFormat("memory2");
                info.label(() -> fps.get(Core.graphics.getFramesPerSecond())).left().style(Styles.outlineLabel).name("fps");
                info.row();
                if (Vars.android) {
                    info.label(() -> memnative.get((int)(Core.app.getJavaHeap() / 1024L / 1024L), (int)(Core.app.getNativeHeap() / 1024L / 1024L))).left().style(Styles.outlineLabel).name("memory2");
                } else {
                    info.label(() -> mem.get((int)(Core.app.getJavaHeap() / 1024L / 1024L))).left().style(Styles.outlineLabel).name("memory");
                }
                info.row();
                info.label(() -> ping.get(Vars.netClient.getPing())).visible(Vars.net::client).left().style(Styles.outlineLabel).name("ping").row();
                info.label(() -> tps.get(Vars.state.serverTps == -1 ? 60 : Vars.state.serverTps)).visible(Vars.net::client).left().style(Styles.outlineLabel).name("tps").row();
            }).top().left();
        });
        parent.fill(t -> {
            t.top();
            if (Core.settings.getBool("macnotch")) {
                t.margin(Vars.macNotchHeight);
            }
            t.visible(() -> this.shown);
            t.name = "coreinfo";
            t.collapser(v -> v.add().height(36.0f), () -> Vars.state.isPaused() && !Vars.netServer.isWaitingForPlayers()).row();
            t.table(c -> {
                c.top().collapser(this.coreItems, () -> Core.settings.getBool("coreitems") && !Vars.mobile && this.shown).fillX().row();
                float notifDuration = 240.0f;
                float[] coreAttackTime = new float[]{0.0f};
                Events.run((Object)EventType.Trigger.teamCoreDamage, () -> {
                    coreAttackTime[0] = notifDuration;
                });
                c.collapser(top -> top.background(Styles.black6).add("@coreattack").pad(8.0f).update(label -> label.color.set(Color.orange).lerp(Color.scarlet, Mathf.absin(Time.time, 2.0f, 1.0f))), true, () -> {
                    float f;
                    if (!this.shown || Vars.state.isPaused()) {
                        return false;
                    }
                    if (Vars.state.isMenu() || !Vars.player.team().data().hasCore()) {
                        coreAttackTime[0] = 0.0f;
                        return false;
                    }
                    coreAttackTime[0] = coreAttackTime[0] - Time.delta;
                    return f > 0.0f;
                }).touchable(Touchable.disabled).fillX().row();
            }).row();
            StringBuilder bossb = new StringBuilder();
            String bossText = Core.bundle.get("guardian");
            int maxBosses = 6;
            t.table(v -> v.margin(10.0f).add(new Bar(() -> {
                bossb.setLength(0);
                for (int i = 0; i < Math.min(Vars.state.teams.bosses.size, maxBosses); ++i) {
                    bossb.append(Vars.state.teams.bosses.get((int)i).type.emoji());
                }
                if (Vars.state.teams.bosses.size > maxBosses) {
                    bossb.append("[accent]+[]");
                }
                bossb.append(" ");
                bossb.append(bossText);
                return bossb;
            }, () -> Pal.health, () -> {
                if (Vars.state.boss() == null) {
                    return 0.0f;
                }
                float max = 0.0f;
                float val = 0.0f;
                for (Unit boss : Vars.state.teams.bosses) {
                    max += boss.maxHealth;
                    val += boss.health;
                }
                return max == 0.0f ? 0.0f : val / max;
            }).blink(Color.white).outline(new Color(0.0f, 0.0f, 0.0f, 0.6f), 7.0f)).grow()).fillX().width(320.0f).height(60.0f).name("boss").visible(() -> Vars.state.rules.waves && Vars.state.boss() != null && (!Vars.mobile || !Core.graphics.isPortrait())).padTop(7.0f).row();
            t.table(Styles.black3, p -> p.margin(4.0f).label(() -> this.hudText).style(Styles.outlineLabel)).touchable(Touchable.disabled).with(p -> p.visible(() -> {
                p.color.a = Mathf.lerpDelta(p.color.a, Mathf.num(this.showHudText), 0.2f);
                if (Vars.state.isMenu()) {
                    p.color.a = 0.0f;
                    this.showHudText = false;
                }
                return p.color.a >= 0.001f;
            }));
        });
        parent.fill(t -> {
            t.name = "nearpoint";
            t.touchable = Touchable.disabled;
            t.table((Drawable)Styles.black6, (Cons<Table>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$build$61(arc.scene.ui.layout.Table ), (Larc/scene/ui/layout/Table;)V)()).margin((float)6.0f).update((Cons<Table>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$build$62(arc.scene.ui.layout.Table ), (Larc/scene/ui/layout/Table;)V)()).get().color.a = 0.0f;
        });
        parent.fill(t -> {
            t.name = "saving";
            t.bottom().visible(() -> Vars.control.saves.isSaving());
            t.add("@saving").style(Styles.outlineLabel);
        });
        this.blockfrag.build(parent);
    }

    public static void setPlayerTeamEditor(Player player, Team team) {
        if (Vars.state.isEditor() && player != null) {
            player.team(team);
        }
    }

    public void setHudText(String text) {
        this.showHudText = true;
        this.hudText = text;
    }

    public void toggleHudText(boolean shown) {
        this.showHudText = shown;
    }

    private void scheduleToast(Runnable run) {
        long duration = 3500L;
        long since = Time.timeSinceMillis(this.lastToast);
        if (since > duration) {
            this.lastToast = Time.millis();
            run.run();
        } else {
            Time.runTask((float)(duration - since) / 1000.0f * 60.0f, run);
            this.lastToast += duration;
        }
    }

    public boolean hasToast() {
        return (float)Time.timeSinceMillis(this.lastToast) < 3500.0f;
    }

    public void showToast(String text) {
        this.showToast(Icon.ok, text);
    }

    public void showToast(Drawable icon, String text) {
        this.showToast(icon, -1.0f, text);
    }

    public void showToast(Drawable icon, float size, String text) {
        if (Vars.state.isMenu()) {
            return;
        }
        this.scheduleToast(() -> {
            Sounds.message.play();
            Table table = new Table(Tex.button);
            table.update(() -> {
                if (Vars.state.isMenu() || !Vars.ui.hudfrag.shown) {
                    table.remove();
                }
            });
            table.margin(12.0f);
            Cell<Image> cell = table.image(icon).pad(3.0f);
            if (size > 0.0f) {
                cell.size(size);
            }
            table.add(text).wrap().width(280.0f).get().setAlignment(1, 1);
            table.pack();
            Table container = Core.scene.table();
            container.top().add(table);
            container.setTranslation(0.0f, table.getPrefHeight());
            container.actions(Actions.translateBy(0.0f, -table.getPrefHeight(), 1.0f, Interp.fade), Actions.delay(2.5f), Actions.run(() -> container.actions(Actions.translateBy(0.0f, table.getPrefHeight(), 1.0f, Interp.fade), Actions.remove())));
        });
    }

    public void showUnlock(UnlockableContent content) {
        if (Vars.state.isMenu()) {
            return;
        }
        Sounds.message.play();
        if (this.lastUnlockTable == null) {
            this.scheduleToast(() -> {
                Table table = new Table(Tex.button);
                table.update(() -> {
                    if (Vars.state.isMenu()) {
                        table.remove();
                        this.lastUnlockLayout = null;
                        this.lastUnlockTable = null;
                    }
                });
                table.margin(12.0f);
                Table in = new Table();
                Image image = new Image(content.uiIcon);
                image.setScaling(Scaling.fit);
                in.add(image).size(48.0f).pad(2.0f);
                table.add(in).padRight(8.0f);
                table.add("@unlocked");
                table.pack();
                Table container = Core.scene.table();
                container.top().add(table);
                container.setTranslation(0.0f, table.getPrefHeight());
                container.actions(Actions.translateBy(0.0f, -table.getPrefHeight(), 1.0f, Interp.fade), Actions.delay(2.5f), Actions.run(() -> container.actions(Actions.translateBy(0.0f, table.getPrefHeight(), 1.0f, Interp.fade), Actions.run(() -> {
                    this.lastUnlockTable = null;
                    this.lastUnlockLayout = null;
                }), Actions.remove())));
                this.lastUnlockTable = container;
                this.lastUnlockLayout = in;
            });
        } else {
            int col = 3;
            int cap = col * col - 1;
            Seq<Element> elements = new Seq<Element>(this.lastUnlockLayout.getChildren());
            int esize = elements.size;
            if (esize > cap) {
                return;
            }
            float size = 48.0f / (float)Math.min(elements.size + 1, col);
            this.lastUnlockLayout.clearChildren();
            this.lastUnlockLayout.defaults().size(size).pad(2.0f);
            for (int i = 0; i < esize; ++i) {
                this.lastUnlockLayout.add(elements.get(i));
                if (i % col != col - 1) continue;
                this.lastUnlockLayout.row();
            }
            if (esize < cap) {
                Image image = new Image(content.uiIcon);
                image.setScaling(Scaling.fit);
                this.lastUnlockLayout.add(image);
            } else {
                this.lastUnlockLayout.image(Icon.add);
            }
            this.lastUnlockLayout.pack();
        }
    }

    public void showLaunch() {
        float margin = 30.0f;
        Image image = new Image();
        image.color.a = 0.0f;
        image.touchable = Touchable.disabled;
        image.setFillParent(true);
        image.actions(Actions.delay((160.0f - margin) / 60.0f), Actions.fadeIn(margin / 60.0f, Interp.pow2In), Actions.delay(0.1f), Actions.remove());
        image.update(() -> {
            image.toFront();
            Vars.ui.loadfrag.toFront();
            if (Vars.state.isMenu()) {
                image.remove();
            }
        });
        Core.scene.add(image);
    }

    public void showLand() {
        Image image = new Image();
        image.color.a = 1.0f;
        image.touchable = Touchable.disabled;
        image.setFillParent(true);
        image.actions(Actions.fadeOut(0.5833333f), Actions.remove());
        image.update(() -> {
            image.toFront();
            Vars.ui.loadfrag.toFront();
            if (Vars.state.isMenu()) {
                image.remove();
            }
        });
        Core.scene.add(image);
    }

    private void toggleMenus() {
        if (this.flip != null) {
            this.flip.getStyle().imageUp = this.shown ? Icon.downOpen : Icon.upOpen;
        }
        this.shown = !this.shown;
    }

    private Table makeStatusTable() {
        Table table = new Table(Tex.wavepane);
        StringBuilder ibuild = new StringBuilder();
        IntFormat wavef = new IntFormat("wave");
        IntFormat wavefc = new IntFormat("wave.cap");
        IntFormat enemyf = new IntFormat("wave.enemy");
        IntFormat enemiesf = new IntFormat("wave.enemies");
        IntFormat enemycf = new IntFormat("wave.enemycore");
        IntFormat enemycsf = new IntFormat("wave.enemycores");
        IntFormat waitingf = new IntFormat("wave.waiting", i -> {
            ibuild.setLength(0);
            int m = i / 60;
            int s = i % 60;
            if (m > 0) {
                ibuild.append(m);
                ibuild.append(":");
                if (s < 10) {
                    ibuild.append("0");
                }
            }
            ibuild.append(s);
            return ibuild.toString();
        });
        table.touchable = Touchable.enabled;
        StringBuilder builder = new StringBuilder();
        table.name = "waves";
        table.marginTop(0.0f).marginBottom(4.0f).marginLeft(4.0f);
        table.stack(new Element(){

            @Override
            public void draw() {
                Draw.color(Pal.darkerGray, this.parentAlpha);
                Fill.poly(this.x + this.width / 2.0f, this.y + this.height / 2.0f, 6, this.height / Mathf.sqrt3);
                Draw.reset();
                Drawf.shadow(this.x + this.width / 2.0f, this.y + this.height / 2.0f, this.height * 1.13f, this.parentAlpha);
            }
        }, new Table(t -> {
            float bw = 40.0f;
            float pad = -20.0f;
            t.margin(0.0f);
            t.clicked(() -> {
                if (!Vars.player.dead() && Vars.mobile) {
                    Call.unitClear(Vars.player);
                    Vars.control.input.recentRespawnTimer = 1.0f;
                    Vars.control.input.controlledType = null;
                }
            });
            class SideBar
            extends Element {
                public final Floatp amount;
                public final boolean flip;
                public final Boolp flash;
                float last;
                float blink;
                float value;

                public SideBar(Floatp amount, Boolp flash, boolean flip) {
                    this.amount = amount;
                    this.flip = flip;
                    this.flash = flash;
                    this.setColor(Pal.health);
                }

                @Override
                public void draw() {
                    float next = this.amount.get();
                    if (Float.isNaN(next) || Float.isInfinite(next)) {
                        next = 1.0f;
                    }
                    if (next < this.last && this.flash.get()) {
                        this.blink = 1.0f;
                    }
                    this.blink = Mathf.lerpDelta(this.blink, 0.0f, 0.2f);
                    this.value = Mathf.lerpDelta(this.value, next, 0.15f);
                    this.last = next;
                    if (Float.isNaN(this.value) || Float.isInfinite(this.value)) {
                        this.value = 1.0f;
                    }
                    this.drawInner(Pal.darkishGray, 1.0f);
                    this.drawInner(Tmp.c1.set(this.color).lerp(Color.white, this.blink), this.value);
                }

                void drawInner(Color color, float fract) {
                    if (fract < 0.0f) {
                        return;
                    }
                    fract = Mathf.clamp(fract);
                    if (this.flip) {
                        this.x += this.width;
                        this.width = -this.width;
                    }
                    float stroke = this.width * 0.35f;
                    float bh = this.height / 2.0f;
                    Draw.color(color, this.parentAlpha);
                    float f1 = Math.min(fract * 2.0f, 1.0f);
                    float f2 = (fract - 0.5f) * 2.0f;
                    float bo = -(1.0f - f1) * (this.width - stroke);
                    Fill.quad(this.x, this.y, this.x + stroke, this.y, this.x + this.width + bo, this.y + bh * f1, this.x + this.width - stroke + bo, this.y + bh * f1);
                    if (f2 > 0.0f) {
                        float bx = this.x + (this.width - stroke) * (1.0f - f2);
                        Fill.quad(this.x + this.width, this.y + bh, this.x + this.width - stroke, this.y + bh, bx, this.y + this.height * fract, bx + stroke, this.y + this.height * fract);
                    }
                    Draw.reset();
                    if (this.flip) {
                        this.width = -this.width;
                        this.x -= this.width;
                    }
                }
            }
            t.add(new SideBar(() -> Vars.player.unit().healthf(), () -> true, true)).width(bw).growY().padRight(pad);
            t.image(() -> Vars.player.icon()).scaling(Scaling.bounded).grow().maxWidth(54.0f);
            t.add(new SideBar(() -> Vars.player.dead() ? 0.0f : (Vars.player.displayAmmo() ? Vars.player.unit().ammof() : Vars.player.unit().healthf()), () -> !Vars.player.displayAmmo(), false)).width(bw).growY().padLeft(pad).update(b -> b.color.set(Vars.player.displayAmmo() ? (Vars.player.dead() || Vars.player.unit() instanceof BlockUnitc ? Pal.ammo : Vars.player.unit().type.ammoType.color()) : Pal.health));
            ((Element)t.getChildren().get(1)).toFront();
        })).size(120.0f, 80.0f).padRight(4.0f);
        Cell[] lcell = new Cell[]{null};
        boolean[] couldSkip = new boolean[]{true};
        lcell[0] = table.labelWrap(() -> {
            boolean can = this.canSkipWave();
            if (can != couldSkip[0]) {
                if (this.canSkipWave()) {
                    lcell[0].padRight(8.0f);
                } else {
                    lcell[0].padRight(-42.0f);
                }
                table.invalidateHierarchy();
                table.pack();
                couldSkip[0] = can;
            }
            builder.setLength(0);
            if (Vars.state.rules.mission != null && Vars.state.rules.mission.length() > 0) {
                builder.append(Vars.state.rules.mission);
                return builder;
            }
            if (Vars.state.rules.objectives.any()) {
                boolean first = true;
                for (MapObjectives.MapObjective obj : Vars.state.rules.objectives) {
                    String text;
                    if (!obj.qualified() || (text = obj.text()) == null || text.isEmpty()) continue;
                    if (!first) {
                        builder.append("\n[white]");
                    }
                    builder.append(text);
                    first = false;
                }
                if (builder.length() > 0) {
                    return builder;
                }
            }
            if (!Vars.state.rules.waves && Vars.state.rules.attackMode) {
                int sum = Math.max(Vars.state.teams.present.sum(t -> t.team != Vars.player.team() ? t.cores.size : 0), 1);
                builder.append(sum > 1 ? enemycsf.get(sum) : enemycf.get(sum));
                return builder;
            }
            if (!Vars.state.rules.waves && Vars.state.isCampaign()) {
                builder.append("[lightgray]").append(Core.bundle.get("sector.curcapture"));
            }
            if (!Vars.state.rules.waves) {
                return builder;
            }
            if (Vars.state.rules.winWave > 1 && Vars.state.rules.winWave >= Vars.state.wave) {
                builder.append(wavefc.get(Vars.state.wave, Vars.state.rules.winWave));
            } else {
                builder.append(wavef.get(Vars.state.wave));
            }
            builder.append("\n");
            if (Vars.state.enemies > 0) {
                if (Vars.state.enemies == 1) {
                    builder.append(enemyf.get(Vars.state.enemies));
                } else {
                    builder.append(enemiesf.get(Vars.state.enemies));
                }
                builder.append("\n");
            }
            if (Vars.state.rules.waveTimer) {
                builder.append(Vars.logic.isWaitingWave() ? Core.bundle.get("wave.waveInProgress") : waitingf.get((int)(Vars.state.wavetime / 60.0f)));
            } else if (Vars.state.enemies == 0) {
                builder.append(Core.bundle.get("waiting"));
            }
            return builder;
        }).growX().pad(8.0f);
        table.row();
        return table;
    }

    private void addInfoTable(Table table) {
        table.name = "infotable";
        table.left();
        float[] count = new float[]{-1.0f};
        table.table().update(t -> {
            Unit patt32872$temp = Vars.player.unit();
            if (patt32872$temp instanceof Payloadc) {
                Payloadc payload = (Payloadc)((Object)patt32872$temp);
                if (count[0] != payload.payloadUsed()) {
                    payload.contentInfo((Table)t, 16.0f, 275.0f);
                    count[0] = payload.payloadUsed();
                }
            } else {
                count[0] = -1.0f;
                t.clear();
            }
        }).growX().visible(() -> {
            Payloadc p;
            Unit patt33224$temp = Vars.player.unit();
            return patt33224$temp instanceof Payloadc && (p = (Payloadc)((Object)patt33224$temp)).payloadUsed() > 0.0f;
        }).colspan(2);
        table.row();
        Bits statuses = new Bits();
        table.table().update(t -> {
            t.left();
            Bits applied = Vars.player.unit().statusBits();
            if (!statuses.equals(applied)) {
                t.clear();
                if (applied != null) {
                    for (StatusEffect effect : Vars.content.statusEffects()) {
                        if (!applied.get(effect.id) || effect.isHidden()) continue;
                        t.image(effect.uiIcon).size(32.0f).get().addListener(new Tooltip(l -> l.label(() -> effect.localizedName + " [lightgray]" + UI.formatTime(Vars.player.unit().getDuration(effect))).style(Styles.outlineLabel)));
                    }
                    statuses.set(applied);
                }
            }
        }).left();
    }

    private boolean canSkipWave() {
        return Vars.state.rules.waves && Vars.state.rules.waveSending && (Vars.net.server() || Vars.player.admin || !Vars.net.active()) && Vars.state.enemies == 0 && !Vars.spawner.isSpawning();
    }

    private static /* synthetic */ void lambda$build$72(Table t) {
        t.bottom().left();
        t.table(Styles.black6, c -> {
            Bits used = new Bits(Vars.content.items().size);
            Runnable rebuild = () -> {
                c.clearChildren();
                for (Item item : Vars.content.items()) {
                    if (Vars.state.rules.sector == null || !(Vars.state.rules.sector.info.getExport(item) >= 1.0f)) continue;
                    c.image(item.uiIcon);
                    c.label(() -> (int)Vars.state.rules.sector.info.getExport(item) + " /s").color(Color.lightGray);
                    c.row();
                }
            };
            c.update(() -> {
                boolean wrong = false;
                for (Item item : Vars.content.items()) {
                    boolean has;
                    boolean bl = has = Vars.state.rules.sector != null && Vars.state.rules.sector.info.getExport(item) >= 1.0f;
                    if (used.get(item.id) == has) continue;
                    used.set((int)item.id, has);
                    wrong = true;
                }
                if (wrong) {
                    rebuild.run();
                }
            });
        }).visible(() -> Vars.state.isCampaign() && Vars.content.items().contains((Item)((Object)((Boolf<Item>)i -> Vars.state.rules.sector != null && Vars.state.rules.sector.info.getExport((Item)i) > 0.0f))));
    }

    private static /* synthetic */ void lambda$build$62(Table u) {
        u.color.a = Mathf.lerpDelta(u.color.a, Mathf.num(Vars.spawner.playerNear()), 0.1f);
    }

    private static /* synthetic */ void lambda$build$61(Table c) {
        c.add("@nearpoint").update(l -> l.setColor(Tmp.c1.set(Color.white).lerp(Color.scarlet, Mathf.absin(Time.time, 10.0f, 1.0f)))).labelAlign(1, 1);
    }

    private /* synthetic */ boolean lambda$build$9() {
        return Vars.netServer.isWaitingForPlayers() && Vars.state.isPaused() && this.shown;
    }

    private /* synthetic */ boolean lambda$build$5() {
        return Vars.state.isPaused() && this.shown && !Vars.netServer.isWaitingForPlayers();
    }
}

