/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks;

import arc.Core;
import arc.Events;
import arc.Graphics;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.graphics.Shaders;
import mindustry.logic.LAccess;
import mindustry.type.ItemStack;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.OverlayFloor;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.modules.ItemModule;

public class ConstructBlock
extends Block {
    private static final ConstructBlock[] consBlocks = new ConstructBlock[16];
    private static long lastTime = 0L;
    private static int pitchSeq = 0;
    private static long lastPlayed;

    public ConstructBlock(int size) {
        super("build" + size);
        this.size = size;
        this.update = true;
        this.health = 10;
        this.consumesTap = true;
        this.solidifes = true;
        this.generateIcons = false;
        this.inEditor = false;
        ConstructBlock.consBlocks[size - 1] = this;
        this.sync = true;
    }

    public static ConstructBlock get(int size) {
        if (size > 16) {
            throw new IllegalArgumentException("No. Don't place ConstructBlocks of size greater than 16");
        }
        return consBlocks[size - 1];
    }

    public static void deconstructFinish(Tile tile, Block block, Unit builder) {
        Team team = tile.team();
        if (!Vars.headless && Vars.fogControl.isVisibleTile(Vars.player.team(), tile.x, tile.y)) {
            block.breakEffect.at(tile.drawx(), tile.drawy(), (float)block.size, block.mapColor);
            if (ConstructBlock.shouldPlay()) {
                block.breakSound.at(tile, block.breakPitchChange ? ConstructBlock.calcPitch(false) : 1.0f);
            }
        }
        Events.fire(new EventType.BlockBuildEndEvent(tile, builder, team, true, null));
        tile.remove();
    }

    public static void constructFinish(Tile tile, Block block, @Nullable Unit builder, byte rotation, Team team, Object config) {
        Seq<Building> prev;
        Seq<Building> seq;
        if (tile == null) {
            return;
        }
        float healthf = tile.build == null ? 1.0f : tile.build.healthf();
        Building building = tile.build;
        if (building instanceof ConstructBuild) {
            ConstructBuild co = (ConstructBuild)building;
            seq = co.prevBuild;
        } else {
            seq = prev = null;
        }
        if (block instanceof OverlayFloor) {
            OverlayFloor overlay = (OverlayFloor)block;
            tile.setOverlay(overlay);
            tile.setBlock(Blocks.air);
        } else if (block instanceof Floor) {
            Floor floor = (Floor)block;
            tile.setFloorUnder(floor);
            tile.setBlock(Blocks.air);
        } else {
            tile.setBlock(block, team, rotation);
        }
        if (tile.build != null) {
            tile.build.health = (float)block.health * healthf;
            if (config != null) {
                tile.build.configured(builder, config);
            }
            if (prev != null && prev.size > 0) {
                tile.build.overwrote(prev);
            }
            if (builder != null && builder.getControllerName() != null) {
                tile.build.lastAccessed = builder.getControllerName();
            }
            Vars.indexer.notifyHealthChanged(tile.build);
        }
        if (tile.build != null && !Vars.headless && builder == Vars.player.unit()) {
            tile.build.playerPlaced(config);
        }
        if (Vars.fogControl.isVisibleTile(team, tile.x, tile.y)) {
            block.placeEffect.at(tile.drawx(), tile.drawy(), block.size);
            if (ConstructBlock.shouldPlay()) {
                block.placeSound.at(tile, block.placePitchChange ? ConstructBlock.calcPitch(true) : 1.0f);
            }
        }
        Events.fire(new EventType.BlockBuildEndEvent(tile, builder, team, false, config));
    }

    static boolean shouldPlay() {
        if (Time.timeSinceMillis(lastPlayed) >= 32L) {
            lastPlayed = Time.millis();
            return true;
        }
        return false;
    }

    static float calcPitch(boolean up) {
        if (Time.timeSinceMillis(lastTime) < 480L) {
            lastTime = Time.millis();
            if (++pitchSeq > 30) {
                pitchSeq = 0;
            }
            return 1.0f + Mathf.clamp((float)pitchSeq / 30.0f) * (up ? 1.9f : -0.4f);
        }
        pitchSeq = 0;
        lastTime = Time.millis();
        return Mathf.random(0.7f, 1.3f);
    }

    public static void constructed(Tile tile, Block block, Unit builder, byte rotation, Team team, Object config) {
        Call.constructFinish(tile, block, builder, rotation, team, config);
        if (tile.build != null) {
            tile.build.placed();
        }
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    public class ConstructBuild
    extends Building {
        public Block current = Blocks.air;
        public Block previous = Blocks.air;
        @Nullable
        public Seq<Building> prevBuild;
        public float progress = 0.0f;
        public float buildCost;
        @Nullable
        public Object lastConfig;
        @Nullable
        public Unit lastBuilder;
        public boolean wasConstructing;
        public boolean activeDeconstruct;
        public float constructColor;
        private float[] accumulator;
        private float[] totalAccumulator;

        @Override
        public String getDisplayName() {
            return Core.bundle.format("block.constructing", this.current.localizedName);
        }

        @Override
        public TextureRegion getDisplayIcon() {
            return this.current.fullIcon;
        }

        @Override
        public boolean checkSolid() {
            return this.current.solid || this.previous.solid;
        }

        @Override
        public Graphics.Cursor getCursor() {
            return this.interactable(Vars.player.team()) ? Graphics.Cursor.SystemCursor.hand : Graphics.Cursor.SystemCursor.arrow;
        }

        @Override
        public void tapped() {
            if (this.current.isPlaceable()) {
                if (Vars.control.input.buildWasAutoPaused && !Vars.control.input.isBuilding && Vars.player.isBuilder()) {
                    Vars.control.input.isBuilding = true;
                }
                Vars.player.unit().addBuild(new BuildPlan(this.tile.x, this.tile.y, this.rotation, this.current, this.lastConfig), false);
            }
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.progress) {
                return Mathf.clamp(this.progress);
            }
            return super.sense(sensor);
        }

        @Override
        public void onDestroyed() {
            Fx.blockExplosionSmoke.at(this.tile);
            if (!this.tile.floor().solid && this.tile.floor().hasSurface()) {
                Effect.rubble(this.x, this.y, ConstructBlock.this.size);
            }
        }

        @Override
        public void updateTile() {
            if (this.current == Blocks.air) {
                this.remove();
            }
            this.constructColor = Mathf.lerpDelta(this.constructColor, this.activeDeconstruct ? 1.0f : 0.0f, 0.2f);
            this.activeDeconstruct = false;
        }

        @Override
        public void draw() {
            if (this.current == Blocks.air) {
                return;
            }
            if (this.previous != this.current && this.previous != Blocks.air && this.previous.fullIcon.found()) {
                Draw.rect(this.previous.fullIcon, this.x, this.y, this.previous.rotate ? this.rotdeg() : 0.0f);
            }
            Draw.draw(40.0f, () -> {
                Draw.color(Pal.accent, Pal.remove, this.constructColor);
                boolean noOverrides = this.current.regionRotated1 == -1 && this.current.regionRotated2 == -1;
                int i = 0;
                TextureRegion[] textureRegionArray = this.current.getGeneratedIcons();
                int n = textureRegionArray.length;
                for (int j = 0; j < n; ++j) {
                    TextureRegion region;
                    Shaders.blockbuild.region = region = textureRegionArray[j];
                    Shaders.blockbuild.time = Time.time;
                    Shaders.blockbuild.progress = this.progress;
                    Draw.rect(region, this.x, this.y, this.current.rotate && (noOverrides || this.current.regionRotated2 == i || this.current.regionRotated1 == i) ? this.rotdeg() : 0.0f);
                    Draw.flush();
                    ++i;
                }
                Draw.color();
            });
        }

        public void construct(Unit builder, @Nullable Building core, float amount, Object config) {
            this.wasConstructing = true;
            this.activeDeconstruct = false;
            if (builder.isPlayer()) {
                this.lastBuilder = builder;
            }
            this.lastConfig = config;
            if (this.current.requirements.length != this.accumulator.length || this.totalAccumulator.length != this.current.requirements.length) {
                this.setConstruct(this.previous, this.current);
            }
            float maxProgress = core == null || this.team.rules().infiniteResources ? amount : this.checkRequired(core.items, amount, false);
            for (int i = 0; i < this.current.requirements.length; ++i) {
                int reqamount = Math.round(Vars.state.rules.buildCostMultiplier * (float)this.current.requirements[i].amount);
                int n = i;
                this.accumulator[n] = this.accumulator[n] + Math.min((float)reqamount * maxProgress, (float)reqamount - this.totalAccumulator[i] + 1.0E-5f);
                this.totalAccumulator[i] = Math.min(this.totalAccumulator[i] + (float)reqamount * maxProgress, (float)reqamount);
            }
            maxProgress = core == null || this.team.rules().infiniteResources ? maxProgress : this.checkRequired(core.items, maxProgress, true);
            this.progress = Mathf.clamp(this.progress + maxProgress);
            if (this.progress >= 1.0f || Vars.state.rules.infiniteResources) {
                if (this.lastBuilder == null) {
                    this.lastBuilder = builder;
                }
                if (!Vars.net.client()) {
                    ConstructBlock.constructed(this.tile, this.current, this.lastBuilder, (byte)this.rotation, builder.team, config);
                }
            }
        }

        public void deconstruct(Unit builder, @Nullable CoreBlock.CoreBuild core, float amount) {
            ItemStack[] requirements;
            if (this.wasConstructing) {
                Arrays.fill(this.accumulator, 0.0f);
                Arrays.fill(this.totalAccumulator, 0.0f);
            }
            this.wasConstructing = false;
            this.activeDeconstruct = true;
            float deconstructMultiplier = Vars.state.rules.deconstructRefundMultiplier;
            if (builder.isPlayer()) {
                this.lastBuilder = builder;
            }
            if ((requirements = this.current.requirements).length != this.accumulator.length || this.totalAccumulator.length != requirements.length) {
                this.setDeconstruct(this.current);
            }
            float clampedAmount = Math.min(amount, this.progress);
            for (int i = 0; i < requirements.length; ++i) {
                int reqamount = Math.round(Vars.state.rules.buildCostMultiplier * (float)requirements[i].amount);
                int n = i;
                this.accumulator[n] = this.accumulator[n] + Math.min(clampedAmount * deconstructMultiplier * (float)reqamount, deconstructMultiplier * (float)reqamount - this.totalAccumulator[i]);
                this.totalAccumulator[i] = Math.min(this.totalAccumulator[i] + (float)reqamount * clampedAmount * deconstructMultiplier, (float)reqamount);
                int accumulated = (int)this.accumulator[i];
                if (!(clampedAmount > 0.0f) || accumulated <= 0) continue;
                if (core != null && requirements[i].item.unlockedNowHost()) {
                    int accepting = Math.min(accumulated, core.storageCapacity - core.items.get(requirements[i].item));
                    core.items.add(requirements[i].item, accepting);
                    int n2 = i;
                    this.accumulator[n2] = this.accumulator[n2] - (float)accepting;
                    continue;
                }
                int n3 = i;
                this.accumulator[n3] = this.accumulator[n3] - (float)accumulated;
            }
            this.progress = Mathf.clamp(this.progress - amount);
            if (this.progress <= this.current.deconstructThreshold || Vars.state.rules.infiniteResources) {
                if (this.lastBuilder == null) {
                    this.lastBuilder = builder;
                }
                Call.deconstructFinish(this.tile, this.current, this.lastBuilder);
            }
        }

        private float checkRequired(ItemModule inventory, float amount, boolean remove) {
            float maxProgress = amount;
            boolean infinite = this.team.rules().infiniteResources || Vars.state.rules.infiniteResources;
            for (int i = 0; i < this.current.requirements.length; ++i) {
                int sclamount = Math.round(Vars.state.rules.buildCostMultiplier * (float)this.current.requirements[i].amount);
                int required = (int)this.accumulator[i];
                if (inventory.get(this.current.requirements[i].item) == 0 && sclamount != 0) {
                    maxProgress = 0.0f;
                    continue;
                }
                if (required <= 0) continue;
                int maxUse = Math.min(required, inventory.get(this.current.requirements[i].item));
                float fraction = (float)maxUse / (float)required;
                maxProgress = Math.min(maxProgress, maxProgress * fraction);
                int n = i;
                this.accumulator[n] = this.accumulator[n] - (float)maxUse;
                if (!remove || infinite) continue;
                inventory.remove(this.current.requirements[i].item, maxUse);
            }
            return maxProgress;
        }

        @Override
        public float progress() {
            return this.progress;
        }

        public void setConstruct(Block previous, Block block) {
            if (block == null) {
                return;
            }
            this.constructColor = 0.0f;
            this.wasConstructing = true;
            this.current = block;
            this.previous = previous;
            this.buildCost = block.buildCost * Vars.state.rules.buildCostMultiplier;
            this.accumulator = new float[block.requirements.length];
            this.totalAccumulator = new float[block.requirements.length];
            Vars.pathfinder.updateTile(this.tile);
        }

        public void setDeconstruct(Block previous) {
            if (previous == null) {
                return;
            }
            this.constructColor = 1.0f;
            this.wasConstructing = false;
            this.previous = previous;
            this.progress = 1.0f;
            this.current = previous;
            this.buildCost = previous.buildCost * Vars.state.rules.buildCostMultiplier;
            this.accumulator = new float[previous.requirements.length];
            this.totalAccumulator = new float[previous.requirements.length];
            Vars.pathfinder.updateTile(this.tile);
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
            write.s(this.previous.id);
            write.s(this.current.id);
            if (this.accumulator == null) {
                write.b(-1);
            } else {
                write.b(this.accumulator.length);
                for (int i = 0; i < this.accumulator.length; ++i) {
                    write.f(this.accumulator[i]);
                    write.f(this.totalAccumulator[i]);
                }
            }
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.progress = read.f();
            short pid = read.s();
            short rid = read.s();
            int acsize = read.b();
            if (acsize != -1) {
                this.accumulator = new float[acsize];
                this.totalAccumulator = new float[acsize];
                for (int i = 0; i < acsize; ++i) {
                    this.accumulator[i] = read.f();
                    this.totalAccumulator[i] = read.f();
                }
            }
            if (pid != -1) {
                this.previous = Vars.content.block(pid);
            }
            if (rid != -1) {
                this.current = Vars.content.block(rid);
            }
            if (this.previous == null) {
                this.previous = Blocks.air;
            }
            if (this.current == null) {
                this.current = Blocks.air;
            }
            this.buildCost = this.current.buildCost * Vars.state.rules.buildCostMultiplier;
        }
    }
}

