/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.campaign;

import arc.Events;
import arc.Graphics;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Sector;
import mindustry.world.Block;

public class Accelerator
extends Block {
    public TextureRegion arrowRegion;
    public Block launching = Blocks.coreNucleus;
    public int[] capacities = new int[0];

    public Accelerator(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.hasItems = true;
        this.itemCapacity = 8000;
        this.configurable = true;
    }

    @Override
    public void init() {
        this.itemCapacity = 0;
        this.capacities = new int[Vars.content.items().size];
        for (ItemStack stack : this.launching.requirements) {
            this.capacities[stack.item.id] = stack.amount;
            this.itemCapacity += stack.amount;
        }
        this.consumeItems(this.launching.requirements);
        super.init();
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    public class AcceleratorBuild
    extends Building {
        public float heat;
        public float statusLerp;

        @Override
        public void updateTile() {
            super.updateTile();
            this.heat = Mathf.lerpDelta(this.heat, this.efficiency, 0.05f);
            this.statusLerp = Mathf.lerpDelta(this.statusLerp, this.power.status, 0.05f);
        }

        @Override
        public void draw() {
            float rot;
            int i;
            super.draw();
            for (int l = 0; l < 4; ++l) {
                float length = 7.0f + (float)l * 5.0f;
                Draw.color(Tmp.c1.set(Pal.darkMetal).lerp(this.team.color, this.statusLerp), Pal.darkMetal, Mathf.absin(Time.time + (float)l * 50.0f, 10.0f, 1.0f));
                for (i = 0; i < 4; ++i) {
                    rot = (float)i * 90.0f + 45.0f;
                    Draw.rect(Accelerator.this.arrowRegion, this.x + Angles.trnsx(rot, length), this.y + Angles.trnsy(rot, length), rot + 180.0f);
                }
            }
            if (this.heat < 1.0E-4f) {
                return;
            }
            float rad = (float)(Accelerator.this.size * 8) / 2.0f * 0.74f;
            float scl = 2.0f;
            Draw.z(99.9999f);
            Lines.stroke(1.75f * this.heat, Pal.accent);
            Lines.square(this.x, this.y, rad * 1.22f, 45.0f);
            Lines.stroke(3.0f * this.heat, Pal.accent);
            Lines.square(this.x, this.y, rad, Time.time / scl);
            Lines.square(this.x, this.y, rad, -Time.time / scl);
            Draw.color(this.team.color);
            Draw.alpha(Mathf.clamp(this.heat * 3.0f));
            for (i = 0; i < 4; ++i) {
                rot = (float)i * 90.0f + 45.0f + -Time.time / 3.0f % 360.0f;
                float length = 26.0f * this.heat;
                Draw.rect(Accelerator.this.arrowRegion, this.x + Angles.trnsx(rot, length), this.y + Angles.trnsy(rot, length), rot + 180.0f);
            }
            Draw.reset();
        }

        @Override
        public Graphics.Cursor getCursor() {
            return !Vars.state.isCampaign() || this.efficiency <= 0.0f ? Graphics.Cursor.SystemCursor.arrow : super.getCursor();
        }

        @Override
        public void buildConfiguration(Table table) {
            this.deselect();
            if (!Vars.state.isCampaign() || this.efficiency <= 0.0f) {
                return;
            }
            Vars.ui.showInfo("This block has been removed from the tech tree as of v7, and no longer has a use.\n\nWill it ever be used for anything? Who knows.");
            Events.fire(EventType.Trigger.acceleratorUse);
        }

        @Override
        public int getMaximumAccepted(Item item) {
            return Accelerator.this.capacities[item.id];
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return this.items.get(item) < this.getMaximumAccepted(item);
        }

        private /* synthetic */ void lambda$buildConfiguration$0(Sector sector) {
            this.consume();
            Vars.universe.clearLoadoutInfo();
            Vars.universe.updateLoadout(sector.planet.generator.defaultLoadout.findCore(), sector.planet.generator.defaultLoadout);
        }
    }
}

