/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense;

import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Groups;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.world.Block;

public class BaseShield
extends Block {
    public float radius = 200.0f;
    public int sides = 24;
    protected static BaseShieldBuild paramBuild;
    protected static final Cons<Bullet> bulletConsumer;
    protected static final Cons<Unit> unitConsumer;

    public BaseShield(String name) {
        super(name);
        this.hasPower = true;
        this.solid = true;
        this.update = true;
        this.rebuildable = false;
    }

    @Override
    public void init() {
        super.init();
        this.updateClipRadius(this.radius);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.radius, Vars.player.team().color);
    }

    static {
        bulletConsumer = bullet -> {
            if (bullet.team != BaseShield.paramBuild.team && bullet.type.absorbable && bullet.within(paramBuild, paramBuild.radius())) {
                bullet.absorb();
            }
        };
        unitConsumer = unit -> {
            float overlapDst = unit.hitSize / 2.0f + paramBuild.radius() - unit.dst(paramBuild);
            if (overlapDst > 0.0f) {
                if (overlapDst > unit.hitSize * 1.5f) {
                    unit.kill();
                } else {
                    unit.vel.setZero();
                    unit.move(Tmp.v1.set((Position)unit).sub(paramBuild).setLength(overlapDst + 0.01f));
                    if (Mathf.chanceDelta(0.12f * Time.delta)) {
                        Fx.circleColorSpark.at(unit.x, unit.y, BaseShield.paramBuild.team.color);
                    }
                }
            }
        };
    }

    public class BaseShieldBuild
    extends Building {
        public boolean broken = false;
        public float hit = 0.0f;
        public float smoothRadius;

        @Override
        public void updateTile() {
            this.smoothRadius = Mathf.lerpDelta(this.smoothRadius, BaseShield.this.radius * this.efficiency, 0.05f);
            float rad = this.radius();
            if (rad > 1.0f) {
                paramBuild = this;
                Groups.bullet.intersect(this.x - rad, this.y - rad, rad * 2.0f, rad * 2.0f, bulletConsumer);
                Units.nearbyEnemies(this.team, this.x, this.y, rad + 10.0f, unitConsumer);
            }
        }

        public float radius() {
            return this.smoothRadius;
        }

        @Override
        public void drawSelect() {
            super.drawSelect();
            Drawf.dashCircle(this.x, this.y, BaseShield.this.radius, this.team.color);
        }

        @Override
        public void draw() {
            super.draw();
            this.drawShield();
        }

        @Override
        public boolean inFogTo(Team viewer) {
            return false;
        }

        public void drawShield() {
            if (!this.broken) {
                float radius = this.radius();
                Draw.z(125.0f);
                Draw.color(this.team.color, Color.white, Mathf.clamp(this.hit));
                if (Vars.renderer.animateShields) {
                    Fill.poly(this.x, this.y, BaseShield.this.sides, radius);
                } else {
                    Lines.stroke(1.5f);
                    Draw.alpha(0.09f + Mathf.clamp(0.08f * this.hit));
                    Fill.poly(this.x, this.y, BaseShield.this.sides, radius);
                    Draw.alpha(1.0f);
                    Lines.poly(this.x, this.y, BaseShield.this.sides, radius);
                    Draw.reset();
                }
            }
            Draw.reset();
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.smoothRadius);
            write.bool(this.broken);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read);
            if (revision >= 1) {
                this.smoothRadius = read.f();
                this.broken = read.bool();
            }
        }
    }
}

