/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense;

import arc.Graphics;
import arc.audio.Sound;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.struct.Queue;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.logic.LAccess;
import mindustry.world.blocks.defense.Wall;

public class Door
extends Wall {
    protected static final Rect rect = new Rect();
    protected static final Queue<DoorBuild> doorQueue = new Queue();
    public final int timerToggle;
    public Effect openfx;
    public Effect closefx;
    public Sound doorSound;
    public TextureRegion openRegion;

    public Door(String name) {
        super(name);
        this.timerToggle = this.timers++;
        this.openfx = Fx.dooropen;
        this.closefx = Fx.doorclose;
        this.doorSound = Sounds.door;
        this.solid = false;
        this.solidifes = true;
        this.consumesTap = true;
        this.config(Boolean.class, (base, open) -> {
            this.doorSound.at((Position)base);
            base.effect();
            for (DoorBuild entity : base.chained) {
                if (Units.anyEntities(entity.tile) && !open.booleanValue() || entity.open == open) continue;
                entity.open = open;
                Vars.pathfinder.updateTile(entity.tile());
            }
        });
    }

    @Override
    public TextureRegion getPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        return plan.config == Boolean.TRUE ? this.openRegion : this.region;
    }

    public class DoorBuild
    extends Building {
        public boolean open = false;
        public Seq<DoorBuild> chained = new Seq();

        @Override
        public void onProximityAdded() {
            super.onProximityAdded();
            this.updateChained();
        }

        @Override
        public void onProximityRemoved() {
            super.onProximityRemoved();
            for (Building b : this.proximity) {
                if (!(b instanceof DoorBuild)) continue;
                DoorBuild d = (DoorBuild)b;
                d.updateChained();
            }
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.enabled) {
                return this.open ? 1.0 : 0.0;
            }
            return super.sense(sensor);
        }

        @Override
        public void control(LAccess type, double p1, double p2, double p3, double p4) {
            if (type == LAccess.enabled) {
                boolean shouldOpen;
                boolean bl = shouldOpen = !Mathf.zero(p1);
                if (Vars.net.client() || this.open == shouldOpen || Units.anyEntities(this.tile) && !shouldOpen || !this.origin().timer(Door.this.timerToggle, 80.0f)) {
                    return;
                }
                this.configureAny(shouldOpen);
            }
        }

        public DoorBuild origin() {
            return this.chained.isEmpty() ? this : this.chained.first();
        }

        public void effect() {
            (this.open ? Door.this.closefx : Door.this.openfx).at((Position)this, (float)Door.this.size);
        }

        public void updateChained() {
            this.chained = new Seq();
            doorQueue.clear();
            doorQueue.add(this);
            while (!doorQueue.isEmpty()) {
                DoorBuild next = doorQueue.removeLast();
                this.chained.add(next);
                for (Building b : next.proximity) {
                    if (!(b instanceof DoorBuild)) continue;
                    DoorBuild d = (DoorBuild)b;
                    if (d.chained == this.chained) continue;
                    d.chained = this.chained;
                    doorQueue.addFirst(d);
                }
            }
        }

        @Override
        public void draw() {
            Draw.rect(this.open ? Door.this.openRegion : Door.this.region, this.x, this.y);
        }

        @Override
        public Graphics.Cursor getCursor() {
            return this.interactable(Vars.player.team()) ? Graphics.Cursor.SystemCursor.hand : Graphics.Cursor.SystemCursor.arrow;
        }

        @Override
        public boolean checkSolid() {
            return !this.open;
        }

        @Override
        public void tapped() {
            if (Units.anyEntities(this.tile) && this.open || !this.origin().timer(Door.this.timerToggle, 60.0f)) {
                return;
            }
            this.configure(!this.open);
        }

        @Override
        public Boolean config() {
            return this.open;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.bool(this.open);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.open = read.bool();
        }
    }
}

