/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.environment;

import arc.Core;
import arc.graphics.Pixmap;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureRegion;
import arc.util.Nullable;
import mindustry.graphics.MultiPacker;
import mindustry.world.Block;
import mindustry.world.blocks.environment.Floor;

public class ShallowLiquid
extends Floor {
    @Nullable
    public Floor liquidBase;
    @Nullable
    public Floor floorBase;
    public float liquidOpacity = 0.35f;

    public ShallowLiquid(String name) {
        super(name);
    }

    public void set(Block liquid, Block floor) {
        this.liquidBase = liquid.asFloor();
        this.floorBase = floor.asFloor();
        this.isLiquid = true;
        this.variants = this.floorBase.variants;
        this.status = this.liquidBase.status;
        this.liquidDrop = this.liquidBase.liquidDrop;
        this.cacheLayer = this.liquidBase.cacheLayer;
        this.shallow = true;
    }

    @Override
    public void createIcons(MultiPacker packer) {
        if (this.liquidBase != null && this.floorBase != null) {
            PixmapRegion overlay = Core.atlas.getPixmap(this.liquidBase.region);
            int index = 0;
            for (TextureRegion region : this.floorBase.variantRegions()) {
                Pixmap res = Core.atlas.getPixmap(region).crop();
                for (int x = 0; x < res.width; ++x) {
                    for (int y = 0; y < res.height; ++y) {
                        res.setRaw(x, y, Pixmap.blend(overlay.getRaw(x, y) & 0xFFFFFF00 | (int)(this.liquidOpacity * 255.0f), res.getRaw(x, y)));
                    }
                }
                String baseName = this.name + "" + ++index;
                packer.add(MultiPacker.PageType.environment, baseName, res);
                packer.add(MultiPacker.PageType.editor, "editor-" + baseName, res);
                res.dispose();
            }
        }
    }
}

