/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.liquid;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.world.blocks.liquid.LiquidBlock;

public class LiquidRouter
extends LiquidBlock {
    public float liquidPadding = 0.0f;

    public LiquidRouter(String name) {
        super(name);
        this.solid = true;
        this.noUpdateDisabled = true;
        this.canOverdrive = false;
        this.floating = true;
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.bottomRegion, this.region};
    }

    public class LiquidRouterBuild
    extends LiquidBlock.LiquidBuild {
        @Override
        public void updateTile() {
            if (this.liquids.currentAmount() > 0.01f) {
                this.dumpLiquid(this.liquids.current());
            }
        }

        @Override
        public void draw() {
            Draw.rect(LiquidRouter.this.bottomRegion, this.x, this.y);
            if (this.liquids.currentAmount() > 0.001f) {
                LiquidBlock.drawTiledFrames(LiquidRouter.this.size, this.x, this.y, LiquidRouter.this.liquidPadding, this.liquids.current(), this.liquids.currentAmount() / LiquidRouter.this.liquidCapacity);
            }
            Draw.rect(LiquidRouter.this.region, this.x, this.y);
        }

        @Override
        public boolean acceptLiquid(Building source, Liquid liquid) {
            return this.liquids.current() == liquid || this.liquids.currentAmount() < 0.2f;
        }
    }
}

