/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.logic;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.FrameBuffer;
import arc.struct.LongQueue;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.gen.DisplayCmd;
import mindustry.graphics.Pal;
import mindustry.ui.Fonts;
import mindustry.world.Block;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;

public class LogicDisplay
extends Block {
    public static final byte commandClear = 0;
    public static final byte commandColor = 1;
    public static final byte commandColorPack = 2;
    public static final byte commandStroke = 3;
    public static final byte commandLine = 4;
    public static final byte commandRect = 5;
    public static final byte commandLineRect = 6;
    public static final byte commandPoly = 7;
    public static final byte commandLinePoly = 8;
    public static final byte commandTriangle = 9;
    public static final byte commandImage = 10;
    public static final byte commandCharacter = 11;
    public int maxSides = 25;
    public int displaySize = 64;
    public float scaleFactor = 1.0f;

    public LogicDisplay(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.canOverdrive = false;
        this.group = BlockGroup.logic;
        this.drawDisabled = false;
        this.envEnabled = -1;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.displaySize, "@x@", this.displaySize, this.displaySize);
    }

    static int unpackSign(int value) {
        return (value & 0x1FF) * ((value & 0x200) != 0 ? -1 : 1);
    }

    static class DisplayCmdStruct {
        public byte type;
        public int x;
        public int y;
        public int p1;
        public int p2;
        public int p3;
        public int p4;

        DisplayCmdStruct() {
        }
    }

    public static enum GraphicsType {
        clear,
        color,
        col,
        stroke,
        line,
        rect,
        lineRect,
        poly,
        linePoly,
        triangle,
        image;

        public static final GraphicsType[] all;

        static {
            all = GraphicsType.values();
        }
    }

    public class LogicDisplayBuild
    extends Building {
        public FrameBuffer buffer;
        public float color = Color.whiteFloatBits;
        public float stroke = 1.0f;
        public LongQueue commands = new LongQueue(256);

        @Override
        public void draw() {
            super.draw();
            if (!Vars.renderer.drawDisplays) {
                return;
            }
            Draw.draw(Draw.z(), () -> {
                if (this.buffer == null) {
                    this.buffer = new FrameBuffer(LogicDisplay.this.displaySize, LogicDisplay.this.displaySize);
                    this.buffer.begin(Pal.darkerMetal);
                    this.buffer.end();
                }
            });
            if (!this.commands.isEmpty()) {
                Draw.draw(Draw.z(), () -> {
                    Tmp.m1.set(Draw.proj());
                    Draw.proj(0.0f, 0.0f, LogicDisplay.this.displaySize, LogicDisplay.this.displaySize);
                    this.buffer.begin();
                    Draw.color(this.color);
                    Lines.stroke(this.stroke);
                    while (!this.commands.isEmpty()) {
                        long c = this.commands.removeFirst();
                        byte type = DisplayCmd.type(c);
                        int x = LogicDisplay.unpackSign(DisplayCmd.x(c));
                        int y = LogicDisplay.unpackSign(DisplayCmd.y(c));
                        int p1 = LogicDisplay.unpackSign(DisplayCmd.p1(c));
                        int p2 = LogicDisplay.unpackSign(DisplayCmd.p2(c));
                        int p3 = LogicDisplay.unpackSign(DisplayCmd.p3(c));
                        int p4 = LogicDisplay.unpackSign(DisplayCmd.p4(c));
                        switch (type) {
                            case 0: {
                                Core.graphics.clear((float)x / 255.0f, (float)y / 255.0f, (float)p1 / 255.0f, 1.0f);
                                break;
                            }
                            case 4: {
                                Lines.line(x, y, p1, p2);
                                break;
                            }
                            case 5: {
                                Fill.crect(x, y, p1, p2);
                                break;
                            }
                            case 6: {
                                Lines.rect(x, y, p1, p2);
                                break;
                            }
                            case 7: {
                                Fill.poly(x, y, Math.min(p1, LogicDisplay.this.maxSides), p2, p3);
                                break;
                            }
                            case 8: {
                                Lines.poly(x, y, Math.min(p1, LogicDisplay.this.maxSides), p2, p3);
                                break;
                            }
                            case 9: {
                                Fill.tri(x, y, p1, p2, p3, p4);
                                break;
                            }
                            case 1: {
                                this.color = Color.toFloatBits(x, y, p1, p2);
                                Draw.color(this.color);
                                break;
                            }
                            case 3: {
                                this.stroke = x;
                                Lines.stroke(this.stroke);
                                break;
                            }
                            case 10: {
                                TextureRegion icon = Fonts.logicIcon(p1);
                                Draw.rect(Fonts.logicIcon(p1), (float)x, (float)y, (float)p2, (float)p2 / icon.ratio(), (float)p3);
                                break;
                            }
                        }
                    }
                    this.buffer.end();
                    Draw.proj(Tmp.m1);
                    Draw.reset();
                });
            }
            Draw.blend(Blending.disabled);
            Draw.draw(Draw.z(), () -> {
                if (this.buffer != null) {
                    Draw.rect(Draw.wrap((Texture)this.buffer.getTexture()), this.x, this.y, (float)this.buffer.getWidth() * LogicDisplay.this.scaleFactor * Draw.scl, (float)(-this.buffer.getHeight()) * LogicDisplay.this.scaleFactor * Draw.scl);
                }
            });
            Draw.blend();
        }

        @Override
        public void remove() {
            super.remove();
            if (this.buffer != null) {
                this.buffer.dispose();
                this.buffer = null;
            }
        }
    }
}

