/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.Events;
import arc.graphics.Color;
import arc.math.Mathf;
import arc.util.Nullable;
import arc.util.Time;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.game.EventType;
import mindustry.graphics.Drawf;
import mindustry.type.LiquidStack;
import mindustry.world.blocks.power.PowerGenerator;
import mindustry.world.consumers.ConsumeItemFilter;
import mindustry.world.consumers.ConsumeLiquidFilter;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;

public class ConsumeGenerator
extends PowerGenerator {
    public float itemDuration = 120.0f;
    public float warmupSpeed = 0.05f;
    public float effectChance = 0.01f;
    public Effect generateEffect = Fx.none;
    public Effect consumeEffect = Fx.none;
    public float generateEffectRange = 3.0f;
    @Nullable
    public LiquidStack outputLiquid;
    public boolean explodeOnFull = false;
    @Nullable
    public ConsumeItemFilter filterItem;
    @Nullable
    public ConsumeLiquidFilter filterLiquid;

    public ConsumeGenerator(String name) {
        super(name);
    }

    @Override
    public void setBars() {
        super.setBars();
        if (this.outputLiquid != null) {
            this.addLiquidBar(this.outputLiquid.liquid);
        }
    }

    @Override
    public void init() {
        this.filterItem = (ConsumeItemFilter)this.findConsumer(c -> c instanceof ConsumeItemFilter);
        this.filterLiquid = (ConsumeLiquidFilter)this.findConsumer(c -> c instanceof ConsumeLiquidFilter);
        if (this.outputLiquid != null) {
            this.outputsLiquid = true;
            this.hasLiquids = true;
        }
        if (this.explodeOnFull && this.outputLiquid != null && this.explosionPuddleLiquid == null) {
            this.explosionPuddleLiquid = this.outputLiquid.liquid;
        }
        this.emitLight = true;
        this.lightRadius = 65.0f * (float)this.size;
        super.init();
    }

    @Override
    public void setStats() {
        super.setStats();
        if (this.hasItems) {
            this.stats.add(Stat.productionTime, this.itemDuration / 60.0f, StatUnit.seconds);
        }
        if (this.outputLiquid != null) {
            this.stats.add(Stat.output, StatValues.liquid(this.outputLiquid.liquid, this.outputLiquid.amount * 60.0f, true));
        }
    }

    public class ConsumeGeneratorBuild
    extends PowerGenerator.GeneratorBuild {
        public float warmup;
        public float totalTime;
        public float efficiencyMultiplier;

        public ConsumeGeneratorBuild() {
            super(ConsumeGenerator.this);
            this.efficiencyMultiplier = 1.0f;
        }

        @Override
        public void updateEfficiencyMultiplier() {
            float m;
            if (ConsumeGenerator.this.filterItem != null) {
                float m2 = ConsumeGenerator.this.filterItem.efficiencyMultiplier(this);
                if (m2 > 0.0f) {
                    this.efficiencyMultiplier = m2;
                }
            } else if (ConsumeGenerator.this.filterLiquid != null && (m = ConsumeGenerator.this.filterLiquid.efficiencyMultiplier(this)) > 0.0f) {
                this.efficiencyMultiplier = m;
            }
        }

        @Override
        public void updateTile() {
            boolean valid = this.efficiency > 0.0f;
            this.warmup = Mathf.lerpDelta(this.warmup, valid ? 1.0f : 0.0f, ConsumeGenerator.this.warmupSpeed);
            this.productionEfficiency = this.efficiency * this.efficiencyMultiplier;
            this.totalTime += this.warmup * Time.delta;
            if (valid && Mathf.chanceDelta(ConsumeGenerator.this.effectChance)) {
                ConsumeGenerator.this.generateEffect.at(this.x + Mathf.range(ConsumeGenerator.this.generateEffectRange), this.y + Mathf.range(ConsumeGenerator.this.generateEffectRange));
            }
            if (ConsumeGenerator.this.hasItems && valid && this.generateTime <= 0.0f) {
                this.consume();
                ConsumeGenerator.this.consumeEffect.at(this.x + Mathf.range(ConsumeGenerator.this.generateEffectRange), this.y + Mathf.range(ConsumeGenerator.this.generateEffectRange));
                this.generateTime = 1.0f;
            }
            if (ConsumeGenerator.this.outputLiquid != null) {
                float added = Math.min(this.productionEfficiency * this.delta() * ConsumeGenerator.this.outputLiquid.amount, ConsumeGenerator.this.liquidCapacity - this.liquids.get(ConsumeGenerator.this.outputLiquid.liquid));
                this.liquids.add(ConsumeGenerator.this.outputLiquid.liquid, added);
                this.dumpLiquid(ConsumeGenerator.this.outputLiquid.liquid);
                if (ConsumeGenerator.this.explodeOnFull && this.liquids.get(ConsumeGenerator.this.outputLiquid.liquid) >= ConsumeGenerator.this.liquidCapacity - 0.01f) {
                    this.kill();
                    Events.fire(new EventType.GeneratorPressureExplodeEvent(this));
                }
            }
            this.generateTime -= this.delta() / ConsumeGenerator.this.itemDuration;
        }

        @Override
        public boolean consumeTriggerValid() {
            return this.generateTime > 0.0f;
        }

        @Override
        public float warmup() {
            return this.warmup;
        }

        @Override
        public float totalProgress() {
            return this.totalTime;
        }

        @Override
        public void drawLight() {
            ConsumeGenerator.this.drawer.drawLight(this);
            Drawf.light(this.x, this.y, (60.0f + Mathf.absin(10.0f, 5.0f)) * (float)ConsumeGenerator.this.size, Color.orange, 0.5f * this.warmup);
        }
    }
}

