/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.graphics.Blending;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.scene.style.Drawable;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Placement;
import mindustry.logic.LAccess;
import mindustry.ui.Styles;
import mindustry.world.Block;

public class LightBlock
extends Block {
    public float brightness = 0.9f;
    public float radius = 200.0f;
    public TextureRegion topRegion;

    public LightBlock(String name) {
        super(name);
        this.hasPower = true;
        this.update = true;
        this.configurable = true;
        this.saveConfig = true;
        this.envEnabled |= 2;
        this.swapDiagonalPlacement = true;
        this.config(Integer.class, (tile, value) -> {
            tile.color = value;
        });
    }

    @Override
    public void init() {
        this.lightRadius = this.radius * 2.5f;
        this.clipSize = Math.max(this.clipSize, this.lightRadius * 3.0f);
        this.emitLight = true;
        super.init();
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.radius * 0.75f, Pal.placing);
    }

    @Override
    public void changePlacementPath(Seq<Point2> points, int rotation) {
        float placeRadius2 = Mathf.pow(this.radius * 0.7f / 8.0f, 2.0f) * 3.0f;
        Placement.calculateNodes(points, this, rotation, (point, other) -> point.dst2((Point2)other) <= placeRadius2);
    }

    public class LightBuild
    extends Building {
        public int color = Pal.accent.rgba();
        public float smoothTime = 1.0f;

        @Override
        public void control(LAccess type, double p1, double p2, double p3, double p4) {
            if (type == LAccess.color) {
                this.color = Tmp.c1.fromDouble(p1).rgba8888();
            }
            super.control(type, p1, p2, p3, p4);
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.color) {
                return Tmp.c1.set(this.color).toDoubleBits();
            }
            return super.sense(sensor);
        }

        @Override
        public void draw() {
            super.draw();
            Draw.blend(Blending.additive);
            Draw.color(Tmp.c1.set(this.color), this.efficiency * 0.3f);
            Draw.rect(LightBlock.this.topRegion, this.x, this.y);
            Draw.color();
            Draw.blend();
        }

        @Override
        public void updateTile() {
            this.smoothTime = Mathf.lerpDelta(this.smoothTime, this.timeScale, 0.1f);
        }

        @Override
        public void buildConfiguration(Table table) {
            table.button((Drawable)Icon.pencil, Styles.cleari, () -> {
                Vars.ui.picker.show(Tmp.c1.set(this.color).a(0.5f), false, res -> this.configure(res.rgba()));
                this.deselect();
            }).size(40.0f);
        }

        @Override
        public boolean onConfigureBuildTapped(Building other) {
            if (this == other) {
                this.deselect();
                return false;
            }
            return true;
        }

        @Override
        public void drawLight() {
            Drawf.light(this.x, this.y, LightBlock.this.lightRadius * Math.min(this.smoothTime, 2.0f), Tmp.c1.set(this.color), LightBlock.this.brightness * this.efficiency);
        }

        @Override
        public Integer config() {
            return this.color;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.i(this.color);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.color = read.i();
        }
    }
}

