/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.sandbox;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.scene.ui.layout.Table;
import arc.util.Eachable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class ItemSource
extends Block {
    public int itemsPerSecond = 100;

    public ItemSource(String name) {
        super(name);
        this.hasItems = true;
        this.update = true;
        this.solid = true;
        this.group = BlockGroup.transportation;
        this.configurable = true;
        this.saveConfig = true;
        this.noUpdateDisabled = true;
        this.envEnabled = -1;
        this.clearOnDoubleTap = true;
        this.config(Item.class, (tile, item) -> {
            tile.outputItem = item;
        });
        this.configClear(tile -> {
            tile.outputItem = null;
        });
    }

    @Override
    public void setBars() {
        super.setBars();
        this.removeBar("items");
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.output, this.itemsPerSecond, StatUnit.itemsSecond);
    }

    @Override
    protected TextureRegion[] icons() {
        return new TextureRegion[]{Core.atlas.find("source-bottom"), this.region};
    }

    @Override
    public void drawPlanConfig(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawPlanConfigCenter(plan, plan.config, "center", true);
    }

    @Override
    public boolean outputsItems() {
        return true;
    }

    public class ItemSourceBuild
    extends Building {
        public float counter;
        public Item outputItem;

        @Override
        public void draw() {
            if (this.outputItem == null) {
                Draw.rect("cross-full", this.x, this.y);
            } else {
                Draw.color(this.outputItem.color);
                Fill.square(this.x, this.y, 3.99999f);
                Draw.color();
            }
            super.draw();
        }

        @Override
        public void updateTile() {
            if (this.outputItem == null) {
                return;
            }
            this.counter += this.edelta();
            float limit = 60.0f / (float)ItemSource.this.itemsPerSecond;
            while (this.counter >= limit) {
                this.items.set(this.outputItem, 1);
                this.dump(this.outputItem);
                this.items.set(this.outputItem, 0);
                this.counter -= limit;
            }
        }

        @Override
        public void buildConfiguration(Table table) {
            ItemSelection.buildTable(ItemSource.this, table, Vars.content.items(), () -> this.outputItem, this::configure, ItemSource.this.selectionRows, ItemSource.this.selectionColumns);
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return false;
        }

        @Override
        public Item config() {
            return this.outputItem;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.s(this.outputItem == null ? -1 : (int)this.outputItem.id);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.outputItem = Vars.content.item(read.s());
        }
    }
}

