/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.sandbox;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.scene.ui.layout.Table;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.blocks.liquid.LiquidBlock;
import mindustry.world.meta.BlockGroup;

public class LiquidSource
extends Block {
    public TextureRegion crossRegion;
    public TextureRegion bottomRegion;

    public LiquidSource(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.hasLiquids = true;
        this.liquidCapacity = 10000.0f;
        this.configurable = true;
        this.outputsLiquid = true;
        this.saveConfig = true;
        this.noUpdateDisabled = true;
        this.displayFlow = false;
        this.group = BlockGroup.liquids;
        this.envEnabled = -1;
        this.clearOnDoubleTap = true;
        this.config(Liquid.class, (tile, l) -> {
            tile.source = l;
        });
        this.configClear(tile -> {
            tile.source = null;
        });
    }

    @Override
    public void setBars() {
        super.setBars();
        this.removeBar("liquid");
    }

    @Override
    public void drawPlanConfig(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawPlanConfigCenter(plan, plan.config, "center", true);
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.bottomRegion, this.region};
    }

    public class LiquidSourceBuild
    extends Building {
        @Nullable
        public Liquid source = null;

        @Override
        public void updateTile() {
            if (this.source == null) {
                this.liquids.clear();
            } else {
                this.liquids.set(this.source, LiquidSource.this.liquidCapacity);
                this.dumpLiquid(this.source);
            }
        }

        @Override
        public void draw() {
            super.draw();
            Draw.rect(LiquidSource.this.bottomRegion, this.x, this.y);
            if (this.source == null) {
                Draw.rect(LiquidSource.this.crossRegion, this.x, this.y);
            } else {
                LiquidBlock.drawTiledFrames(LiquidSource.this.size, this.x, this.y, 0.0f, this.source, 1.0f);
            }
            Draw.rect(this.block.region, this.x, this.y);
        }

        @Override
        public void buildConfiguration(Table table) {
            ItemSelection.buildTable(LiquidSource.this, table, Vars.content.liquids(), () -> this.source, this::configure, LiquidSource.this.selectionRows, LiquidSource.this.selectionColumns);
        }

        @Override
        public Liquid config() {
            return this.source;
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.s(this.source == null ? -1 : (int)this.source.id);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            short id = revision == 1 ? read.s() : (short)read.b();
            this.source = id == -1 ? null : Vars.content.liquid(id);
        }
    }
}

