/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.storage;

import arc.Core;
import arc.Events;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.scene.ui.layout.Scl;
import arc.struct.EnumSet;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.content.UnitTypes;
import mindustry.core.UI;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Damage;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Player;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.UnitType;
import mindustry.ui.Bar;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.StorageBlock;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.modules.ItemModule;

public class CoreBlock
extends StorageBlock {
    private static ItemModule nextItems;
    protected static final float[] thrusterSizes;
    public TextureRegion thruster1;
    public TextureRegion thruster2;
    public float thrusterLength = 3.5f;
    public boolean isFirstTier;
    public boolean requiresCoreZone;
    public boolean incinerateNonBuildable = false;
    public UnitType unitType = UnitTypes.alpha;
    public float captureInvicibility = 900.0f;

    public CoreBlock(String name) {
        super(name);
        this.solid = true;
        this.update = true;
        this.hasItems = true;
        this.priority = 2.0f;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.core});
        this.unitCapModifier = 10;
        this.loopSound = Sounds.respawning;
        this.loopSoundVolume = 1.0f;
        this.drawDisabled = false;
        this.canOverdrive = false;
        this.envEnabled |= 2;
        this.replaceable = false;
    }

    public static void playerSpawn(Tile tile, Player player) {
        Building building;
        if (player == null || tile == null || !((building = tile.build) instanceof CoreBuild)) {
            return;
        }
        CoreBuild core = (CoreBuild)building;
        UnitType spawnType = ((CoreBlock)core.block).unitType;
        if (core.wasVisible) {
            Fx.spawn.at(core);
        }
        player.set(core);
        if (!Vars.net.client()) {
            Unit unit = spawnType.create(tile.team());
            unit.set(core);
            unit.rotation(90.0f);
            unit.impulse(0.0f, 3.0f);
            unit.spawnedByCore(true);
            unit.controller(player);
            unit.add();
        }
        if (Vars.state.isCampaign() && player == Vars.player) {
            spawnType.unlock();
        }
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.buildTime);
        this.stats.add(Stat.unitType, table -> {
            table.row();
            table.table(Styles.grayPanel, b -> {
                b.image(this.unitType.uiIcon).size(40.0f).pad(10.0f).left().scaling(Scaling.fit);
                b.table(info -> {
                    info.add(this.unitType.localizedName).left();
                    if (Core.settings.getBool("console")) {
                        info.row();
                        info.add(this.unitType.name).left().color(Color.lightGray);
                    }
                });
                b.button("?", Styles.flatBordert, () -> Vars.ui.content.show(this.unitType)).size(40.0f).pad(10.0f).right().grow().visible(() -> this.unitType.unlockedNow());
            }).growX().pad(5.0f).row();
        });
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("capacity", e -> new Bar(() -> Core.bundle.format("bar.capacity", UI.formatAmount(e.storageCapacity)), () -> Pal.items, () -> (float)e.items.total() / ((float)e.storageCapacity * (float)Vars.content.items().count(UnlockableContent::unlockedNow))));
    }

    @Override
    public void init() {
        this.lightRadius = 30.0f + 20.0f * (float)this.size;
        this.fogRadius = Math.max(this.fogRadius, (int)(this.lightRadius / 8.0f * 3.0f) + 13);
        this.emitLight = true;
        super.init();
    }

    @Override
    public boolean canBreak(Tile tile) {
        return Vars.state.isEditor();
    }

    @Override
    public boolean canReplace(Block other) {
        return super.canReplace(other) || other instanceof CoreBlock && this.size >= other.size && other != this;
    }

    @Override
    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        if (tile == null) {
            return false;
        }
        if (Vars.state.isEditor()) {
            return true;
        }
        CoreBuild core = team.core();
        tile.getLinkedTilesAs((Block)this, tempTiles);
        if (!tempTiles.contains(o -> !o.floor().allowCorePlacement || o.block() instanceof CoreBlock)) {
            return true;
        }
        if (core == null || !Vars.state.rules.infiniteResources && !core.items.has(this.requirements, Vars.state.rules.buildCostMultiplier)) {
            return false;
        }
        return tile.block() instanceof CoreBlock && this.size > tile.block().size && (!this.requiresCoreZone || tempTiles.allMatch(o -> o.floor().allowCorePlacement));
    }

    @Override
    public void placeBegan(Tile tile, Block previous, Unit builder) {
        if (previous instanceof CoreBlock) {
            tile.setBlock(this, tile.team());
            tile.block().placeEffect.at((Position)tile, (float)tile.block().size);
            Fx.upgradeCore.at(tile.drawx(), tile.drawy(), 0.0f, tile.block());
            Fx.upgradeCoreBloom.at((Position)tile, (float)tile.block().size);
            if (nextItems != null) {
                if (tile.team().core() != null) {
                    tile.team().core().items.set(nextItems);
                }
                nextItems = null;
            }
            Events.fire(new EventType.BlockBuildEndEvent(tile, builder, tile.team(), false, null));
        }
    }

    @Override
    public void beforePlaceBegan(Tile tile, Block previous) {
        if (tile.build instanceof CoreBuild) {
            ItemModule items = tile.build.items.copy();
            if (!Vars.state.rules.infiniteResources) {
                items.remove(ItemStack.mult(this.requirements, Vars.state.rules.buildCostMultiplier));
            }
            nextItems = items;
        }
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        if (Vars.world.tile(x, y) == null) {
            return;
        }
        if (!this.canPlaceOn(Vars.world.tile(x, y), Vars.player.team(), rotation)) {
            this.drawPlaceText(Core.bundle.get(this.isFirstTier ? "bar.corefloor" : (Vars.player.team().core() != null && Vars.player.team().core().items.has(this.requirements, Vars.state.rules.buildCostMultiplier) || Vars.state.rules.infiniteResources ? "bar.corereq" : "bar.noresources")), x, y, valid);
        }
    }

    public void drawLanding(CoreBuild build, float x, float y) {
        float fout = Vars.renderer.getLandTime() / 160.0f;
        if (Vars.renderer.isLaunching()) {
            fout = 1.0f - fout;
        }
        float fin = 1.0f - fout;
        float scl = Scl.scl(4.0f) / Vars.renderer.getDisplayScale();
        float shake = 0.0f;
        float s = (float)this.region.width * this.region.scl() * scl * 3.6f * Interp.pow2Out.apply(fout);
        float rotation = Interp.pow2In.apply(fout) * 135.0f;
        x += Mathf.range(shake);
        y += Mathf.range(shake);
        float thrustOpen = 0.25f;
        float thrusterFrame = fin >= thrustOpen ? 1.0f : fin / thrustOpen;
        float thrusterSize = Mathf.sample(thrusterSizes, fin);
        if (Vars.renderer.isLaunching()) {
            Interp.PowOut i = Interp.pow2Out;
            thrusterFrame = i.apply(Mathf.clamp(fout * 13.0f));
            thrusterSize = i.apply(Mathf.clamp(fout * 9.0f));
        }
        Draw.color(Pal.lightTrail);
        Draw.rect("circle-shadow", x, y, s, s);
        Draw.scl(scl);
        float strength = (1.0f + (float)(this.size - 3) / 2.5f) * scl * thrusterSize * (0.95f + Mathf.absin(2.0f, 0.1f));
        float offset = (float)(this.size - 3) * 3.0f * scl;
        for (int i = 0; i < 4; ++i) {
            Tmp.v1.trns((float)(i * 90) + rotation, 1.0f);
            Tmp.v1.setLength(((float)(this.size * 8) / 2.0f + 1.0f) * scl + strength * 2.0f + offset);
            Draw.color(build.team.color);
            Fill.circle(Tmp.v1.x + x, Tmp.v1.y + y, 6.0f * strength);
            Tmp.v1.setLength(((float)(this.size * 8) / 2.0f + 1.0f) * scl + strength * 0.5f + offset);
            Draw.color(Color.white);
            Fill.circle(Tmp.v1.x + x, Tmp.v1.y + y, 3.5f * strength);
        }
        this.drawLandingThrusters(x, y, rotation, thrusterFrame);
        Drawf.spinSprite(this.region, x, y, rotation);
        Draw.alpha(Interp.pow4In.apply(thrusterFrame));
        this.drawLandingThrusters(x, y, rotation, thrusterFrame);
        Draw.alpha(1.0f);
        if (this.teamRegions[build.team.id] == this.teamRegion) {
            Draw.color(build.team.color);
        }
        Drawf.spinSprite(this.teamRegions[build.team.id], x, y, rotation);
        Draw.color();
        Draw.scl();
        Draw.reset();
    }

    protected void drawLandingThrusters(float x, float y, float rotation, float frame) {
        float length = this.thrusterLength * (frame - 1.0f) - 0.25f;
        float alpha = Draw.getColor().a;
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < 4; ++i) {
                TextureRegion reg = i >= 2 ? this.thruster2 : this.thruster1;
                float rot = (float)(i * 90) + rotation % 90.0f;
                Tmp.v1.trns(rot, length * Draw.xscl);
                if (j == 1) {
                    Tmp.v1.rotate(-90.0f);
                    Draw.alpha(rotation % 90.0f / 90.0f * alpha);
                    Draw.rect(reg, x + Tmp.v1.x, y + Tmp.v1.y, rot -= 90.0f);
                    continue;
                }
                Draw.alpha(alpha);
                Draw.rect(reg, x + Tmp.v1.x, y + Tmp.v1.y, rot);
            }
        }
        Draw.alpha(1.0f);
    }

    static {
        thrusterSizes = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.3f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f};
    }

    public class CoreBuild
    extends Building {
        public int storageCapacity;
        public boolean noEffect = false;
        public Team lastDamage = Team.derelict;
        public float iframes = -1.0f;
        public float thrusterTime = 0.0f;

        @Override
        public void draw() {
            if (this.thrusterTime > 0.0f) {
                float frame = this.thrusterTime;
                Draw.alpha(1.0f);
                this.drawThrusters(frame);
                Draw.rect(this.block.region, this.x, this.y);
                Draw.alpha(Interp.pow4In.apply(frame));
                this.drawThrusters(frame);
                Draw.reset();
                this.drawTeamTop();
            } else {
                super.draw();
            }
        }

        public void drawThrusters(float frame) {
            float length = CoreBlock.this.thrusterLength * (frame - 1.0f) - 0.25f;
            for (int i = 0; i < 4; ++i) {
                TextureRegion reg = i >= 2 ? CoreBlock.this.thruster2 : CoreBlock.this.thruster1;
                float dx = (float)Geometry.d4x[i] * length;
                float dy = (float)Geometry.d4y[i] * length;
                Draw.rect(reg, this.x + dx, this.y + dy, (float)(i * 90));
            }
        }

        @Override
        public void damage(@Nullable Team source, float damage) {
            if (this.iframes > 0.0f) {
                return;
            }
            if (source != null && source != this.team) {
                this.lastDamage = source;
            }
            super.damage(source, damage);
        }

        @Override
        public void created() {
            super.created();
            Events.fire(new EventType.CoreChangeEvent(this));
        }

        @Override
        public void changeTeam(Team next) {
            if (this.team == next) {
                return;
            }
            Vars.state.teams.unregisterCore(this);
            super.changeTeam(next);
            Vars.state.teams.registerCore(this);
            Events.fire(new EventType.CoreChangeEvent(this));
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.itemCapacity) {
                return this.storageCapacity;
            }
            return super.sense(sensor);
        }

        @Override
        public boolean canControlSelect(Unit player) {
            return player.isPlayer();
        }

        @Override
        public void onControlSelect(Unit unit) {
            if (!unit.isPlayer()) {
                return;
            }
            Player player = unit.getPlayer();
            Fx.spawn.at(player);
            if (Vars.net.client() && player == Vars.player) {
                Vars.control.input.controlledType = null;
            }
            player.clearUnit();
            player.deathTimer = 61.0f;
            this.requestSpawn(player);
        }

        public void requestSpawn(Player player) {
            if (!CoreBlock.this.unitType.supportsEnv(Vars.state.rules.env)) {
                return;
            }
            Call.playerSpawn(this.tile, player);
        }

        @Override
        public void updateTile() {
            this.iframes -= Time.delta;
            this.thrusterTime -= Time.delta / 90.0f;
        }

        public void updateLandParticles() {
            float time = Vars.renderer.isLaunching() ? 160.0f - Vars.renderer.getLandTime() : Vars.renderer.getLandTime();
            float tsize = Mathf.sample(thrusterSizes, (time + 35.0f) / 160.0f);
            Vars.renderer.setLandPTimer(Vars.renderer.getLandPTimer() + tsize * Time.delta);
            if (Vars.renderer.getLandTime() >= 1.0f) {
                this.tile.getLinkedTiles(t -> {
                    if (Mathf.chance(0.4f)) {
                        Fx.coreLandDust.at(t.worldx(), t.worldy(), this.angleTo(t.worldx(), t.worldy()) + Mathf.range(30.0f), Tmp.c1.set(t.floor().mapColor).mul(1.5f + Mathf.range(0.15f)));
                    }
                });
                Vars.renderer.setLandPTimer(0.0f);
            }
        }

        @Override
        public boolean canPickup() {
            return false;
        }

        @Override
        public void onDestroyed() {
            if (Vars.state.rules.coreCapture) {
                Damage.dynamicExplosion(this.x, this.y, 0.0f, 0.0f, 0.0f, (float)(8 * this.block.size) / 2.0f, Vars.state.rules.damageExplosions);
                Fx.commandSend.at(this.x, this.y, 140.0f);
            } else {
                super.onDestroyed();
            }
            if (Vars.state.isCampaign() && this.team == Vars.state.rules.waveTeam && this.team.cores().size <= 1 && Vars.state.rules.sector.planet.enemyCoreSpawnReplace) {
                this.tile.setOverlayQuiet(Blocks.spawn);
                if (!Vars.spawner.getSpawns().contains(this.tile)) {
                    Vars.spawner.getSpawns().add(this.tile);
                }
            }
            Events.fire(new EventType.CoreChangeEvent(this));
        }

        @Override
        public void afterDestroyed() {
            if (Vars.state.rules.coreCapture) {
                if (!Vars.net.client()) {
                    this.tile.setBlock(this.block, this.lastDamage);
                }
                Core.app.post(() -> this.tile.setNet(this.block, this.lastDamage, 0));
                if (!Vars.net.client()) {
                    ((CoreBuild)this.tile.build).iframes = CoreBlock.this.captureInvicibility;
                }
            }
        }

        @Override
        public void drawLight() {
            Drawf.light(this.x, this.y, CoreBlock.this.lightRadius, Pal.accent, 0.65f + Mathf.absin(20.0f, 0.1f));
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return this.items.get(item) < this.getMaximumAccepted(item);
        }

        @Override
        public int getMaximumAccepted(Item item) {
            return Vars.state.rules.coreIncinerates ? this.storageCapacity * 20 : this.storageCapacity;
        }

        @Override
        public void onProximityUpdate() {
            super.onProximityUpdate();
            for (Building building : Vars.state.teams.cores(this.team)) {
                if (building.tile() == this.tile) continue;
                this.items = building.items;
            }
            Vars.state.teams.registerCore(this);
            this.storageCapacity = CoreBlock.this.itemCapacity + this.proximity().sum(e -> this.owns((Building)e) ? e.block.itemCapacity : 0);
            this.proximity.each(this::owns, t -> {
                t.items = this.items;
                ((StorageBlock.StorageBuild)t).linkedCore = this;
            });
            for (Building building : Vars.state.teams.cores(this.team)) {
                if (building.tile() == this.tile) continue;
                this.storageCapacity += building.block.itemCapacity + building.proximity().sum(e -> this.owns(other, (Building)e) ? e.block.itemCapacity : 0);
            }
            if (!Vars.world.isGenerating()) {
                for (Item item : Vars.content.items()) {
                    this.items.set(item, Math.min(this.items.get(item), this.storageCapacity));
                }
            }
            for (CoreBuild coreBuild : Vars.state.teams.cores(this.team)) {
                coreBuild.storageCapacity = this.storageCapacity;
            }
        }

        @Override
        public void handleStack(Item item, int amount, Teamc source) {
            boolean incinerate = CoreBlock.this.incinerateNonBuildable && !item.buildable;
            int realAmount = incinerate ? 0 : Math.min(amount, this.storageCapacity - this.items.get(item));
            super.handleStack(item, realAmount, source);
            if (this.team == Vars.state.rules.defaultTeam && Vars.state.isCampaign()) {
                if (!incinerate) {
                    Vars.state.rules.sector.info.handleCoreItem(item, amount);
                }
                if (realAmount == 0 && this.wasVisible) {
                    Fx.coreBurn.at(this.x, this.y);
                }
            }
        }

        @Override
        public int removeStack(Item item, int amount) {
            int result = super.removeStack(item, amount);
            if (this.team == Vars.state.rules.defaultTeam && Vars.state.isCampaign()) {
                Vars.state.rules.sector.info.handleCoreItem(item, -result);
            }
            return result;
        }

        @Override
        public void drawSelect() {
            if (this.team.cores().size <= 1 && !this.proximity.contains(storage -> storage.items == this.items)) {
                return;
            }
            Lines.stroke(1.0f, Pal.accent);
            Cons<Building> outline = b -> {
                for (int i = 0; i < 4; ++i) {
                    Point2 p = Geometry.d8edge[i];
                    float offset = (float)(-Math.max(b.block.size - 1, 0)) / 2.0f * 8.0f;
                    Draw.rect("block-select", b.x + offset * (float)p.x, b.y + offset * (float)p.y, (float)(i * 90));
                }
            };
            this.team.cores().each(core -> {
                outline.get((Building)core);
                core.proximity.each(storage -> storage.items == this.items, outline);
            });
            Draw.reset();
        }

        public boolean owns(Building tile) {
            return this.owns(this, tile);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean owns(Building core, Building tile) {
            if (!(tile instanceof StorageBlock.StorageBuild)) return false;
            StorageBlock.StorageBuild b = (StorageBlock.StorageBuild)tile;
            if (!((StorageBlock)b.block).coreMerge) return false;
            if (b.linkedCore == core) return true;
            if (b.linkedCore != null) return false;
            return true;
        }

        @Override
        public void damage(float amount) {
            if (Vars.player != null && this.team == Vars.player.team()) {
                Events.fire(EventType.Trigger.teamCoreDamage);
            }
            super.damage(amount);
        }

        @Override
        public void onRemoved() {
            int total = this.proximity.count(e -> e.items != null && e.items == this.items);
            float fract = 1.0f / (float)total / (float)Vars.state.teams.cores((Team)this.team).size;
            this.proximity.each(e -> this.owns((Building)e) && e.items == this.items && this.owns((Building)e), t -> {
                StorageBlock.StorageBuild ent = (StorageBlock.StorageBuild)t;
                ent.linkedCore = null;
                ent.items = new ItemModule();
                for (Item item : Vars.content.items()) {
                    ent.items.set(item, (int)(fract * (float)this.items.get(item)));
                }
            });
            Vars.state.teams.unregisterCore(this);
            for (CoreBuild other : Vars.state.teams.cores(this.team)) {
                other.onProximityUpdate();
            }
        }

        @Override
        public void placed() {
            super.placed();
            Vars.state.teams.registerCore(this);
        }

        @Override
        public void itemTaken(Item item) {
            if (Vars.state.isCampaign() && this.team == Vars.state.rules.defaultTeam) {
                Vars.state.rules.sector.info.handleCoreItem(item, -1);
            }
        }

        @Override
        public void handleItem(Building source, Item item) {
            boolean incinerate;
            boolean bl = incinerate = CoreBlock.this.incinerateNonBuildable && !item.buildable;
            if (this.team == Vars.state.rules.defaultTeam) {
                Vars.state.stats.coreItemCount.increment(item);
            }
            if (Vars.net.server() || !Vars.net.active()) {
                if (this.team == Vars.state.rules.defaultTeam && Vars.state.isCampaign() && !incinerate) {
                    Vars.state.rules.sector.info.handleCoreItem(item, 1);
                }
                if (this.items.get(item) >= this.storageCapacity || incinerate) {
                    if (!this.noEffect) {
                        StorageBlock.incinerateEffect(this, source);
                    }
                    this.noEffect = false;
                } else {
                    super.handleItem(source, item);
                }
            } else if ((Vars.state.rules.coreIncinerates && this.items.get(item) >= this.storageCapacity || incinerate) && !this.noEffect) {
                StorageBlock.incinerateEffect(this, source);
                this.noEffect = false;
            }
        }
    }
}

