/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.units;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.EnumSet;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Sized;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Entityc;
import mindustry.gen.Healthc;
import mindustry.gen.Rotc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.Ranged;
import mindustry.world.Block;
import mindustry.world.consumers.ConsumeCoolant;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.BlockStatus;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;

public class RepairTurret
extends Block {
    static final Rect rect = new Rect();
    static final Rand rand = new Rand();
    public int timerTarget;
    public int timerEffect;
    public float repairRadius;
    public float repairSpeed;
    public float powerUse;
    public float length;
    public float beamWidth;
    public float pulseRadius;
    public float pulseStroke;
    public boolean acceptCoolant;
    public float coolantUse;
    public Effect coolEffect;
    public float coolantMultiplier;
    public TextureRegion baseRegion;
    public TextureRegion laser;
    public TextureRegion laserEnd;
    public TextureRegion laserTop;
    public TextureRegion laserTopEnd;
    public Color laserColor;
    public Color laserTopColor;

    public RepairTurret(String name) {
        super(name);
        this.timerTarget = this.timers++;
        this.timerEffect = this.timers++;
        this.repairRadius = 50.0f;
        this.repairSpeed = 0.3f;
        this.length = 5.0f;
        this.beamWidth = 1.0f;
        this.pulseRadius = 6.0f;
        this.pulseStroke = 2.0f;
        this.acceptCoolant = false;
        this.coolantUse = 0.5f;
        this.coolEffect = Fx.fuelburn;
        this.coolantMultiplier = 1.0f;
        this.laserColor = Color.valueOf("98ffa9");
        this.laserTopColor = Color.white.cpy();
        this.update = true;
        this.solid = true;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.repair});
        this.hasPower = true;
        this.outlineIcon = true;
        this.group = BlockGroup.projectors;
        this.envEnabled |= 2;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.range, this.repairRadius / 8.0f, StatUnit.blocks);
        this.stats.add(Stat.repairSpeed, this.repairSpeed * 60.0f, StatUnit.perSecond);
        if (this.acceptCoolant) {
            this.stats.remove(Stat.booster);
            this.stats.add(Stat.booster, StatValues.speedBoosters(Core.bundle.get("bar.strength"), this.coolantUse, this.coolantMultiplier, true, this::consumesLiquid));
        }
    }

    @Override
    public void init() {
        if (this.acceptCoolant) {
            this.hasLiquids = true;
            this.consume(new ConsumeCoolant(this.coolantUse)).optional(true, true);
        }
        this.consumePowerCond(this.powerUse, entity -> entity.target != null);
        this.updateClipRadius(this.repairRadius);
        super.init();
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.repairRadius, Pal.accent);
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.baseRegion, this.region};
    }

    public static void drawBeam(float x, float y, float rotation, float length, int id, @Nullable Sized target, Team team, float strength, float pulseStroke, float pulseRadius, float beamWidth, Vec2 lastEnd, Vec2 offset, Color laserColor, Color laserTopColor, TextureRegion laser, TextureRegion laserEnd, TextureRegion laserTop, TextureRegion laserTopEnd) {
        float originY;
        int n;
        if (target instanceof Entityc) {
            Entityc e = (Entityc)((Object)target);
            n = e.id();
        } else {
            n = 0;
        }
        rand.setSeed(id + n);
        if (target != null) {
            float f;
            float originX = x + Angles.trnsx(rotation, length);
            originY = y + Angles.trnsy(rotation, length);
            lastEnd.set(target).sub(originX, originY);
            lastEnd.setLength(Math.max(2.0f, lastEnd.len()));
            Vec2 vec2 = offset.trns(rand.random(360.0f) + Time.time / 2.0f, Mathf.sin(Time.time + rand.random(200.0f), 55.0f, rand.random(target.hitSize() * 0.2f, target.hitSize() * 0.45f)));
            if (target instanceof Rotc) {
                Rotc rot = (Rotc)((Object)target);
                f = rot.rotation();
            } else {
                f = 0.0f;
            }
            lastEnd.add(vec2.rotate(f));
            lastEnd.add(originX, originY);
        }
        if (strength > 0.01f) {
            float originX = x + Angles.trnsx(rotation, length);
            originY = y + Angles.trnsy(rotation, length);
            Draw.z(116.0f);
            Draw.color(laserColor);
            float f = (Time.time / 85.0f + rand.random(1.0f)) % 1.0f;
            Draw.alpha(1.0f - Interp.pow5In.apply(f));
            Lines.stroke(strength * pulseStroke);
            Lines.circle(lastEnd.x, lastEnd.y, 1.0f + f * pulseRadius);
            Draw.color(laserColor);
            Drawf.laser(laser, laserEnd, originX, originY, lastEnd.x, lastEnd.y, strength * beamWidth);
            Draw.z(116.1f);
            Draw.color(laserTopColor);
            Drawf.laser(laserTop, laserTopEnd, originX, originY, lastEnd.x, lastEnd.y, strength * beamWidth);
            Draw.color();
        }
    }

    public class RepairPointBuild
    extends Building
    implements Ranged {
        public Unit target;
        public Vec2 offset = new Vec2();
        public Vec2 lastEnd = new Vec2();
        public float strength;
        public float rotation = 90.0f;

        @Override
        public void draw() {
            Draw.rect(RepairTurret.this.baseRegion, this.x, this.y);
            Draw.z(50.0f);
            Drawf.shadow(RepairTurret.this.region, this.x - (float)RepairTurret.this.size / 2.0f, this.y - (float)RepairTurret.this.size / 2.0f, this.rotation - 90.0f);
            Draw.rect(RepairTurret.this.region, this.x, this.y, this.rotation - 90.0f);
            RepairTurret.drawBeam(this.x, this.y, this.rotation, RepairTurret.this.length, this.id, this.target, this.team, this.strength, RepairTurret.this.pulseStroke, RepairTurret.this.pulseRadius, RepairTurret.this.beamWidth, this.lastEnd, this.offset, RepairTurret.this.laserColor, RepairTurret.this.laserTopColor, RepairTurret.this.laser, RepairTurret.this.laserEnd, RepairTurret.this.laserTop, RepairTurret.this.laserTopEnd);
        }

        @Override
        public void drawSelect() {
            Drawf.dashCircle(this.x, this.y, RepairTurret.this.repairRadius, Pal.accent);
        }

        @Override
        public void updateTile() {
            float multiplier = 1.0f;
            if (RepairTurret.this.acceptCoolant) {
                multiplier = 1.0f + this.liquids.current().heatCapacity * RepairTurret.this.coolantMultiplier * this.optionalEfficiency;
            }
            if (this.target != null && (this.target.dead() || this.target.dst(this) - this.target.hitSize / 2.0f > RepairTurret.this.repairRadius || this.target.health() >= this.target.maxHealth())) {
                this.target = null;
            }
            if (this.target == null) {
                this.offset.setZero();
            }
            boolean healed = false;
            if (this.target != null && this.efficiency > 0.0f) {
                float angle = Angles.angle(this.x, this.y, this.target.x + this.offset.x, this.target.y + this.offset.y);
                if (Angles.angleDist(angle, this.rotation) < 30.0f) {
                    healed = true;
                    this.target.heal(RepairTurret.this.repairSpeed * this.strength * this.edelta() * multiplier);
                }
                this.rotation = Mathf.slerpDelta(this.rotation, angle, 0.5f * this.efficiency * this.timeScale);
            }
            this.strength = Mathf.lerpDelta(this.strength, healed ? 1.0f : 0.0f, 0.08f * Time.delta);
            if (this.timer(RepairTurret.this.timerTarget, 20.0f)) {
                rect.setSize(RepairTurret.this.repairRadius * 2.0f).setCenter(this.x, this.y);
                this.target = Units.closest(this.team, this.x, this.y, RepairTurret.this.repairRadius, Healthc::damaged);
            }
        }

        @Override
        public boolean shouldConsume() {
            return this.target != null && this.enabled;
        }

        @Override
        public BlockStatus status() {
            return Mathf.equal(this.potentialEfficiency, 0.0f, 0.01f) ? BlockStatus.noInput : super.status();
        }

        @Override
        public float range() {
            return RepairTurret.this.repairRadius;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.rotation);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 1) {
                this.rotation = read.f();
            }
        }

        @Override
        public byte version() {
            return 1;
        }
    }
}

