/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawFlame
extends DrawBlock {
    public Color flameColor = Color.valueOf("ffc999");
    public TextureRegion top;
    public float lightRadius = 60.0f;
    public float lightAlpha = 0.65f;
    public float lightSinScl = 10.0f;
    public float lightSinMag = 5.0f;
    public float flameRadius = 3.0f;
    public float flameRadiusIn = 1.9f;
    public float flameRadiusScl = 5.0f;
    public float flameRadiusMag = 2.0f;
    public float flameRadiusInMag = 1.0f;

    public DrawFlame() {
    }

    public DrawFlame(Color flameColor) {
        this.flameColor = flameColor;
    }

    @Override
    public void load(Block block) {
        this.top = Core.atlas.find(block.name + "-top");
        block.clipSize = Math.max(block.clipSize, (this.lightRadius + this.lightSinMag) * 2.0f * (float)block.size);
    }

    @Override
    public void draw(Building build) {
        if (build.warmup() > 0.0f && this.flameColor.a > 0.001f) {
            float g = 0.3f;
            float r = 0.06f;
            float cr = Mathf.random(0.1f);
            Draw.z(30.01f);
            Draw.alpha(build.warmup());
            Draw.rect(this.top, build.x, build.y);
            Draw.alpha((1.0f - g + Mathf.absin(Time.time, 8.0f, g) + Mathf.random(r) - r) * build.warmup());
            Draw.tint(this.flameColor);
            Fill.circle(build.x, build.y, this.flameRadius + Mathf.absin(Time.time, this.flameRadiusScl, this.flameRadiusMag) + cr);
            Draw.color(1.0f, 1.0f, 1.0f, build.warmup());
            Fill.circle(build.x, build.y, this.flameRadiusIn + Mathf.absin(Time.time, this.flameRadiusScl, this.flameRadiusInMag) + cr);
            Draw.color();
        }
    }

    @Override
    public void drawLight(Building build) {
        Drawf.light(build.x, build.y, (this.lightRadius + Mathf.absin(this.lightSinScl, this.lightSinMag)) * build.warmup() * (float)build.block.size, this.flameColor, this.lightAlpha);
    }
}

