/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.graphics.g2d.TextureRegion;
import arc.struct.Seq;
import arc.util.Eachable;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawMulti
extends DrawBlock {
    public DrawBlock[] drawers = new DrawBlock[0];

    public DrawMulti() {
    }

    public DrawMulti(DrawBlock ... drawers) {
        this.drawers = drawers;
    }

    public DrawMulti(Seq<DrawBlock> drawers) {
        this.drawers = (DrawBlock[])drawers.toArray(DrawBlock.class);
    }

    @Override
    public void getRegionsToOutline(Block block, Seq<TextureRegion> out) {
        for (DrawBlock draw : this.drawers) {
            draw.getRegionsToOutline(block, out);
        }
    }

    @Override
    public void draw(Building build) {
        for (DrawBlock draw : this.drawers) {
            draw.draw(build);
        }
    }

    @Override
    public void drawPlan(Block block, BuildPlan plan, Eachable<BuildPlan> list) {
        for (DrawBlock draw : this.drawers) {
            draw.drawPlan(block, plan, list);
        }
    }

    @Override
    public void drawLight(Building build) {
        for (DrawBlock draw : this.drawers) {
            draw.drawLight(build);
        }
    }

    @Override
    public void load(Block block) {
        for (DrawBlock draw : this.drawers) {
            draw.load(block);
        }
    }

    @Override
    public TextureRegion[] icons(Block block) {
        Seq<TextureRegion> result = new Seq<TextureRegion>();
        for (DrawBlock draw : this.drawers) {
            result.addAll(draw.icons(block));
        }
        return (TextureRegion[])result.toArray(TextureRegion.class);
    }
}

