/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.gen.Building;
import mindustry.world.draw.DrawBlock;

public class DrawParticles
extends DrawBlock {
    public Color color = Color.valueOf("f2d585");
    public float alpha = 0.5f;
    public int particles = 30;
    public float particleLife = 70.0f;
    public float particleRad = 7.0f;
    public float particleSize = 3.0f;
    public float fadeMargin = 0.4f;
    public float rotateScl = 3.0f;
    public boolean reverse = false;
    public Interp particleInterp = new Interp.PowIn(1.5f);
    public Interp particleSizeInterp = Interp.slope;
    public Blending blending = Blending.normal;

    @Override
    public void draw(Building build) {
        if (build.warmup() > 0.0f) {
            float a = this.alpha * build.warmup();
            Draw.blend(this.blending);
            Draw.color(this.color);
            float base = Time.time / this.particleLife;
            rand.setSeed(build.id);
            for (int i = 0; i < this.particles; ++i) {
                float fin = (rand.random(2.0f) + base) % 1.0f;
                if (this.reverse) {
                    fin = 1.0f - fin;
                }
                float fout = 1.0f - fin;
                float angle = rand.random(360.0f) + Time.time / this.rotateScl % 360.0f;
                float len = this.particleRad * this.particleInterp.apply(fout);
                Draw.alpha(a * (1.0f - Mathf.curve(fin, 1.0f - this.fadeMargin)));
                Fill.circle(build.x + Angles.trnsx(angle, len), build.y + Angles.trnsy(angle, len), this.particleSize * this.particleSizeInterp.apply(fin) * build.warmup());
            }
            Draw.blend();
            Draw.reset();
        }
    }
}

