/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Eachable;
import arc.util.Tmp;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawPistons
extends DrawBlock {
    public float sinMag = 4.0f;
    public float sinScl = 6.0f;
    public float sinOffset = 50.0f;
    public float sideOffset = 0.0f;
    public float lenOffset = -1.0f;
    public float horiOffset = 0.0f;
    public float angleOffset = 0.0f;
    public int sides = 4;
    public String suffix = "-piston";
    public TextureRegion region1;
    public TextureRegion region2;
    public TextureRegion regiont;
    public TextureRegion iconRegion;

    @Override
    public void drawPlan(Block block, BuildPlan plan, Eachable<BuildPlan> list) {
        if (this.iconRegion.found()) {
            Draw.rect(this.iconRegion, plan.drawx(), plan.drawy());
        }
    }

    @Override
    public void draw(Building build) {
        for (int i = 0; i < this.sides; ++i) {
            TextureRegion reg;
            float len = Mathf.absin(build.totalProgress() + this.sinOffset + this.sideOffset * this.sinScl * (float)i, this.sinScl, this.sinMag) + this.lenOffset;
            float angle = this.angleOffset + (float)i * 360.0f / (float)this.sides;
            TextureRegion textureRegion = this.regiont.found() && (Mathf.equal(angle, 315.0f) || Mathf.equal(angle, 135.0f)) ? this.regiont : (reg = angle >= 135.0f && angle < 315.0f ? this.region2 : this.region1);
            if (Mathf.equal(angle, 315.0f)) {
                Draw.yscl = -1.0f;
            }
            Tmp.v1.trns(angle, len, -this.horiOffset);
            Draw.rect(reg, build.x + Tmp.v1.x, build.y + Tmp.v1.y, angle);
            Draw.yscl = 1.0f;
        }
    }

    @Override
    public void load(Block block) {
        super.load(block);
        this.region1 = Core.atlas.find(block.name + this.suffix + "0", block.name + this.suffix);
        this.region2 = Core.atlas.find(block.name + this.suffix + "1", block.name + this.suffix);
        this.regiont = Core.atlas.find(block.name + this.suffix + "-t");
        this.iconRegion = Core.atlas.find(block.name + this.suffix + "-icon");
    }

    @Override
    public TextureRegion[] icons(Block block) {
        return new TextureRegion[]{this.iconRegion};
    }
}

