/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.util.Eachable;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawRegion
extends DrawBlock {
    public TextureRegion region;
    public String suffix = "";
    public boolean spinSprite = false;
    public boolean drawPlan = true;
    public boolean buildingRotate = false;
    public float rotateSpeed;
    public float x;
    public float y;
    public float rotation;
    public float layer = -1.0f;

    public DrawRegion(String suffix) {
        this.suffix = suffix;
    }

    public DrawRegion(String suffix, float rotateSpeed) {
        this.suffix = suffix;
        this.rotateSpeed = rotateSpeed;
    }

    public DrawRegion(String suffix, float rotateSpeed, boolean spinSprite) {
        this.suffix = suffix;
        this.spinSprite = spinSprite;
        this.rotateSpeed = rotateSpeed;
    }

    public DrawRegion() {
    }

    @Override
    public void draw(Building build) {
        float z = Draw.z();
        if (this.layer > 0.0f) {
            Draw.z(this.layer);
        }
        if (this.spinSprite) {
            Drawf.spinSprite(this.region, build.x + this.x, build.y + this.y, build.totalProgress() * this.rotateSpeed + this.rotation + (this.buildingRotate ? build.rotdeg() : 0.0f));
        } else {
            Draw.rect(this.region, build.x + this.x, build.y + this.y, build.totalProgress() * this.rotateSpeed + this.rotation + (this.buildingRotate ? build.rotdeg() : 0.0f));
        }
        Draw.z(z);
    }

    @Override
    public void drawPlan(Block block, BuildPlan plan, Eachable<BuildPlan> list) {
        if (!this.drawPlan) {
            return;
        }
        Draw.rect(this.region, plan.drawx(), plan.drawy(), this.buildingRotate ? (float)plan.rotation * 90.0f : 0.0f);
    }

    @Override
    public TextureRegion[] icons(Block block) {
        return new TextureRegion[]{this.region};
    }

    @Override
    public void load(Block block) {
        this.region = Core.atlas.find(block.name + this.suffix);
    }
}

