/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.meta;

import arc.Core;
import arc.func.Boolf;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.style.Drawable;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Collapser;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectFloatMap;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Scaling;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.content.StatusEffects;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.abilities.Ability;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Icon;
import mindustry.maps.Map;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.LiquidStack;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.ui.ItemDisplay;
import mindustry.ui.LiquidDisplay;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.meta.Attribute;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValue;

public class StatValues {
    public static StatValue string(String value, Object ... args) {
        String result = Strings.format(value, args);
        return table -> table.add(result);
    }

    public static StatValue bool(boolean value) {
        return table -> table.add(!value ? "@no" : "@yes");
    }

    public static String fixValue(float value) {
        return Strings.autoFixed(value, 2);
    }

    public static StatValue squared(float value, StatUnit unit) {
        return table -> {
            String fixed = StatValues.fixValue(value);
            table.add(fixed + "x" + fixed);
            table.add((unit.space ? " " : "") + unit.localized());
        };
    }

    public static StatValue number(float value, StatUnit unit, boolean merge) {
        return table -> {
            String l1 = (unit.icon == null ? "" : unit.icon + " ") + StatValues.fixValue(value);
            String l2 = (unit.space ? " " : "") + unit.localized();
            if (merge) {
                table.add(l1 + l2).left();
            } else {
                table.add(l1).left();
                table.add(l2).left();
            }
        };
    }

    public static StatValue number(float value, StatUnit unit) {
        return StatValues.number(value, unit, false);
    }

    public static StatValue liquid(Liquid liquid, float amount, boolean perSecond) {
        return table -> table.add(new LiquidDisplay(liquid, amount, perSecond));
    }

    public static StatValue liquids(Boolf<Liquid> filter, float amount, boolean perSecond) {
        return table -> {
            Seq<Liquid> list = Vars.content.liquids().select(i -> filter.get((Liquid)i) && i.unlockedNow() && !i.isHidden());
            for (int i2 = 0; i2 < list.size; ++i2) {
                table.add(new LiquidDisplay(list.get(i2), amount, perSecond)).padRight(5.0f);
                if (i2 == list.size - 1) continue;
                table.add("/");
            }
        };
    }

    public static StatValue liquids(float timePeriod, LiquidStack ... stacks) {
        return StatValues.liquids(timePeriod, true, stacks);
    }

    public static StatValue liquids(float timePeriod, boolean perSecond, LiquidStack ... stacks) {
        return table -> {
            for (LiquidStack stack : stacks) {
                table.add(new LiquidDisplay(stack.liquid, stack.amount * (60.0f / timePeriod), perSecond)).padRight(5.0f);
            }
        };
    }

    public static StatValue items(ItemStack ... stacks) {
        return StatValues.items(true, stacks);
    }

    public static StatValue items(boolean displayName, ItemStack ... stacks) {
        return table -> {
            for (ItemStack stack : stacks) {
                table.add(new ItemDisplay(stack.item, stack.amount, displayName)).padRight(5.0f);
            }
        };
    }

    public static StatValue items(float timePeriod, ItemStack ... stacks) {
        return table -> {
            for (ItemStack stack : stacks) {
                table.add(new ItemDisplay(stack.item, stack.amount, timePeriod, true)).padRight(5.0f);
            }
        };
    }

    public static StatValue items(Boolf<Item> filter) {
        return StatValues.items(-1.0f, filter);
    }

    public static StatValue items(float timePeriod, Boolf<Item> filter) {
        return table -> {
            Seq<Item> list = Vars.content.items().select(i -> filter.get((Item)i) && i.unlockedNow() && !i.isHidden());
            for (int i2 = 0; i2 < list.size; ++i2) {
                Item item = list.get(i2);
                table.add(timePeriod <= 0.0f ? new ItemDisplay(item) : new ItemDisplay(item, 1, timePeriod, true)).padRight(5.0f);
                if (i2 == list.size - 1) continue;
                table.add("/");
            }
        };
    }

    public static StatValue content(UnlockableContent content) {
        return table -> {
            table.add(new Image(content.uiIcon)).size(24.0f).padRight(3.0f);
            table.add(content.localizedName).padRight(3.0f);
        };
    }

    public static StatValue blockEfficiency(Block floor, float multiplier, boolean startZero) {
        return table -> table.stack(new Image(floor.uiIcon).setScaling(Scaling.fit), new Table(t -> t.top().right().add((multiplier < 0.0f ? "[scarlet]" : (startZero ? "[accent]" : "[accent]+")) + (int)(multiplier * 100.0f) + "%").style(Styles.outlineLabel))).maxSize(64.0f);
    }

    public static StatValue blocks(Attribute attr, boolean floating, float scale, boolean startZero) {
        return StatValues.blocks(attr, floating, scale, startZero, true);
    }

    public static StatValue blocks(Attribute attr, boolean floating, float scale, boolean startZero, boolean checkFloors) {
        return table -> table.table(c -> {
            Runnable[] rebuild = new Runnable[]{null};
            Map[] lastMap = new Map[]{null};
            rebuild[0] = () -> {
                c.clearChildren();
                c.left();
                if (Vars.state.isGame()) {
                    Seq<Block> blocks = Vars.content.blocks().select(block -> {
                        Floor f;
                        return !(checkFloors && !(block instanceof Floor) || !Vars.indexer.isBlockPresent((Block)block) || block.attributes.get(attr) == 0.0f || block instanceof Floor && (f = (Floor)block).isDeep() && !floating);
                    }).with(s -> s.sort(f -> f.attributes.get(attr)));
                    if (blocks.any()) {
                        int i = 0;
                        for (Block block2 : blocks) {
                            StatValues.blockEfficiency(block2, block2.attributes.get(attr) * scale, startZero).display((Table)c);
                            if (++i % 5 != 0) continue;
                            c.row();
                        }
                    } else {
                        c.add("@none.inmap");
                    }
                } else {
                    c.add("@stat.showinmap");
                }
            };
            rebuild[0].run();
            c.update(() -> {
                Map current;
                Map map = current = Vars.state.isGame() ? Vars.state.map : null;
                if (current != lastMap[0]) {
                    rebuild[0].run();
                    lastMap[0] = current;
                }
            });
        });
    }

    public static StatValue content(Seq<UnlockableContent> list) {
        return StatValues.content(list, i -> true);
    }

    public static <T extends UnlockableContent> StatValue content(Seq<T> list, Boolf<T> check) {
        return table -> table.table(l -> {
            l.left();
            boolean any = false;
            for (int i = 0; i < list.size; ++i) {
                UnlockableContent item = (UnlockableContent)list.get(i);
                if (!check.get(item)) continue;
                any = true;
                if (item.uiIcon.found()) {
                    l.image(item.uiIcon).size(24.0f).padRight(2.0f).padLeft(2.0f).padTop(3.0f).padBottom(3.0f);
                }
                l.add(item.localizedName).left().padLeft(1.0f).padRight(4.0f).colspan(item.uiIcon.found() ? 1 : 2);
                if (i % 5 != 4) continue;
                l.row();
            }
            if (!any) {
                l.add("@none.inmap");
            }
        });
    }

    public static StatValue blocks(Boolf<Block> pred) {
        return StatValues.content(Vars.content.blocks(), pred);
    }

    public static StatValue blocks(Seq<Block> list) {
        return StatValues.content(list.as());
    }

    public static StatValue statusEffects(Seq<StatusEffect> list) {
        return StatValues.content(list.as());
    }

    public static StatValue drillables(float drillTime, float drillMultiplier, float size, ObjectFloatMap<Item> multipliers, Boolf<Block> filter) {
        return table -> {
            table.row();
            table.table(c -> {
                int i = 0;
                for (Block block : Vars.content.blocks()) {
                    if (!filter.get(block)) continue;
                    c.table(Styles.grayPanel, b -> {
                        b.image(block.uiIcon).size(40.0f).pad(10.0f).left().scaling(Scaling.fit);
                        b.table(info -> {
                            info.left();
                            info.add(block.localizedName).left().row();
                            info.add(block.itemDrop.emoji()).left();
                        }).grow();
                        if (multipliers != null) {
                            b.add(Strings.autoFixed(60.0f / (Math.max(drillTime + drillMultiplier * (float)block.itemDrop.hardness, drillTime) / multipliers.get(block.itemDrop, 1.0f)) * size, 2) + StatUnit.perSecond.localized()).right().pad(10.0f).padRight(15.0f).color(Color.lightGray);
                        }
                    }).growX().pad(5.0f);
                    if (++i % 2 != 0) continue;
                    c.row();
                }
            }).growX().colspan(table.getColumns());
        };
    }

    public static StatValue boosters(float reload, float maxUsed, float multiplier, boolean baseReload, Boolf<Liquid> filter) {
        return table -> {
            table.row();
            table.table(c -> {
                for (Liquid liquid : Vars.content.liquids()) {
                    if (!filter.get(liquid)) continue;
                    c.table(Styles.grayPanel, b -> {
                        b.image(liquid.uiIcon).size(40.0f).pad(10.0f).left().scaling(Scaling.fit);
                        b.table(info -> {
                            info.add(liquid.localizedName).left().row();
                            info.add(Strings.autoFixed(maxUsed * 60.0f, 2) + StatUnit.perSecond.localized()).left().color(Color.lightGray);
                        });
                        b.table(bt -> {
                            bt.right().defaults().padRight(3.0f).left();
                            float reloadRate = (baseReload ? 1.0f : 0.0f) + maxUsed * multiplier * liquid.heatCapacity;
                            float standardReload = baseReload ? reload : reload / (maxUsed * multiplier * 0.4f);
                            float result = standardReload / (reload / reloadRate);
                            bt.add(Core.bundle.format("bullet.reload", Strings.autoFixed(result * 100.0f, 2))).pad(5.0f);
                        }).right().grow().pad(10.0f).padRight(15.0f);
                    }).growX().pad(5.0f).row();
                }
            }).growX().colspan(table.getColumns());
            table.row();
        };
    }

    public static StatValue speedBoosters(String unit, float amount, float speed, boolean strength, Boolf<Liquid> filter) {
        return table -> {
            table.row();
            table.table(c -> {
                for (Liquid liquid : Vars.content.liquids()) {
                    if (!filter.get(liquid)) continue;
                    c.table(Styles.grayPanel, b -> {
                        b.image(liquid.uiIcon).size(40.0f).pad(10.0f).left().scaling(Scaling.fit);
                        b.table(info -> {
                            info.add(liquid.localizedName).left().row();
                            info.add(Strings.autoFixed(amount * 60.0f, 2) + StatUnit.perSecond.localized()).left().color(Color.lightGray);
                        });
                        b.table(bt -> {
                            bt.right().defaults().padRight(3.0f).left();
                            if (speed != Float.MAX_VALUE) {
                                bt.add(unit.replace("{0}", "[stat]" + Strings.autoFixed(speed * (strength ? liquid.heatCapacity : 1.0f) + (strength ? 1.0f : 0.0f), 2) + "[lightgray]")).pad(5.0f);
                            }
                        }).right().grow().pad(10.0f).padRight(15.0f);
                    }).growX().pad(5.0f).row();
                }
            }).growX().colspan(table.getColumns());
            table.row();
        };
    }

    public static StatValue itemBoosters(String unit, float timePeriod, float speedBoost, float rangeBoost, ItemStack[] items, Boolf<Item> filter) {
        return table -> {
            table.row();
            table.table(c -> {
                for (Item item : Vars.content.items()) {
                    if (!filter.get(item)) continue;
                    c.table(Styles.grayPanel, b -> {
                        for (ItemStack stack : items) {
                            if (timePeriod < 0.0f) {
                                b.add(new ItemDisplay(stack.item, stack.amount, true)).pad(20.0f).left();
                            } else {
                                b.add(new ItemDisplay(stack.item, stack.amount, timePeriod, true)).pad(20.0f).left();
                            }
                            if (items.length <= 1) continue;
                            b.row();
                        }
                        b.table(bt -> {
                            bt.right().defaults().padRight(3.0f).left();
                            if (rangeBoost != 0.0f) {
                                bt.add("[lightgray]+[stat]" + Strings.autoFixed(rangeBoost / 8.0f, 2) + "[lightgray] " + StatUnit.blocks.localized()).row();
                            }
                            if (speedBoost != 0.0f) {
                                bt.add("[lightgray]" + unit.replace("{0}", "[stat]" + Strings.autoFixed(speedBoost, 2) + "[lightgray]"));
                            }
                        }).right().grow().pad(10.0f).padRight(15.0f);
                    }).growX().pad(5.0f).padBottom(-5.0f).row();
                }
            }).growX().colspan(table.getColumns());
            table.row();
        };
    }

    public static StatValue weapons(UnitType unit, Seq<Weapon> weapons) {
        return table -> {
            table.row();
            for (int i = 0; i < weapons.size; ++i) {
                Weapon weapon = (Weapon)weapons.get(i);
                if (weapon.flipSprite || !weapon.hasStats(unit)) continue;
                TextureRegion region = !weapon.name.isEmpty() ? Core.atlas.find(weapon.name + "-preview", weapon.region) : null;
                table.table(Styles.grayPanel, w -> {
                    w.left().top().defaults().padRight(3.0f).left();
                    if (region != null && region.found() && weapon.showStatSprite) {
                        w.image(region).size(60.0f).scaling(Scaling.bounded).left().top();
                    }
                    w.row();
                    weapon.addStats(unit, (Table)w);
                }).growX().pad(5.0f).margin(10.0f);
                table.row();
            }
        };
    }

    public static StatValue abilities(Seq<Ability> abilities) {
        return table -> {
            table.row();
            table.table(t -> abilities.each(ability -> {
                if (ability.display) {
                    t.row();
                    t.table(Styles.grayPanel, a -> {
                        a.add("[accent]" + ability.localized()).padBottom(4.0f);
                        a.row();
                        a.left().top().defaults().left();
                        ability.addStats((Table)a);
                    }).pad(5.0f).margin(10.0f).growX();
                }
            }));
        };
    }

    public static <T extends UnlockableContent> StatValue ammo(ObjectMap<T, BulletType> map) {
        return StatValues.ammo(map, 0, false);
    }

    public static <T extends UnlockableContent> StatValue ammo(ObjectMap<T, BulletType> map, boolean showUnit) {
        return StatValues.ammo(map, 0, showUnit);
    }

    public static <T extends UnlockableContent> StatValue ammo(ObjectMap<T, BulletType> map, int indent, boolean showUnit) {
        return table -> {
            table.row();
            Seq orderedKeys = map.keys().toSeq();
            orderedKeys.sort();
            for (UnlockableContent t : orderedKeys) {
                boolean compact = t instanceof UnitType && !showUnit || indent > 0;
                BulletType type = (BulletType)map.get(t);
                if (type.spawnUnit != null && type.spawnUnit.weapons.size > 0) {
                    StatValues.ammo(ObjectMap.of(t, type.spawnUnit.weapons.first().bullet), indent, false).display(table);
                    continue;
                }
                table.table(Styles.grayPanel, bt -> {
                    Collapser coll;
                    int val;
                    block23: {
                        block24: {
                            bt.left().top().defaults().padRight(3.0f).left();
                            if (!compact && !(t instanceof Turret)) {
                                bt.table(title -> {
                                    title.image(StatValues.icon(t)).size(24.0f).padRight(4.0f).right().scaling(Scaling.fit).top();
                                    title.add(t.localizedName).padRight(10.0f).left().top();
                                });
                                bt.row();
                            }
                            if (type.damage > 0.0f && (type.collides || type.splashDamage <= 0.0f)) {
                                if (type.continuousDamage() > 0.0f) {
                                    bt.add(Core.bundle.format("bullet.damage", Float.valueOf(type.continuousDamage())) + StatUnit.perSecond.localized());
                                } else {
                                    bt.add(Core.bundle.format("bullet.damage", Float.valueOf(type.damage)));
                                }
                            }
                            if (type.buildingDamageMultiplier != 1.0f) {
                                val = (int)(type.buildingDamageMultiplier * 100.0f - 100.0f);
                                StatValues.sep(bt, Core.bundle.format("bullet.buildingdamage", StatValues.ammoStat(val)));
                            }
                            if (type.rangeChange != 0.0f && !compact) {
                                StatValues.sep(bt, Core.bundle.format("bullet.range", StatValues.ammoStat(type.rangeChange / 8.0f)));
                            }
                            if (type.splashDamage > 0.0f) {
                                StatValues.sep(bt, Core.bundle.format("bullet.splashdamage", (int)type.splashDamage, Strings.fixed(type.splashDamageRadius / 8.0f, 1)));
                            }
                            if (compact || Mathf.equal(type.ammoMultiplier, 1.0f) || !type.displayAmmoMultiplier) break block23;
                            if (!(t instanceof Turret)) break block24;
                            Turret turret = (Turret)t;
                            if (!turret.displayAmmoMultiplier) break block23;
                        }
                        StatValues.sep(bt, Core.bundle.format("bullet.multiplier", (int)type.ammoMultiplier));
                    }
                    if (!compact && !Mathf.equal(type.reloadMultiplier, 1.0f)) {
                        val = (int)(type.reloadMultiplier * 100.0f - 100.0f);
                        StatValues.sep(bt, Core.bundle.format("bullet.reload", StatValues.ammoStat(val)));
                    }
                    if (type.knockback > 0.0f) {
                        StatValues.sep(bt, Core.bundle.format("bullet.knockback", Strings.autoFixed(type.knockback, 2)));
                    }
                    if (type.healPercent > 0.0f) {
                        StatValues.sep(bt, Core.bundle.format("bullet.healpercent", Strings.autoFixed(type.healPercent, 2)));
                    }
                    if (type.healAmount > 0.0f) {
                        StatValues.sep(bt, Core.bundle.format("bullet.healamount", Strings.autoFixed(type.healAmount, 2)));
                    }
                    if (type.pierce || type.pierceCap != -1) {
                        StatValues.sep(bt, type.pierceCap == -1 ? "@bullet.infinitepierce" : Core.bundle.format("bullet.pierce", type.pierceCap));
                    }
                    if (type.incendAmount > 0) {
                        StatValues.sep(bt, "@bullet.incendiary");
                    }
                    if (type.homingPower > 0.01f) {
                        StatValues.sep(bt, "@bullet.homing");
                    }
                    if (type.lightning > 0) {
                        StatValues.sep(bt, Core.bundle.format("bullet.lightning", type.lightning, Float.valueOf(type.lightningDamage < 0.0f ? type.damage : type.lightningDamage)));
                    }
                    if (type.pierceArmor) {
                        StatValues.sep(bt, "@bullet.armorpierce");
                    }
                    if (type.suppressionRange > 0.0f) {
                        StatValues.sep(bt, Core.bundle.format("bullet.suppression", Strings.autoFixed(type.suppressionDuration / 60.0f, 2), Strings.fixed(type.suppressionRange / 8.0f, 1)));
                    }
                    if (type.status != StatusEffects.none) {
                        StatValues.sep(bt, (type.status.minfo.mod == null ? type.status.emoji() : "") + "[stat]" + type.status.localizedName + (type.status.reactive ? "" : "[lightgray] ~ [stat]" + (int)(type.statusDuration / 60.0f) + "[lightgray] " + Core.bundle.get("unit.seconds")));
                    }
                    if (type.intervalBullet != null) {
                        bt.row();
                        Table ic = new Table();
                        StatValues.ammo(ObjectMap.of(t, type.intervalBullet), indent + 1, false).display(ic);
                        coll = new Collapser(ic, true);
                        coll.setDuration(0.1f);
                        bt.table(it -> {
                            it.left().defaults().left();
                            it.add(Core.bundle.format("bullet.interval", Strings.autoFixed((float)type.intervalBullets / type.bulletInterval * 60.0f, 2)));
                            it.button((Drawable)Icon.downOpen, Styles.emptyi, () -> coll.toggle(false)).update(i -> {
                                i.getStyle().imageUp = !coll.isCollapsed() ? Icon.upOpen : Icon.downOpen;
                            }).size(8.0f).padLeft(16.0f).expandX();
                        });
                        bt.row();
                        bt.add(coll);
                    }
                    if (type.fragBullet != null) {
                        bt.row();
                        Table fc = new Table();
                        StatValues.ammo(ObjectMap.of(t, type.fragBullet), indent + 1, false).display(fc);
                        coll = new Collapser(fc, true);
                        coll.setDuration(0.1f);
                        bt.table(ft -> {
                            ft.left().defaults().left();
                            ft.add(Core.bundle.format("bullet.frags", type.fragBullets));
                            ft.button((Drawable)Icon.downOpen, Styles.emptyi, () -> coll.toggle(false)).update(i -> {
                                i.getStyle().imageUp = !coll.isCollapsed() ? Icon.upOpen : Icon.downOpen;
                            }).size(8.0f).padLeft(16.0f).expandX();
                        });
                        bt.row();
                        bt.add(coll);
                    }
                }).padLeft(indent * 5).padTop(5.0f).padBottom(compact ? 0.0f : 5.0f).growX().margin(compact ? 0.0f : 10.0f);
                table.row();
            }
        };
    }

    private static void sep(Table table, String text) {
        table.row();
        table.add(text);
    }

    private static String ammoStat(float val) {
        return (val > 0.0f ? "[stat]+" : "[negstat]") + Strings.autoFixed(val, 1);
    }

    private static TextureRegion icon(UnlockableContent t) {
        return t.uiIcon;
    }
}

