/*
 * Decompiled with CFR 0.152.
 */
package rhino.typedarrays;

import rhino.Context;
import rhino.IdFunctionObject;
import rhino.Scriptable;
import rhino.Undefined;
import rhino.typedarrays.ByteIo;
import rhino.typedarrays.Conversions;
import rhino.typedarrays.NativeArrayBuffer;
import rhino.typedarrays.NativeTypedArrayView;

public class NativeUint8Array
extends NativeTypedArrayView<Integer> {
    private static final String CLASS_NAME = "Uint8Array";

    public NativeUint8Array() {
    }

    public NativeUint8Array(NativeArrayBuffer ab, int off, int len) {
        super(ab, off, len, len);
    }

    public NativeUint8Array(int len) {
        this(new NativeArrayBuffer(len), 0, len);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeUint8Array a = new NativeUint8Array();
        a.exportAsJSClass(6, scope, sealed);
    }

    protected NativeUint8Array construct(NativeArrayBuffer ab, int off, int len) {
        return new NativeUint8Array(ab, off, len);
    }

    @Override
    public int getBytesPerElement() {
        return 1;
    }

    protected NativeUint8Array realThis(Scriptable thisObj, IdFunctionObject f) {
        if (!(thisObj instanceof NativeUint8Array)) {
            throw NativeUint8Array.incompatibleCallError(f);
        }
        return (NativeUint8Array)thisObj;
    }

    @Override
    protected Object js_get(int index) {
        if (this.checkIndex(index)) {
            return Undefined.instance;
        }
        return ByteIo.readUint8(this.arrayBuffer.buffer, index + this.offset);
    }

    @Override
    protected Object js_set(int index, Object c) {
        if (this.checkIndex(index)) {
            return Undefined.instance;
        }
        int val = Conversions.toUint8(c);
        ByteIo.writeUint8(this.arrayBuffer.buffer, index + this.offset, val);
        return null;
    }

    @Override
    public Integer get(int i) {
        if (this.checkIndex(i)) {
            throw new IndexOutOfBoundsException();
        }
        return (Integer)this.js_get(i);
    }

    @Override
    public Integer set(int i, Integer aByte) {
        if (this.checkIndex(i)) {
            throw new IndexOutOfBoundsException();
        }
        return (Integer)this.js_set(i, aByte);
    }
}

