/*
 * Decompiled with CFR 0.152.
 */
package free.chess.variants.suicide;

import free.chess.ChessPiece;
import free.chess.Piece;
import free.chess.Position;
import free.chess.Square;
import free.chess.variants.NoCastlingVariant;

public class Suicide
extends NoCastlingVariant {
    private static final ChessPiece[] WHITE_PROMOTION_TARGETS = new ChessPiece[]{ChessPiece.WHITE_QUEEN, ChessPiece.WHITE_ROOK, ChessPiece.WHITE_BISHOP, ChessPiece.WHITE_KNIGHT, ChessPiece.WHITE_PAWN, ChessPiece.WHITE_KING};
    private static final ChessPiece[] BLACK_PROMOTION_TARGETS = new ChessPiece[]{ChessPiece.BLACK_QUEEN, ChessPiece.BLACK_ROOK, ChessPiece.BLACK_BISHOP, ChessPiece.BLACK_KNIGHT, ChessPiece.BLACK_PAWN, ChessPiece.BLACK_KING};
    private static final Suicide INSTANCE = new Suicide();

    public static Suicide getInstance() {
        return INSTANCE;
    }

    private Suicide() {
        super("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "Suicide");
    }

    public Piece[] getPromotionTargets(Position position, Square square, Square square2) {
        this.checkPosition(position);
        ChessPiece chessPiece = (ChessPiece)position.getPieceAt(square);
        if (square2.getRank() == 7 && chessPiece == ChessPiece.WHITE_PAWN) {
            return (Piece[])WHITE_PROMOTION_TARGETS.clone();
        }
        if (square2.getRank() == 0 && chessPiece == ChessPiece.BLACK_PAWN) {
            return (Piece[])BLACK_PROMOTION_TARGETS.clone();
        }
        return null;
    }
}

