/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.SimpleNode;

public class EvalError
extends Exception {
    SimpleNode node;
    String message;

    public String toString() {
        String string = this.node != null ? " : at Line: " + this.node.getLineNumber() + " : in file: " + this.node.getSourceFile() + " : " + this.node.getText() : ": <at unknown location>";
        return this.getMessage() + string;
    }

    public void reThrow(String string) throws EvalError {
        this.reThrow(string, null);
    }

    public void reThrow(SimpleNode simpleNode) throws EvalError {
        this.reThrow(null, simpleNode);
    }

    public void reThrow(String string, SimpleNode simpleNode) throws EvalError {
        this.prependMessage(string);
        this.addNode(simpleNode);
        throw this;
    }

    void setNode(SimpleNode simpleNode) {
        this.node = simpleNode;
    }

    SimpleNode getNode() {
        return this.node;
    }

    public String getErrorText() {
        if (this.node != null) {
            return this.node.getText();
        }
        return "<unknown error>";
    }

    public int getErrorLineNumber() {
        if (this.node != null) {
            return this.node.getLineNumber();
        }
        return -1;
    }

    public String getErrorSourceFile() {
        if (this.node != null) {
            return this.node.getSourceFile();
        }
        return "<unknown file>";
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    protected void prependMessage(String string) {
        if (string != null) {
            this.message = string + " : " + this.message;
        }
    }

    protected void addNode(SimpleNode simpleNode) {
        SimpleNode simpleNode2 = this.node;
        if (simpleNode2 == null && simpleNode != null) {
            simpleNode2 = simpleNode;
        }
    }

    public EvalError(String string) {
        this.setMessage(string);
    }

    public EvalError(String string, SimpleNode simpleNode) {
        this(string);
        this.node = simpleNode;
    }
}

