/*
 * Decompiled with CFR 0.152.
 */
package free.jin;

import free.jin.ConnectionDetails;
import free.jin.I18n;
import free.jin.Jin;
import free.jin.Preferences;
import free.jin.Server;
import free.jin.Session;
import free.jin.SessionEvent;
import free.jin.SessionListener;
import free.jin.User;
import free.jin.plugin.PluginStartException;
import free.jin.ui.LoginPanel;
import free.jin.ui.OptionPanel;
import free.jin.ui.ServerChoicePanel;
import free.util.EventListenerList;
import free.util.TextUtilities;
import free.util.Utilities;
import java.util.List;

public class ConnectionManager {
    private Session session = null;
    private final EventListenerList listenerList = new EventListenerList();

    public void start() {
        Server server = this.findLoginServer();
        if (server == null) {
            return;
        }
        User user = this.findLoginUser(server);
        ConnectionDetails connectionDetails = this.findConnDetails(server, user);
        if (connectionDetails == null) {
            Jin.getInstance().quitIfNoUiVisible();
            return;
        }
        this.login(connectionDetails);
    }

    private Server findLoginServer() {
        Object object;
        Object object2;
        Jin jin = Jin.getInstance();
        String string = jin.getParameter("login.server");
        if (string != null) {
            object2 = jin.getServerById(string);
            if (object2 == null) {
                object = I18n.get(this.getClass());
                ((I18n)object).error("unknownServerParam", new Object[]{string});
            } else {
                return object2;
            }
        }
        if ((object2 = this.getLastUser()) != null) {
            return ((User)object2).getServer();
        }
        if (jin.getServers().length == 1) {
            return jin.getServers()[0];
        }
        object = new ServerChoicePanel().askServer();
        if (object != null) {
            return object;
        }
        return null;
    }

    private User findLoginUser(Server server) {
        Jin jin = Jin.getInstance();
        boolean bl = new Boolean(jin.getParameter("login.guest"));
        String string = jin.getParameter("login.username");
        if (bl) {
            return server.getGuest();
        }
        if (string != null) {
            User user = jin.getUser(server, string);
            if (user == null) {
                return new User(server, string);
            }
            return user;
        }
        User user = this.getLastUser();
        if (user != null && user.getServer() == server) {
            return user;
        }
        List list = jin.getUsers(server);
        if (list.size() == 1) {
            return (User)list.get(0);
        }
        return null;
    }

    private ConnectionDetails findConnDetails(Server server, User user) {
        String string;
        String string2;
        if (user == null) {
            return new LoginPanel(server).askConnectionDetails();
        }
        Jin jin = Jin.getInstance();
        ConnectionDetails connectionDetails = user.getPreferredConnDetails();
        String string3 = jin.getParameter("login.password");
        if (string3 == null) {
            string3 = connectionDetails.getPassword();
        }
        String string4 = jin.getParameter("login.savepassword");
        boolean bl = new Boolean(string4);
        if (string4 == null && !connectionDetails.isGuest()) {
            bl = connectionDetails.isSavePassword();
        }
        if ((string2 = jin.getParameter("login.hostname")) == null) {
            string2 = connectionDetails.getHost();
        }
        int[] nArray = (string = jin.getParameter("login.ports")) != null ? TextUtilities.parseIntList(string, ",") : connectionDetails.getPorts();
        connectionDetails = user.isGuest() ? ConnectionDetails.createGuest(server, user.getUsername(), string2, nArray) : ConnectionDetails.create(server, user, user.getUsername(), string3, bl, string2, nArray);
        if (!new Boolean(jin.getParameter("autologin")).booleanValue()) {
            connectionDetails = new LoginPanel(connectionDetails).askConnectionDetails();
        }
        return connectionDetails;
    }

    public void displayNewConnUI() {
        Server server;
        Server[] serverArray = Jin.getInstance().getServers();
        if (serverArray.length == 1) {
            server = serverArray[0];
        } else {
            server = new ServerChoicePanel().askServer();
            if (server == null) {
                return;
            }
        }
        ConnectionDetails connectionDetails = new LoginPanel(server).askConnectionDetails();
        if (connectionDetails == null) {
            Jin.getInstance().quitIfNoUiVisible();
            return;
        }
        this.login(connectionDetails);
    }

    public void displayNewConnUI(User user) {
        ConnectionDetails connectionDetails = new LoginPanel(user.getPreferredConnDetails()).askConnectionDetails();
        if (connectionDetails == null) {
            Jin.getInstance().quitIfNoUiVisible();
            return;
        }
        this.login(connectionDetails);
    }

    private void login(ConnectionDetails connectionDetails) {
        try {
            this.session = new Session(connectionDetails);
            this.fireSessionEvent(new SessionEvent(this, 1, this.session));
            this.session.initiateLogin();
        }
        catch (PluginStartException pluginStartException) {
            pluginStartException.printStackTrace();
            Exception exception = pluginStartException.getReason();
            String string = pluginStartException.getMessage() + "\n" + (exception == null ? "" : exception.getClass().getName() + ": " + exception.getMessage());
            OptionPanel.error("Error", string);
        }
    }

    void loginFailed(String string) {
        I18n i18n = I18n.get(this.getClass());
        i18n.error("loginErrorDialog", new Object[]{string});
        User user = this.session.getUser();
        this.closeSession();
        this.displayNewConnUI(user);
    }

    public void closeSession() {
        Object object;
        if (this.session == null) {
            return;
        }
        this.session.close();
        User user = this.session.getUser();
        int n = this.session.getPort();
        if (n != -1) {
            object = this.session.getConnDetails().usePort(n);
            user.setPreferredConnDetails((ConnectionDetails)object);
            if (!user.isGuest() && !Jin.getInstance().isKnownUser(user)) {
                boolean bl;
                I18n i18n = I18n.get(this.getClass());
                boolean bl2 = bl = !Jin.getInstance().isSavePrefsCapable() || OptionPanel.YES == i18n.question(OptionPanel.YES, "rememberAccountDialog", new Object[]{user.getUsername()});
                if (bl) {
                    Jin.getInstance().addUser(user);
                    this.saveLastUser(user);
                }
            } else {
                user.markDirty();
                this.saveLastUser(user);
            }
        }
        object = this.session;
        this.session = null;
        this.fireSessionEvent(new SessionEvent(this, 0, (Session)object));
    }

    public Session getSession() {
        return this.session;
    }

    public void addSessionListener(SessionListener sessionListener) {
        this.listenerList.add(SessionListener.class, sessionListener);
    }

    public void removeSessionListener(SessionListener sessionListener) {
        this.listenerList.remove(SessionListener.class, sessionListener);
    }

    private void fireSessionEvent(SessionEvent sessionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        block4: for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != (class$free$jin$SessionListener == null ? ConnectionManager.class$("free.jin.SessionListener") : class$free$jin$SessionListener)) continue;
            SessionListener sessionListener = (SessionListener)objectArray[i + 1];
            switch (sessionEvent.getId()) {
                case 1: {
                    sessionListener.sessionEstablished(sessionEvent);
                    continue block4;
                }
                case 0: {
                    sessionListener.sessionClosed(sessionEvent);
                }
            }
        }
    }

    private User getLastUser() {
        Preferences preferences = Jin.getInstance().getPrefs();
        String string = preferences.getString("last-login.serverId", null);
        String string2 = preferences.getString("last-login.username", null);
        if (string == null) {
            return null;
        }
        Server server = Jin.getInstance().getServerById(string);
        if (string2 == null) {
            return server.getGuest();
        }
        return Jin.getInstance().getUser(server, string2);
    }

    private void saveLastUser(User user) {
        Preferences preferences = Jin.getInstance().getPrefs();
        String string = user.getServer().getId();
        String string2 = preferences.getString("last-login.serverId", null);
        preferences.setString("last-login.serverId", string);
        if (!Utilities.areEqual(string, string2)) {
            preferences.setString("last-login.username", user.isGuest() || !Jin.getInstance().isKnownUser(user) ? null : user.getUsername());
        } else if (!user.isGuest()) {
            preferences.setString("last-login.username", user.getUsername());
        }
    }
}

