/*
 * Decompiled with CFR 0.152.
 */
package free.jin;

import free.chess.Player;
import free.chess.Position;
import free.chess.WildVariant;
import free.util.BeanProperties;
import java.beans.PropertyChangeListener;

public class Game {
    public static final int MY_GAME = 1;
    public static final int OBSERVED_GAME = 2;
    public static final int ISOLATED_BOARD = 3;
    public static final int WHITE_WINS = 1;
    public static final int BLACK_WINS = 2;
    public static final int DRAW = 3;
    public static final int UNKNOWN_RESULT = 4;
    public static final int GAME_IN_PROGRESS = 5;
    private final BeanProperties props = new BeanProperties(this);

    public Game(int n, Position position, int n2, String string, String string2, int n3, int n4, int n5, int n6, int n7, int n8, Object object, String string3, boolean bl, boolean bl2, String string4, String string5, boolean bl3, Player player) {
        this.setGameType(n);
        this.setInitialPosition(position);
        this.setPliesSinceStart(n2);
        this.setWhiteName(string);
        this.setBlackName(string2);
        this.setWhiteTime(n3);
        this.setWhiteInc(n4);
        this.setBlackTime(n5);
        this.setBlackInc(n6);
        this.setWhiteRating(n7);
        this.setBlackRating(n8);
        this.setRated(bl);
        this.setId(object);
        this.setRatingCategoryString(string3);
        this.setPlayed(bl2);
        this.setWhiteTitles(string4);
        this.setBlackTitles(string5);
        this.setBoardInitiallyFlipped(bl3);
        this.setUserPlayer(player);
    }

    public Game(int n, Position position, int n2, String string, String string2, int n3, int n4, int n5, int n6, Object object, String string3, boolean bl, boolean bl2, String string4, String string5, boolean bl3, Player player) {
        this(n, position, n2, string, string2, n3, n4, n3, n4, n5, n6, object, string3, bl, bl2, string4, string5, bl3, player);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.props.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.props.removePropertyChangeListener(propertyChangeListener);
    }

    public void setGameType(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown game type: " + n);
            }
        }
        this.props.setIntegerProperty("gameType", n);
    }

    public int getGameType() {
        return this.props.getIntegerProperty("gameType");
    }

    public void setInitialPosition(Position position) {
        Position position2 = new Position(position.getVariant());
        position2.copyFrom(position);
        this.props.setProperty("initialPosition", position);
    }

    public Position getInitialPosition() {
        Position position = (Position)this.props.getProperty("initialPosition");
        return new Position(position);
    }

    public void setPliesSinceStart(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("plies may not be negative");
        }
        this.props.setIntegerProperty("pliesSinceStart", n);
    }

    public int getPliesSinceStart() {
        return this.props.getIntegerProperty("pliesSinceStart");
    }

    public WildVariant getVariant() {
        return ((Position)this.props.getProperty("initialPosition")).getVariant();
    }

    public void setWhiteName(String string) {
        this.props.setStringProperty("whiteName", string);
    }

    public String getWhiteName() {
        return this.props.getStringProperty("whiteName");
    }

    public void setBlackName(String string) {
        this.props.setStringProperty("blackName", string);
    }

    public String getBlackName() {
        return this.props.getStringProperty("blackName");
    }

    public void setWhiteTime(int n) {
        this.props.setIntegerProperty("whiteTime", n);
    }

    public int getWhiteTime() {
        return this.props.getIntegerProperty("whiteTime");
    }

    public void setWhiteInc(int n) {
        this.props.setIntegerProperty("whiteInc", n);
    }

    public int getWhiteInc() {
        return this.props.getIntegerProperty("whiteInc");
    }

    public void setBlackTime(int n) {
        this.props.setIntegerProperty("blackTime", n);
    }

    public int getBlackTime() {
        return this.props.getIntegerProperty("blackTime");
    }

    public void setBlackInc(int n) {
        this.props.setIntegerProperty("blackInc", n);
    }

    public int getBlackInc() {
        return this.props.getIntegerProperty("blackInc");
    }

    public void setWhiteRating(int n) {
        this.props.setIntegerProperty("whiteRating", n);
    }

    public int getWhiteRating() {
        return this.props.getIntegerProperty("whiteRating");
    }

    public void setBlackRating(int n) {
        this.props.setIntegerProperty("blackRating", n);
    }

    public int getBlackRating() {
        return this.props.getIntegerProperty("blackRating");
    }

    public void setRated(boolean bl) {
        this.props.setBooleanProperty("rated", bl);
    }

    public boolean isRated() {
        return this.props.getBooleanProperty("rated");
    }

    public void setId(Object object) {
        this.props.setProperty("id", object);
    }

    public Object getID() {
        return this.props.getProperty("id");
    }

    public void setRatingCategoryString(String string) {
        this.props.setStringProperty("ratingCategoryString", string);
    }

    public String getRatingCategoryString() {
        return this.props.getStringProperty("ratingCategoryString");
    }

    public void setPlayed(boolean bl) {
        this.props.setBooleanProperty("played", bl);
    }

    public boolean isPlayed() {
        return this.props.getBooleanProperty("played");
    }

    public void setWhiteTitles(String string) {
        this.props.setStringProperty("whiteTitles", string);
    }

    public String getWhiteTitles() {
        return this.props.getStringProperty("whiteTitles");
    }

    public void setBlackTitles(String string) {
        this.props.setStringProperty("blackTitles", string);
    }

    public String getBlackTitles() {
        return this.props.getStringProperty("blackTitles");
    }

    private void setBoardInitiallyFlipped(boolean bl) {
        this.props.setBooleanProperty("boardInitiallyFlipped", bl);
    }

    public boolean isBoardInitiallyFlipped() {
        return this.props.getBooleanProperty("boardInitiallyFlipped");
    }

    public boolean isTimeOdds() {
        return this.getWhiteTime() != this.getBlackTime() || this.getWhiteInc() != this.getBlackInc();
    }

    private void setUserPlayer(Player player) {
        this.props.setProperty("userPlayer", player);
    }

    public Player getUserPlayer() {
        if (this.getGameType() == 1 && this.isPlayed()) {
            return (Player)this.props.getProperty("userPlayer");
        }
        return null;
    }

    public Player getPlayerNamed(String string) {
        if (this.getWhiteName().equals(string)) {
            return Player.WHITE_PLAYER;
        }
        if (this.getBlackName().equals(string)) {
            return Player.BLACK_PLAYER;
        }
        return null;
    }

    public boolean isUserAllowedToMovePieces(Player player) {
        int n = this.getGameType();
        if (n == 2) {
            return false;
        }
        if (n == 3) {
            return false;
        }
        return player.equals(this.getUserPlayer());
    }

    public int getResult() {
        Integer n = (Integer)this.props.getProperty("result", null);
        if (n == null) {
            return 5;
        }
        return n;
    }

    public void setResult(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad value for game result specified: " + n);
            }
        }
        if (this.getResult() != 5) {
            throw new IllegalStateException("Unable to set the result more than once");
        }
        this.props.setProperty("result", new Integer(n));
    }

    public String getTCString() {
        String string = "" + this.getWhiteTime() / 60000 + " " + this.getWhiteInc() / 1000;
        if (this.isTimeOdds()) {
            return "(" + string + ") (" + this.getBlackTime() / 60000 + " " + this.getBlackInc() / 1000 + ")";
        }
        return string;
    }

    public String toString() {
        return "#" + this.getID() + " " + (this.isRated() ? "Rated" : "Unrated") + " " + this.getTCString() + " " + this.getVariant().getName() + " " + this.getWhiteName() + " vs. " + this.getBlackName();
    }
}

