/*
 * Decompiled with CFR 0.152.
 */
package free.jin;

import free.jin.Jin;
import free.jin.JinContext;
import free.jin.Preferences;
import free.jin.Resource;
import free.jin.Server;
import free.jin.User;
import free.jin.UsernamePolicy;
import free.jin.action.ActionInfo;
import free.jin.plugin.Plugin;
import free.jin.plugin.PluginInfo;
import free.util.ChildClassLoader;
import free.util.DelegatingClassLoader;
import free.util.ExtensionFilenameFilter;
import free.util.IOUtilities;
import free.util.Localization;
import free.util.MemoryFile;
import free.util.MultiOutputStream;
import free.util.PlatformUtils;
import free.util.Utilities;
import free.util.zip.ZipClassLoader;
import free.util.zip.ZipURLStreamHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;

public class JinApplication
implements JinContext {
    private static final File JIN_DIR;
    private static final boolean dynamicLoad;
    private final Locale locale;
    private Localization l10n = null;
    private final Properties params;
    private final File prefsDir;
    private final Preferences userPrefs;
    private final DelegatingClassLoader mainLoader;
    private final ChildClassLoader libsLoader;
    private final Server[] servers;
    private User[] users;
    private final User[] originalUsers;
    private final Hashtable serversToActions;
    private final Hashtable serversToPlugins;

    private JinApplication(Properties properties, File file) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.params = properties;
        this.prefsDir = file;
        this.userPrefs = this.loadUserPrefs();
        if (dynamicLoad) {
            this.libsLoader = this.createLibsClassLoader();
            this.mainLoader = new DelegatingClassLoader(this.libsLoader);
        } else {
            this.libsLoader = null;
            this.mainLoader = null;
        }
        this.locale = this.determineLocale();
        this.configureLibraries();
        this.l10n = Localization.load(JinApplication.class, this.locale);
        this.servers = this.loadServers();
        this.users = this.loadUsers();
        this.originalUsers = this.users;
        this.serversToActions = this.loadActions();
        this.serversToPlugins = this.loadPlugins();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getParameter(String string) {
        return this.params.getProperty(string);
    }

    private Preferences loadUserPrefs() throws IOException {
        File file = new File(this.prefsDir, "user.prefs");
        if (!file.exists()) {
            return Preferences.createNew();
        }
        return Preferences.load(file);
    }

    public Preferences getPrefs() {
        return this.userPrefs;
    }

    private void storeUserPrefs() {
        File file = new File(this.prefsDir, "user.prefs");
        try {
            this.userPrefs.save(file);
        }
        catch (SecurityException securityException) {
            this.showPrefsSaveError("securityManagerWriteError", file);
        }
        catch (IOException iOException) {
            this.showPrefsSaveError("ioError", file);
        }
    }

    private void showPrefsSaveError(String string, File file) {
        this.showErrorMessage(this.l10n.getString("savingPrefsErrorDialog.title"), MessageFormat.format(this.l10n.getString("savingPrefsErrorDialog." + string), file.toString()));
    }

    private static void checkDirectoryExists(File file) throws FileNotFoundException {
        if (!file.exists() || !file.isDirectory()) {
            throw new FileNotFoundException("Can't find directory:\n" + file + "\n" + "The most likely reason is that you are not running Jin from its directory.");
        }
    }

    private DelegatingClassLoader createLibsClassLoader() throws IOException {
        DelegatingClassLoader delegatingClassLoader = new DelegatingClassLoader();
        File file = new File(JIN_DIR, "libs");
        JinApplication.checkDirectoryExists(file);
        JinApplication.addDelegateZipClassLoaders(delegatingClassLoader, file);
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (!file2.isDirectory()) continue;
            JinApplication.addDelegateZipClassLoaders(delegatingClassLoader, file2);
        }
        return delegatingClassLoader;
    }

    private static void addDelegateZipClassLoaders(DelegatingClassLoader delegatingClassLoader, File file) throws IOException {
        String[] stringArray = file.list(new ExtensionFilenameFilter(".jar"));
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            delegatingClassLoader.addDelegate(new ZipClassLoader(file2, delegatingClassLoader));
        }
    }

    private Locale determineLocale() {
        String string;
        String string2;
        String string3 = this.getParameter("locale.language");
        if (string3 != null) {
            string2 = this.getParameter("locale.country");
            string = this.getParameter("locale.variant");
        } else {
            string3 = this.getPrefs().getString("locale.language", null);
            if (string3 != null) {
                string2 = this.getPrefs().getString("locale.country", "");
                string = this.getPrefs().getString("locale.variant", "");
            } else {
                string3 = "";
                string2 = "";
                string = "";
            }
        }
        return new Locale(string3, string2 == null ? "" : string2, string == null ? "" : string);
    }

    private void configureLibraries() {
        Localization.setAppLocale(this.locale);
    }

    private Server[] loadServers() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        File file = new File(JIN_DIR, "servers");
        JinApplication.checkDirectoryExists(file);
        String[] stringArray = file.list(new ExtensionFilenameFilter(".jar"));
        if (stringArray.length == 0) {
            throw new IllegalStateException("No server specifications found in:\n" + file);
        }
        Server[] serverArray = new Server[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            serverArray[i] = this.loadServer(new File(file, stringArray[i]));
        }
        return serverArray;
    }

    private Server loadServer(File file) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz;
        if (!file.isFile()) {
            throw new FileNotFoundException(file + " does not exist or is a directory");
        }
        ZipClassLoader zipClassLoader = new ZipClassLoader(file, this.libsLoader);
        InputStream inputStream = zipClassLoader.getResourceAsStream("definition");
        if (inputStream == null) {
            throw new FileNotFoundException("Unable to find server definition file in " + file);
        }
        Properties properties = IOUtilities.loadPropertiesAndClose(inputStream);
        String string = properties.getProperty("classname");
        if (string == null) {
            throw new IOException("Server definition file in " + file + " does not contain a classname property");
        }
        if (dynamicLoad) {
            clazz = zipClassLoader.loadClass(string);
            this.mainLoader.addDelegate(zipClassLoader);
        } else {
            clazz = Class.forName(string);
        }
        Server server = (Server)clazz.newInstance();
        File file2 = new File(new File(new File(this.prefsDir, "accounts"), server.getId()), server.getUsernamePolicy().getGuestUsername());
        server.setGuestUser(this.loadUser(file2, server));
        return server;
    }

    public Server[] getServers() {
        return this.servers;
    }

    private User[] loadUsers() throws IOException {
        File file = new File(this.prefsDir, "accounts");
        Vector<User> vector = new Vector<User>();
        if (file.exists()) {
            for (int i = 0; i < this.servers.length; ++i) {
                Server server = this.servers[i];
                File file2 = new File(file, server.getId());
                if (!file2.exists()) continue;
                UsernamePolicy usernamePolicy = server.getUsernamePolicy();
                String[] stringArray = file2.list();
                for (int j = 0; j < stringArray.length; ++j) {
                    File file3 = new File(file2, stringArray[j]);
                    User user = this.loadUser(file3, null);
                    if (user == null || usernamePolicy.isSame(usernamePolicy.getGuestUsername(), user.getUsername())) continue;
                    vector.addElement(user);
                }
            }
        }
        Object[] objectArray = new User[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private User loadUser(File file, Server server) throws IOException {
        if (!file.isDirectory()) {
            return null;
        }
        File file2 = new File(file, "properties");
        File file3 = new File(file, "preferences");
        File file4 = new File(file, "files");
        if (!file2.isFile() || !file3.isFile()) {
            return null;
        }
        Properties properties = IOUtilities.loadProperties(file2);
        Preferences preferences = Preferences.load(file3);
        Hashtable hashtable = this.loadUserFiles(file4);
        String string = properties.getProperty("serverId");
        String string2 = properties.getProperty("username");
        if (string == null || string2 == null) {
            return null;
        }
        if (server == null) {
            server = this.getServerById(string);
        }
        return new User(server, string2, preferences, hashtable);
    }

    private Hashtable loadUserFiles(File file) throws IOException {
        Hashtable<String, MemoryFile> hashtable = new Hashtable<String, MemoryFile>();
        if (!file.isFile()) {
            return hashtable;
        }
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            int n2 = dataInputStream.readInt();
            byte[] byArray = IOUtilities.read(dataInputStream, n2);
            hashtable.put(string, new MemoryFile(byArray));
        }
        dataInputStream.close();
        return hashtable;
    }

    public User[] getUsers() {
        return this.users;
    }

    public void setUsers(User[] userArray) {
        this.users = userArray;
    }

    private void storeUsers() {
        Object object;
        int n;
        for (n = 0; n < this.users.length; ++n) {
            object = this.users[n];
            if (!((User)object).isDirty() && Utilities.indexOf(this.originalUsers, object) != -1) continue;
            this.storeUser((User)object);
        }
        for (n = 0; n < this.servers.length; ++n) {
            object = this.servers[n];
            User user = object.getGuest();
            if (!user.isDirty()) continue;
            this.storeUser(user);
        }
    }

    private boolean storeUser(User user) {
        Object object;
        Object object2;
        String string = user.getUsername();
        File file = this.usersDir(user);
        try {
            if (!file.isDirectory() && !file.mkdirs()) {
                this.showAccountSaveError("unableToCreateDirError", file);
                return false;
            }
        }
        catch (SecurityException securityException) {
            this.showAccountSaveError("securityManagerDirCreateError", file);
            return false;
        }
        Properties properties = new Properties();
        properties.put("serverId", user.getServer().getId());
        properties.put("username", string);
        File file2 = new File(file, "properties");
        try {
            object2 = new FileOutputStream(file2);
            properties.store((OutputStream)object2, "");
            ((OutputStream)object2).close();
        }
        catch (IOException iOException) {
            this.showAccountSaveError("ioErrorStoringProps", file2);
            return false;
        }
        catch (SecurityException securityException) {
            this.showAccountSaveError("securityManagerErrorStoringProps", file2);
            return false;
        }
        object2 = new File(file, "preferences");
        try {
            object = new FileOutputStream((File)object2);
            user.getPrefs().save((OutputStream)object);
            ((OutputStream)object).close();
        }
        catch (IOException iOException) {
            this.showAccountSaveError("ioErrorStoringPrefs", (File)object2);
            return false;
        }
        catch (SecurityException securityException) {
            this.showAccountSaveError("securityManagerErrorStoringProps", (File)object2);
            return false;
        }
        object = new File(file, "files");
        try {
            this.storeUserFiles(user.getFilesMap(), (File)object);
        }
        catch (IOException iOException) {
            this.showAccountSaveError("ioErrorStoringUserFiles", (File)object);
            return false;
        }
        catch (SecurityException securityException) {
            this.showAccountSaveError("securityManagerErrorStoringUserFiles", (File)object);
            return false;
        }
        return true;
    }

    private void showAccountSaveError(String string, File file) {
        this.showErrorMessage(this.l10n.getString("savingAccountErrorDialog.title"), MessageFormat.format(this.l10n.getString("savingAccountErrorDialog." + string), file.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeUserFiles(Hashtable hashtable, File file) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        dataOutputStream.writeInt(hashtable.size());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            MemoryFile memoryFile = (MemoryFile)hashtable.get(string);
            dataOutputStream.writeUTF(string);
            MemoryFile memoryFile2 = memoryFile;
            synchronized (memoryFile2) {
                dataOutputStream.writeInt(memoryFile.getSize());
                memoryFile.writeTo(dataOutputStream);
            }
        }
        dataOutputStream.close();
    }

    private Hashtable loadActions() throws IOException, ClassNotFoundException {
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < this.servers.length; ++i) {
            hashtable.put(this.servers[i], new Vector());
        }
        this.loadActions(hashtable, new File(JIN_DIR, "actions"));
        this.loadActions(hashtable, new File(this.prefsDir, "actions"));
        Hashtable<Server, Object[]> hashtable2 = new Hashtable<Server, Object[]>();
        for (int i = 0; i < this.servers.length; ++i) {
            Server server = this.servers[i];
            Vector vector = (Vector)hashtable.get(server);
            Object[] objectArray = new ActionInfo[vector.size()];
            vector.copyInto(objectArray);
            hashtable2.put(server, objectArray);
        }
        return hashtable2;
    }

    private void loadActions(Hashtable hashtable, File file) throws IOException, ClassNotFoundException {
        Object object;
        int n;
        if (!file.isDirectory()) {
            return;
        }
        ExtensionFilenameFilter extensionFilenameFilter = new ExtensionFilenameFilter(".jar");
        String[] stringArray = file.list(extensionFilenameFilter);
        for (n = 0; n < stringArray.length; ++n) {
            object = this.loadActionInfo(new File(file, stringArray[n]));
            if (object == null) continue;
            for (int i = 0; i < this.servers.length; ++i) {
                ((Vector)hashtable.get(this.servers[i])).addElement(object);
            }
        }
        for (n = 0; n < this.servers.length; ++n) {
            object = this.servers[n];
            File file2 = new File(file, object.getId());
            if (!file2.isDirectory()) continue;
            stringArray = file2.list(extensionFilenameFilter);
            for (int i = 0; i < stringArray.length; ++i) {
                ActionInfo actionInfo = this.loadActionInfo(new File(file2, stringArray[i]));
                if (actionInfo == null) continue;
                ((Vector)hashtable.get(object)).addElement(actionInfo);
            }
        }
    }

    private ActionInfo loadActionInfo(File file) throws IOException, ClassNotFoundException {
        Preferences preferences;
        if (!file.isFile()) {
            return null;
        }
        ZipClassLoader zipClassLoader = new ZipClassLoader(file, this.mainLoader);
        InputStream inputStream = zipClassLoader.getResourceAsStream("definition");
        if (inputStream == null) {
            System.err.println(file + " does not contain an action definition file");
            return null;
        }
        Properties properties = IOUtilities.loadPropertiesAndClose(inputStream);
        String string = properties.getProperty("classname");
        if (string == null) {
            System.out.println("The action definition file in " + file + " does not contain a classname property");
            return null;
        }
        Class<?> clazz = dynamicLoad ? zipClassLoader.loadClass(string) : Class.forName(string);
        InputStream inputStream2 = clazz.getResourceAsStream("preferences");
        Preferences preferences2 = preferences = inputStream2 == null ? Preferences.createNew() : Preferences.load(inputStream2);
        if (inputStream2 != null) {
            inputStream2.close();
        }
        return new ActionInfo(clazz, preferences);
    }

    public ActionInfo[] getActions(Server server) {
        return (ActionInfo[])this.serversToActions.get(server);
    }

    private Hashtable loadPlugins() throws IOException, ClassNotFoundException {
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < this.servers.length; ++i) {
            hashtable.put(this.servers[i], new Vector());
        }
        this.loadPlugins(hashtable, new File(JIN_DIR, "plugins"));
        this.loadPlugins(hashtable, new File(this.prefsDir, "plugins"));
        Hashtable<Server, Object[]> hashtable2 = new Hashtable<Server, Object[]>();
        for (int i = 0; i < this.servers.length; ++i) {
            Server server = this.servers[i];
            Vector vector = (Vector)hashtable.get(server);
            Object[] objectArray = new PluginInfo[vector.size()];
            vector.copyInto(objectArray);
            hashtable2.put(server, objectArray);
        }
        return hashtable2;
    }

    private void loadPlugins(Hashtable hashtable, File file) throws IOException, ClassNotFoundException {
        Object object;
        int n;
        if (!file.isDirectory()) {
            return;
        }
        ExtensionFilenameFilter extensionFilenameFilter = new ExtensionFilenameFilter(".jar");
        String[] stringArray = file.list(extensionFilenameFilter);
        for (n = 0; n < stringArray.length; ++n) {
            object = this.loadPluginInfo(new File(file, stringArray[n]));
            if (object == null) continue;
            for (int i = 0; i < this.servers.length; ++i) {
                ((Vector)hashtable.get(this.servers[i])).addElement(object);
            }
        }
        for (n = 0; n < this.servers.length; ++n) {
            object = this.servers[n];
            File file2 = new File(file, object.getId());
            if (!file2.isDirectory()) continue;
            stringArray = file2.list(extensionFilenameFilter);
            for (int i = 0; i < stringArray.length; ++i) {
                PluginInfo pluginInfo = this.loadPluginInfo(new File(file2, stringArray[i]));
                if (pluginInfo == null) continue;
                ((Vector)hashtable.get(object)).addElement(pluginInfo);
            }
        }
    }

    private PluginInfo loadPluginInfo(File file) throws IOException, ClassNotFoundException {
        Preferences preferences;
        if (!file.isFile()) {
            return null;
        }
        ZipClassLoader zipClassLoader = new ZipClassLoader(file, this.mainLoader);
        InputStream inputStream = zipClassLoader.getResourceAsStream("definition");
        if (inputStream == null) {
            System.err.println(file + " does not contain a plugin definition file");
            return null;
        }
        Properties properties = IOUtilities.loadPropertiesAndClose(inputStream);
        String string = properties.getProperty("classname");
        if (string == null) {
            System.out.println("The plugin definition file in " + file + " does not contain a classname property");
            return null;
        }
        Class<?> clazz = dynamicLoad ? zipClassLoader.loadClass(string) : Class.forName(string);
        InputStream inputStream2 = clazz.getResourceAsStream("preferences");
        Preferences preferences2 = preferences = inputStream2 == null ? Preferences.createNew() : Preferences.load(inputStream2);
        if (inputStream2 != null) {
            inputStream2.close();
        }
        return new PluginInfo(clazz, preferences);
    }

    public PluginInfo[] getPlugins(Server server) {
        return (PluginInfo[])this.serversToPlugins.get(server);
    }

    private File usersDir(User user) {
        File file = new File(this.prefsDir, "accounts");
        File file2 = new File(file, user.getServer().getId());
        return new File(file2, user.getUsername());
    }

    public Map getResources(String string, Plugin plugin) {
        HashMap hashMap = new HashMap();
        String string2 = plugin.getServer().getId();
        File file = new File(new File(this.prefsDir, "resources"), string);
        File file2 = new File(new File(JIN_DIR, "resources"), string);
        File file3 = new File(new File(new File(JIN_DIR, "resources"), string), string2);
        this.loadResources(file2, hashMap, plugin);
        this.loadResources(file3, hashMap, plugin);
        this.loadResources(file, hashMap, plugin);
        return hashMap;
    }

    private void loadResources(File file, Map map, Plugin plugin) {
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        String[] stringArray = file.list(new ExtensionFilenameFilter(".zip"));
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            File file2 = new File(file, string);
            try {
                Resource resource = this.loadResource(file2, plugin);
                if (resource == null) continue;
                map.put(resource.getId(), resource);
                continue;
            }
            catch (IOException iOException) {
                System.out.println("Failed to load resource from " + file2);
                iOException.printStackTrace();
            }
        }
    }

    public Resource getResource(String string, String string2, Plugin plugin) {
        String string3 = plugin.getServer().getId();
        File file = new File(new File(this.prefsDir, "resources"), string);
        File file2 = new File(new File(JIN_DIR, "resources"), string);
        File file3 = new File(new File(new File(JIN_DIR, "resources"), string), string3);
        File[] fileArray = new File[]{new File(file, string2 + ".zip"), new File(file3, string2 + ".zip"), new File(file2, string2 + ".zip")};
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                File file4 = fileArray[i];
                if (!file4.exists()) continue;
                return this.loadResource(file4, plugin);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    private Resource loadResource(File file, Plugin plugin) throws IOException {
        ZipClassLoader zipClassLoader = new ZipClassLoader(file);
        Properties properties = IOUtilities.loadPropertiesAndClose(zipClassLoader.getResourceAsStream("definition"));
        if (properties == null) {
            return null;
        }
        String string = properties.getProperty("classname");
        if (string == null) {
            return null;
        }
        if ("ImagePieceSetLoader".equals(string)) {
            string = "free.jin.board.PieceSet";
        } else if ("ImageBoardLoader".equals(string)) {
            string = "free.jin.board.BoardPattern";
        }
        try {
            Class<?> clazz = plugin.getClass().getClassLoader().loadClass(string);
            Resource resource = (Resource)clazz.newInstance();
            if (resource.load(zipClassLoader.getResource("/"), plugin)) {
                return resource;
            }
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
    }

    public boolean isSavePrefsCapable() {
        return true;
    }

    public String getPasswordSaveWarning() {
        return this.l10n.getString("passwordSaveWarning");
    }

    public boolean isUserExtensible() {
        return true;
    }

    public void shutdown() {
        this.storeUserPrefs();
        this.storeUsers();
        System.exit(0);
    }

    private void showErrorMessage(String string, String string2) {
        JOptionPane.showMessageDialog(null, string2, string, 0);
    }

    private Server getServerById(String string) {
        for (int i = 0; i < this.servers.length; ++i) {
            if (!this.servers[i].getId().equals(string)) continue;
            return this.servers[i];
        }
        return null;
    }

    public static void main(String[] stringArray) {
        try {
            Properties properties = JinApplication.parseCommandlineArgs(stringArray);
            JinApplication.osxMenubarFix();
            File file = new File(System.getProperty("user.home"), ".jin");
            JinApplication.createPreferencesDir(file);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(new File(file, "log"));
                PrintStream printStream = new PrintStream(new MultiOutputStream(System.out, fileOutputStream));
                System.setOut(printStream);
                System.setErr(printStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            Jin.createInstance(new JinApplication(properties, file));
            JinApplication.doPlatformSpecificStuff();
            Jin.getInstance().start();
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            throwable.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error type: " + throwable.getClass().getName() + "\n" + "Error message: " + throwable.getMessage(), "Jin launch error", 0);
            System.exit(1);
        }
    }

    private static Properties parseCommandlineArgs(String[] stringArray) {
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = string.indexOf("=");
            if (n == -1) {
                properties.put(string, "true");
                continue;
            }
            properties.put(string.substring(0, n), string.substring(n + 1));
        }
        return properties;
    }

    private static void createPreferencesDir(File file) throws IOException {
        if (new File(file, "user.properties").exists()) {
            IOUtilities.rmdir(file);
        }
        if (!file.exists()) {
            if (!file.mkdirs()) {
                throw new IOException("Unable to create preferences directory: " + file);
            }
        } else if (!file.isDirectory()) {
            throw new IOException(file.toString() + " exists but is not a directory");
        }
    }

    private static void osxMenubarFix() {
        String string = System.getProperty("java.version");
        System.getProperties().put("apple.laf.useScreenMenuBar", string.compareTo("1.4.2") >= 0 ? "true" : "false");
    }

    private static void doPlatformSpecificStuff() {
        if (PlatformUtils.isMacOSX()) {
            try {
                Class.forName("free.jin.MacOSXSpecific");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    static {
        URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){

            public URLStreamHandler createURLStreamHandler(String string) {
                if (string.equals("zip")) {
                    return new ZipURLStreamHandler();
                }
                return null;
            }
        });
        JIN_DIR = new File(System.getProperty("user.dir"));
        dynamicLoad = !"true".equals(System.getProperty("jin.noDynamicLoad"));
    }
}

