/*
 * Decompiled with CFR 0.152.
 */
package free.jin;

import free.jin.ConnectionDetails;
import free.jin.Preferences;
import free.jin.Server;
import free.util.MemoryFile;
import java.util.Hashtable;

public class User {
    private final Server server;
    private String username;
    private final Preferences prefs;
    private final Hashtable files;
    private boolean isDirty;

    public User(Server server, String string, Preferences preferences, Hashtable hashtable) {
        this.server = server;
        this.username = string;
        this.prefs = preferences;
        this.files = hashtable;
    }

    public User(Server server, String string) {
        this(server, string, Preferences.createNew(), new Hashtable());
    }

    public Server getServer() {
        return this.server;
    }

    public String getUsername() {
        return this.username;
    }

    public Preferences getPrefs() {
        return this.prefs;
    }

    Hashtable getFilesMap() {
        return this.files;
    }

    public MemoryFile getFile(String string) {
        return (MemoryFile)this.files.get(string);
    }

    public void setFile(String string, MemoryFile memoryFile) {
        if (memoryFile == null) {
            this.files.remove(string);
        } else {
            this.files.put(string, memoryFile);
        }
    }

    public boolean isGuest() {
        return this == this.server.getGuest();
    }

    public ConnectionDetails getPreferredConnDetails() {
        String string = this.prefs.getString("login.password", "");
        boolean bl = this.prefs.getBool("login.savePassword", false);
        String string2 = this.prefs.getString("login.hostname", this.server.getDefaultHost());
        int[] nArray = this.prefs.getIntList("login.ports", this.server.getPorts());
        if (this.isGuest()) {
            return ConnectionDetails.createGuest(this.getServer(), this.username, string2, nArray);
        }
        return ConnectionDetails.create(this.getServer(), this, this.username, string, bl, string2, nArray);
    }

    void setPreferredConnDetails(ConnectionDetails connectionDetails) {
        if (connectionDetails.isGuest() != this.isGuest()) {
            throw new IllegalArgumentException("isGuest property mismatch");
        }
        if (connectionDetails.getServer() != this.getServer()) {
            throw new IllegalArgumentException("server property mismatch");
        }
        if (connectionDetails.getUser() != this) {
            throw new IllegalArgumentException("user property mismatch");
        }
        this.prefs.setString("login.hostname", connectionDetails.getHost());
        this.prefs.setIntList("login.ports", connectionDetails.getPorts());
        if (!connectionDetails.isGuest()) {
            boolean bl = connectionDetails.isSavePassword();
            this.prefs.setBool("login.savePassword", bl);
            this.prefs.setString("login.password", bl ? connectionDetails.getPassword() : "");
        }
    }

    public void markDirty() {
        this.isDirty = true;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public String toString() {
        return this.getUsername() + "@" + this.getServer().getShortName();
    }
}

