/*
 * Decompiled with CFR 0.152.
 */
package free.jin.plugin;

import free.jin.Connection;
import free.jin.Preferences;
import free.jin.User;
import free.jin.action.JinAction;
import free.jin.plugin.Plugin;
import free.jin.plugin.PluginStartException;
import free.util.Utilities;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;

public class PluginContext {
    private final Connection conn;
    private final User user;
    private final Plugin[] plugins;
    private final boolean[] isPluginActive;
    private int activePluginsCount;
    private final Preferences[] prefs;
    private final DefaultListModel actions = new DefaultListModel();

    public PluginContext(Connection connection, User user, Plugin[] pluginArray, Preferences[] preferencesArray, JinAction[] jinActionArray) {
        this.conn = connection;
        this.user = user;
        this.plugins = (Plugin[])pluginArray.clone();
        this.isPluginActive = new boolean[pluginArray.length];
        this.prefs = (Preferences[])preferencesArray.clone();
        for (int i = 0; i < jinActionArray.length; ++i) {
            this.actions.addElement(jinActionArray[i]);
        }
    }

    public void setAndStart() throws PluginStartException {
        int n;
        this.activePluginsCount = 0;
        for (n = 0; n < this.plugins.length; ++n) {
            boolean bl;
            this.isPluginActive[n] = bl = this.plugins[n].setContext(this);
            if (!bl) continue;
            ++this.activePluginsCount;
        }
        for (n = 0; n < this.plugins.length; ++n) {
            if (!this.isPluginActive[n]) continue;
            Plugin plugin = this.plugins[n];
            try {
                plugin.start();
                continue;
            }
            catch (Exception exception) {
                throw new PluginStartException(exception, "Failed to start plugin: " + plugin);
            }
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    public User getUser() {
        return this.user;
    }

    public Plugin getPlugin(String string) {
        for (int i = 0; i < this.plugins.length; ++i) {
            if (!this.isPluginActive[i] || !this.plugins[i].getId().equals(string)) continue;
            return this.plugins[i];
        }
        return null;
    }

    public Plugin[] getPlugins() {
        Plugin[] pluginArray = new Plugin[this.activePluginsCount];
        int n = 0;
        for (int i = 0; i < this.plugins.length; ++i) {
            if (!this.isPluginActive[i]) continue;
            pluginArray[n++] = this.plugins[i];
        }
        return pluginArray;
    }

    public synchronized Preferences getPreferences(Plugin plugin) {
        return this.prefs[Utilities.indexOf(this.plugins, plugin)];
    }

    public ListModel getActions() {
        return this.actions;
    }

    public JinAction getAction(String string) {
        int n = this.actions.size();
        for (int i = 0; i < n; ++i) {
            JinAction jinAction = (JinAction)this.actions.elementAt(i);
            if (!jinAction.getId().equals(string)) continue;
            return jinAction;
        }
        return null;
    }

    public void addAction(JinAction jinAction) {
        this.actions.addElement(jinAction);
    }
}

