/*
 * Decompiled with CFR 0.152.
 */
package free.jin.console;

import free.jin.Connection;
import free.jin.GameListConnection;
import free.jin.I18n;
import free.jin.console.Console;
import free.jin.console.GameListTable;
import free.jin.console.prefs.ConsolePrefsPanel;
import free.jin.event.ChatEvent;
import free.jin.event.ChatListener;
import free.jin.event.ConnectionListener;
import free.jin.event.GameListEvent;
import free.jin.event.GameListListener;
import free.jin.event.GameListListenerManager;
import free.jin.event.ListenerManager;
import free.jin.event.PlainTextEvent;
import free.jin.event.PlainTextListener;
import free.jin.plugin.Plugin;
import free.jin.plugin.PluginUIAdapter;
import free.jin.plugin.PluginUIContainer;
import free.jin.plugin.PluginUIEvent;
import free.jin.plugin.PluginUIListener;
import free.jin.ui.PreferencesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ConsoleManager
extends Plugin
implements PlainTextListener,
ChatListener,
ConnectionListener,
GameListListener {
    public static final int EMBEDDED_GAME_LISTS = 0;
    public static final int EXTERNAL_GAME_LISTS = 1;
    public static final int NO_GAME_LISTS = 2;
    protected Console console;
    protected PluginUIContainer consoleContainer;
    private int gameListsDisplayStyle;
    private boolean isPaused = false;
    private final Vector pausedEventsQueue = new Vector();

    public void start() {
        this.initState();
        this.openConsole();
        this.registerConnListeners();
    }

    public void stop() {
        this.unregisterConnListeners();
    }

    protected void initState() {
        String string = this.getPrefs().getString("game-list-display-style", "embedded");
        if ("embedded".equals(string)) {
            this.setGameListsDisplayStyle(0);
        } else if ("framed".equals(string)) {
            this.setGameListsDisplayStyle(1);
        } else if ("none".equals(string)) {
            this.setGameListsDisplayStyle(2);
        }
    }

    private void openConsole() {
        this.console = this.createConsole();
        this.consoleContainer = this.createContainer("", 0);
        this.consoleContainer.setTitle(this.getI18n().getString("mainConsole.initialTitle"));
        URL uRL = ConsoleManager.class.getResource("icon.gif");
        if (uRL != null) {
            this.consoleContainer.setIcon(Toolkit.getDefaultToolkit().getImage(uRL));
        }
        Container container = this.consoleContainer.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.console, "Center");
        this.consoleContainer.addPluginUIListener((PluginUIListener)new PluginUIAdapter(){

            public void pluginUIActivated(PluginUIEvent pluginUIEvent) {
                ConsoleManager.this.console.requestDefaultFocus();
            }
        });
        this.consoleContainer.setVisible(true);
    }

    protected Console createConsole() {
        return new Console(this);
    }

    public void setGameListsDisplayStyle(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad game lists display style value: " + n);
            }
        }
        if (this.getConn() instanceof GameListConnection) {
            GameListListenerManager gameListListenerManager = ((GameListConnection)this.getConn()).getGameListListenerManager();
            if (n == 2) {
                gameListListenerManager.removeGameListListener((GameListListener)this);
            } else if (this.gameListsDisplayStyle == 2) {
                gameListListenerManager.addGameListListener((GameListListener)this);
            }
        }
        this.gameListsDisplayStyle = n;
    }

    public int getGameListsDisplayStyle() {
        return this.gameListsDisplayStyle;
    }

    public void setCopyOnSelect(boolean bl) {
        this.getPrefs().setBool("copyOnSelect", bl);
    }

    public boolean isCopyOnSelect() {
        return this.getPrefs().getBool("copyOnSelect", true);
    }

    public String getEncoding() {
        return this.getPrefs().getString("encoding", "utf8");
    }

    public void setEncoding(String string) throws UnsupportedEncodingException {
        if (!this.supportsMultipleEncodings()) {
            throw new IllegalStateException("Multiple encodings are unsupported");
        }
        if (!Charset.isSupported(string)) {
            throw new UnsupportedEncodingException(string);
        }
        this.getPrefs().setString("encoding", string);
    }

    public boolean supportsMultipleEncodings() {
        return false;
    }

    public String encode(String string) {
        try {
            return new String(string.getBytes(this.getEncoding()), "ISO8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return string;
        }
    }

    public String decode(String string) {
        try {
            return new String(string.getBytes("ISO8859_1"), this.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return string;
        }
    }

    public void refreshFromProperties() {
        this.console.refreshFromProperties();
    }

    protected void registerConnListeners() {
        Connection connection = this.getConn();
        ListenerManager listenerManager = connection.getListenerManager();
        listenerManager.addPlainTextListener((PlainTextListener)this);
        listenerManager.addChatListener((ChatListener)this);
        listenerManager.addConnectionListener((ConnectionListener)this);
        if (connection instanceof GameListConnection && this.getGameListsDisplayStyle() != 2) {
            ((GameListConnection)connection).getGameListListenerManager().addGameListListener((GameListListener)this);
        }
    }

    protected void unregisterConnListeners() {
        Connection connection = this.getConn();
        ListenerManager listenerManager = connection.getListenerManager();
        listenerManager.removePlainTextListener((PlainTextListener)this);
        listenerManager.removeChatListener((ChatListener)this);
        listenerManager.removeConnectionListener((ConnectionListener)this);
        if (connection instanceof GameListConnection && this.getGameListsDisplayStyle() != 2) {
            ((GameListConnection)connection).getGameListListenerManager().removeGameListListener((GameListListener)this);
        }
    }

    public void addSpecialLine(String string) {
        this.console.addToOutput(string, "special");
    }

    public void plainTextReceived(PlainTextEvent plainTextEvent) {
        if (this.isPaused()) {
            this.pausedEventsQueue.addElement(plainTextEvent);
            return;
        }
        this.console.addToOutput(this.decode(plainTextEvent.getText()), "plain");
    }

    public void chatMessageReceived(ChatEvent chatEvent) {
        if (this.isPaused()) {
            this.pausedEventsQueue.addElement(chatEvent);
            return;
        }
        String string = chatEvent.getType();
        Object object = chatEvent.getForum();
        String string2 = chatEvent.getSender();
        String string3 = string + "." + (object == null ? "" : object.toString()) + "." + string2;
        this.console.addToOutput(this.translateChat(chatEvent), string3);
    }

    public void sendUserCommand(String string) {
        Connection connection = this.getConn();
        if (connection.isConnected()) {
            connection.sendCommand(this.encode(string));
        } else {
            this.console.addToOutput(I18n.get((Class)ConsoleManager.class).getString("unconnectedWarningMessage"), "info");
        }
    }

    public void setPaused(boolean bl) {
        this.isPaused = bl;
        if (!bl) {
            int n = this.pausedEventsQueue.size();
            for (int i = 0; i < n; ++i) {
                try {
                    Object e = this.pausedEventsQueue.elementAt(i);
                    if (e instanceof PlainTextEvent) {
                        this.plainTextReceived((PlainTextEvent)e);
                        continue;
                    }
                    if (!(e instanceof ChatEvent)) continue;
                    this.chatMessageReceived((ChatEvent)e);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.pausedEventsQueue.removeAllElements();
        }
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    protected String translateChat(ChatEvent chatEvent) {
        return chatEvent.toString();
    }

    public void connectionAttempted(Connection connection, String string, int n) {
        String string2 = this.getI18n().getFormattedString("tryingToConnectMessage", new Object[]{string, String.valueOf(n)});
        this.console.addToOutput(string2, "info");
    }

    public void connectionEstablished(Connection connection) {
        this.console.addToOutput(this.getI18n().getString("connectedMessage"), "info");
    }

    public void loginSucceeded(Connection connection) {
        String string = this.getI18n().getFormattedString("mainConsole.title", new Object[]{this.getConn().getUsername(), this.getServer().getLongName()});
        this.consoleContainer.setTitle(string);
    }

    public void connectionLost(Connection connection) {
        this.console.addToOutput(this.getI18n().getString("disconnectedWarning"), "info");
    }

    public void connectingFailed(Connection connection, String string) {
    }

    public void loginFailed(Connection connection, String string) {
    }

    protected JTable createGameListTable(GameListEvent gameListEvent) {
        return new GameListTable(this.console, gameListEvent);
    }

    public void gameListArrived(GameListEvent gameListEvent) {
        Component component;
        TableColumn tableColumn;
        JTable jTable = this.createGameListTable(gameListEvent);
        JTableHeader jTableHeader = jTable.getTableHeader();
        Dimension dimension = jTableHeader.getPreferredSize();
        jTableHeader.setPreferredSize(new Dimension(dimension.width, Math.max(dimension.height, 18)));
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableModel tableModel = jTable.getModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            tableColumn = tableColumnModel.getColumn(i);
            component = tableColumn.getHeaderRenderer().getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, i);
            int n = component.getPreferredSize().width;
            for (int j = 0; j < tableModel.getRowCount(); ++j) {
                TableCellRenderer tableCellRenderer = jTable.getCellRenderer(j, i);
                Object object = tableModel.getValueAt(j, i);
                Component component2 = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, j, i);
                int n2 = component2.getPreferredSize().width;
                if (n2 <= n) continue;
                n = n2;
            }
            if (n > 150) {
                tableColumn.setPreferredWidth(50);
                continue;
            }
            tableColumn.setPreferredWidth(n);
        }
        String string = this.getI18n().getFormattedString("gameListTitle", new Object[]{gameListEvent.getListTitle(), new Integer(gameListEvent.getFirstIndex()), new Integer(gameListEvent.getLastIndex()), new Integer(gameListEvent.getItemCount())});
        string = "  " + string + "  ";
        jScrollPane.setColumnHeaderView(jTable.getTableHeader());
        if (this.getGameListsDisplayStyle() == 0) {
            jScrollPane.setBorder(new TitledBorder(string));
            int n = (this.console.getOutputArea().height - 40) * 2 / 3;
            if (jScrollPane.getPreferredSize().height > n) {
                jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width, n));
            }
            jScrollPane.setPreferredSize(jScrollPane.getPreferredSize());
            this.console.addToOutput(jScrollPane);
        } else {
            tableColumn = this.createContainer(null, 2);
            tableColumn.setTitle(string);
            component = tableColumn.getContentPane();
            ((Container)component).setLayout(new BorderLayout());
            ((Container)component).add(jScrollPane, "Center");
            tableColumn.setVisible(true);
        }
    }

    public void saveState() {
        if (this.getConn() instanceof GameListConnection) {
            String string;
            switch (this.getGameListsDisplayStyle()) {
                case 0: {
                    string = "embedded";
                    break;
                }
                case 1: {
                    string = "framed";
                    break;
                }
                case 2: {
                    string = "none";
                    break;
                }
                default: {
                    throw new IllegalStateException("Bad gameListsDisplayStyle value");
                }
            }
            this.getPrefs().setString("game-list-display-style", string);
        }
    }

    public String getId() {
        return "console";
    }

    public String getName() {
        return this.getI18n().getString("pluginName");
    }

    public boolean hasPreferencesUI() {
        return this.getPrefs().getBool("preferences.show", true);
    }

    public PreferencesPanel getPreferencesUI() {
        return new ConsolePrefsPanel(this);
    }
}

