/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.javaee.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PersistenceContextType implements Enumerator
{
    TRANSACTION_LITERAL(0, "Transaction", "Transaction"),
    EXTENDED_LITERAL(1, "Extended", "Extended");

    public static final int TRANSACTION = 0;
    public static final int EXTENDED = 1;
    private static final PersistenceContextType[] VALUES_ARRAY;
    public static final List<PersistenceContextType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PersistenceContextType[]{TRANSACTION_LITERAL, EXTENDED_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PersistenceContextType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PersistenceContextType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PersistenceContextType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PersistenceContextType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PersistenceContextType get(int value) {
        switch (value) {
            case 0: {
                return TRANSACTION_LITERAL;
            }
            case 1: {
                return EXTENDED_LITERAL;
            }
        }
        return null;
    }

    private PersistenceContextType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

