/*
 * protocol.h
 * Header for the protocol module
 * Author: Michael Czigler
 * License: MIT
 */

#ifndef __KIRC_PROTOCOL_H
#define __KIRC_PROTOCOL_H

#include "kirc.h"
#include "ansi.h"
#include "helper.h"

typedef enum {
    PROTOCOL_EVENT_NONE = 0,
    PROTOCOL_EVENT_CTCP_ACTION,
    PROTOCOL_EVENT_CTCP_CLIENTINFO,
    PROTOCOL_EVENT_CTCP_DCC,
    PROTOCOL_EVENT_CTCP_PING,
    PROTOCOL_EVENT_CTCP_TIME,
    PROTOCOL_EVENT_CTCP_VERSION,
    PROTOCOL_EVENT_ERROR,
    PROTOCOL_EVENT_EXT_CAP,
    PROTOCOL_EVENT_EXT_AUTHENTICATE,
    PROTOCOL_EVENT_JOIN,
    PROTOCOL_EVENT_KICK,
    PROTOCOL_EVENT_MODE,
    PROTOCOL_EVENT_NICK,
    PROTOCOL_EVENT_NOTICE,
    PROTOCOL_EVENT_PART,
    PROTOCOL_EVENT_PING,
    PROTOCOL_EVENT_PRIVMSG,
    PROTOCOL_EVENT_QUIT,
    PROTOCOL_EVENT_TOPIC,
    PROTOCOL_EVENT_001_RPL_WELCOME,
    PROTOCOL_EVENT_002_RPL_YOURHOST,
    PROTOCOL_EVENT_003_RPL_CREATED,
    PROTOCOL_EVENT_004_RPL_MYINFO,
    PROTOCOL_EVENT_005_RPL_BOUNCE,
    PROTOCOL_EVENT_042_RPL_YOURID,
    PROTOCOL_EVENT_200_RPL_TRACELINK,
    PROTOCOL_EVENT_201_RPL_TRACECONNECTING,
    PROTOCOL_EVENT_202_RPL_TRACEHANDSHAKE,
    PROTOCOL_EVENT_203_RPL_TRACEUNKNOWN,
    PROTOCOL_EVENT_204_RPL_TRACEOPERATOR,
    PROTOCOL_EVENT_205_RPL_TRACEUSER,
    PROTOCOL_EVENT_206_RPL_TRACESERVER,
    PROTOCOL_EVENT_207_RPL_TRACESERVICE,
    PROTOCOL_EVENT_208_RPL_TRACENEWTYPE,
    PROTOCOL_EVENT_209_RPL_TRACECLASS,
    PROTOCOL_EVENT_211_RPL_STATSLINKINFO,
    PROTOCOL_EVENT_212_RPL_STATSCOMMANDS,
    PROTOCOL_EVENT_213_RPL_STATSCLINE,
    PROTOCOL_EVENT_215_RPL_STATSILINE,
    PROTOCOL_EVENT_216_RPL_STATSKLINE,
    PROTOCOL_EVENT_218_RPL_STATSYLINE,
    PROTOCOL_EVENT_219_RPL_ENDOFSTATS,
    PROTOCOL_EVENT_221_RPL_UMODEIS,
    PROTOCOL_EVENT_234_RPL_SERVLIST,
    PROTOCOL_EVENT_235_RPL_SERVLISTEND,
    PROTOCOL_EVENT_241_RPL_STATSLLINE,
    PROTOCOL_EVENT_242_RPL_STATSUPTIME,
    PROTOCOL_EVENT_243_RPL_STATSOLINE,
    PROTOCOL_EVENT_244_RPL_STATSHLINE,
    PROTOCOL_EVENT_245_RPL_STATSSLINE,
    PROTOCOL_EVENT_250_RPL_STATSCONN,
    PROTOCOL_EVENT_251_RPL_LUSERCLIENT,
    PROTOCOL_EVENT_252_RPL_LUSEROP,
    PROTOCOL_EVENT_253_RPL_LUSERUNKNOWN,
    PROTOCOL_EVENT_254_RPL_LUSERCHANNELS,
    PROTOCOL_EVENT_255_RPL_LUSERME,
    PROTOCOL_EVENT_256_RPL_ADMINME,
    PROTOCOL_EVENT_257_RPL_ADMINLOC1,
    PROTOCOL_EVENT_258_RPL_ADMINLOC2,
    PROTOCOL_EVENT_259_RPL_ADMINEMAIL,
    PROTOCOL_EVENT_261_RPL_TRACELOG,
    PROTOCOL_EVENT_263_RPL_TRYAGAIN,
    PROTOCOL_EVENT_265_RPL_LOCALUSERS,
    PROTOCOL_EVENT_266_RPL_GLOBALUSERS,
    PROTOCOL_EVENT_300_RPL_NONE,
    PROTOCOL_EVENT_301_RPL_AWAY,
    PROTOCOL_EVENT_302_RPL_USERHOST,
    PROTOCOL_EVENT_303_RPL_ISON,
    PROTOCOL_EVENT_305_RPL_UNAWAY,
    PROTOCOL_EVENT_306_RPL_NOWAWAY,
    PROTOCOL_EVENT_311_RPL_WHOISUSER,
    PROTOCOL_EVENT_312_RPL_WHOISSERVER,
    PROTOCOL_EVENT_313_RPL_WHOISOPERATOR,
    PROTOCOL_EVENT_314_RPL_WHOWASUSER,
    PROTOCOL_EVENT_315_RPL_ENDOFWHO,
    PROTOCOL_EVENT_317_RPL_WHOISIDLE,
    PROTOCOL_EVENT_318_RPL_ENDOFWHOIS,
    PROTOCOL_EVENT_319_RPL_WHOISCHANNELS,
    PROTOCOL_EVENT_322_RPL_LIST,
    PROTOCOL_EVENT_323_RPL_LISTEND,
    PROTOCOL_EVENT_324_RPL_CHANNELMODEIS,
    PROTOCOL_EVENT_328_RPL_CHANNEL_URL,
    PROTOCOL_EVENT_331_RPL_NOTOPIC,
    PROTOCOL_EVENT_332_RPL_TOPIC,
    PROTOCOL_EVENT_333_RPL_TOPICWHOTIME,
    PROTOCOL_EVENT_341_RPL_INVITING,
    PROTOCOL_EVENT_346_RPL_INVITELIST,
    PROTOCOL_EVENT_347_RPL_ENDOFINVITELIST,
    PROTOCOL_EVENT_348_RPL_EXCEPTLIST,
    PROTOCOL_EVENT_349_RPL_ENDOFEXCEPTLIST,
    PROTOCOL_EVENT_351_RPL_VERSION,
    PROTOCOL_EVENT_352_RPL_WHOREPLY,
    PROTOCOL_EVENT_353_RPL_NAMREPLY,
    PROTOCOL_EVENT_364_RPL_LINKS,
    PROTOCOL_EVENT_365_RPL_ENDOFLINKS,
    PROTOCOL_EVENT_366_RPL_ENDOFNAMES,
    PROTOCOL_EVENT_367_RPL_BANLIST,
    PROTOCOL_EVENT_368_RPL_ENDOFBANLIST,
    PROTOCOL_EVENT_369_RPL_ENDOFWHOWAS,
    PROTOCOL_EVENT_371_RPL_INFO,
    PROTOCOL_EVENT_372_RPL_MOTD,
    PROTOCOL_EVENT_374_RPL_ENDOFINFO,
    PROTOCOL_EVENT_375_RPL_MOTDSTART,
    PROTOCOL_EVENT_376_RPL_ENDOFMOTD,
    PROTOCOL_EVENT_381_RPL_YOUREOPER,
    PROTOCOL_EVENT_382_RPL_REHASHING,
    PROTOCOL_EVENT_383_RPL_YOURESERVICE,
    PROTOCOL_EVENT_391_RPL_TIME,
    PROTOCOL_EVENT_392_RPL_USERSSTART,
    PROTOCOL_EVENT_393_RPL_USERS,
    PROTOCOL_EVENT_394_RPL_ENDOFUSERS,
    PROTOCOL_EVENT_395_RPL_NOUSERS,
    PROTOCOL_EVENT_396_RPL_HOSTHIDDEN,
    PROTOCOL_EVENT_400_ERR_UNKNOWNERROR,
    PROTOCOL_EVENT_401_ERR_NOSUCHNICK,
    PROTOCOL_EVENT_402_ERR_NOSUCHSERVER,
    PROTOCOL_EVENT_403_ERR_NOSUCHCHANNEL,
    PROTOCOL_EVENT_404_ERR_CANNOTSENDTOCHAN,
    PROTOCOL_EVENT_405_ERR_TOOMANYCHANNELS,
    PROTOCOL_EVENT_406_ERR_WASNOSUCHNICK,
    PROTOCOL_EVENT_407_ERR_TOOMANYTARGETS,
    PROTOCOL_EVENT_408_ERR_NOSUCHSERVICE,
    PROTOCOL_EVENT_409_ERR_NOORIGIN,
    PROTOCOL_EVENT_411_ERR_NORECIPIENT,
    PROTOCOL_EVENT_412_ERR_NOTEXTTOSEND,
    PROTOCOL_EVENT_413_ERR_NOTOPLEVEL,
    PROTOCOL_EVENT_414_ERR_WILDTOPLEVEL,
    PROTOCOL_EVENT_415_ERR_BADMASK,
    PROTOCOL_EVENT_421_ERR_UNKNOWNCOMMAND,
    PROTOCOL_EVENT_422_ERR_NOMOTD,
    PROTOCOL_EVENT_423_ERR_NOADMININFO,
    PROTOCOL_EVENT_424_ERR_FILEERROR,
    PROTOCOL_EVENT_431_ERR_NONICKNAMEGIVEN,
    PROTOCOL_EVENT_432_ERR_ERRONEUSNICKNAME,
    PROTOCOL_EVENT_433_ERR_NICKNAMEINUSE,
    PROTOCOL_EVENT_436_ERR_NICKCOLLISION,
    PROTOCOL_EVENT_441_ERR_USERNOTINCHANNEL,
    PROTOCOL_EVENT_442_ERR_NOTONCHANNEL,
    PROTOCOL_EVENT_443_ERR_USERONCHANNEL,
    PROTOCOL_EVENT_444_ERR_NOLOGIN,
    PROTOCOL_EVENT_445_ERR_SUMMONDISABLED,
    PROTOCOL_EVENT_446_ERR_USERSDISABLED,
    PROTOCOL_EVENT_451_ERR_NOTREGISTERED,
    PROTOCOL_EVENT_461_ERR_NEEDMOREPARAMS,
    PROTOCOL_EVENT_462_ERR_ALREADYREGISTERED,
    PROTOCOL_EVENT_463_ERR_NOPERMFORHOST,
    PROTOCOL_EVENT_464_ERR_PASSWDMISMATCH,
    PROTOCOL_EVENT_465_ERR_YOUREBANNEDCREEP,
    PROTOCOL_EVENT_467_ERR_KEYSET,
    PROTOCOL_EVENT_470_ERR_LINKCHANNEL,
    PROTOCOL_EVENT_471_ERR_CHANNELISFULL,
    PROTOCOL_EVENT_472_ERR_UNKNOWNMODE,
    PROTOCOL_EVENT_473_ERR_INVITEONLYCHAN,
    PROTOCOL_EVENT_474_ERR_BANNEDFROMCHAN,
    PROTOCOL_EVENT_475_ERR_BADCHANNELKEY,
    PROTOCOL_EVENT_476_ERR_BADCHANMASK,
    PROTOCOL_EVENT_477_ERR_NEEDREGGEDNICK,
    PROTOCOL_EVENT_478_ERR_BANLISTFULL,
    PROTOCOL_EVENT_481_ERR_NOPRIVILEGES,
    PROTOCOL_EVENT_482_ERR_CHANOPRIVSNEEDED,
    PROTOCOL_EVENT_483_ERR_CANTKILLSERVER,
    PROTOCOL_EVENT_485_ERR_UNIQOPRIVSNEEDED,
    PROTOCOL_EVENT_491_ERR_NOOPERHOST,
    PROTOCOL_EVENT_501_ERR_UMODEUNKNOWNFLAG,
    PROTOCOL_EVENT_502_ERR_USERSDONTMATCH,
    PROTOCOL_EVENT_704_RPL_HELPSTART,
    PROTOCOL_EVENT_705_RPL_HELPTXT,
    PROTOCOL_EVENT_706_RPL_ENDOFHELP,
    PROTOCOL_EVENT_900_RPL_LOGGEDIN,
    PROTOCOL_EVENT_901_RPL_LOGGEDOUT,
    PROTOCOL_EVENT_902_ERR_NICKLOCKED,
    PROTOCOL_EVENT_903_RPL_SASLSUCCESS,
    PROTOCOL_EVENT_904_ERR_SASLFAIL,
    PROTOCOL_EVENT_905_ERR_SASLTOOLONG,
    PROTOCOL_EVENT_906_ERR_SASLABORTED,
    PROTOCOL_EVENT_907_ERR_SASLALREADY,
    PROTOCOL_EVENT_908_RPL_SASLMECHS
} protocol_event_t;

typedef struct {
    const char *command;
    protocol_event_t event;
} protocol_event_map_t;

static const protocol_event_map_t map[] = {
    { "CAP",     PROTOCOL_EVENT_EXT_CAP },
    { "JOIN",    PROTOCOL_EVENT_JOIN },
    { "KICK",    PROTOCOL_EVENT_KICK },
    { "MODE",    PROTOCOL_EVENT_MODE },
    { "NICK",    PROTOCOL_EVENT_NICK },
    { "NOTICE",  PROTOCOL_EVENT_NOTICE },
    { "PART",    PROTOCOL_EVENT_PART },
    { "PING",    PROTOCOL_EVENT_PING },
    { "PRIVMSG", PROTOCOL_EVENT_PRIVMSG },
    { "QUIT",    PROTOCOL_EVENT_QUIT },
    { "TOPIC",   PROTOCOL_EVENT_TOPIC },
    { "001",     PROTOCOL_EVENT_001_RPL_WELCOME },
    { "002",     PROTOCOL_EVENT_002_RPL_YOURHOST },
    { "003",     PROTOCOL_EVENT_003_RPL_CREATED },
    { "004",     PROTOCOL_EVENT_004_RPL_MYINFO },
    { "005",     PROTOCOL_EVENT_005_RPL_BOUNCE },
    { "042",     PROTOCOL_EVENT_042_RPL_YOURID },
    { "200",     PROTOCOL_EVENT_200_RPL_TRACELINK },
    { "201",     PROTOCOL_EVENT_201_RPL_TRACECONNECTING },
    { "202",     PROTOCOL_EVENT_202_RPL_TRACEHANDSHAKE },
    { "203",     PROTOCOL_EVENT_203_RPL_TRACEUNKNOWN },
    { "204",     PROTOCOL_EVENT_204_RPL_TRACEOPERATOR },
    { "205",     PROTOCOL_EVENT_205_RPL_TRACEUSER },
    { "206",     PROTOCOL_EVENT_206_RPL_TRACESERVER },
    { "207",     PROTOCOL_EVENT_207_RPL_TRACESERVICE },
    { "208",     PROTOCOL_EVENT_208_RPL_TRACENEWTYPE },
    { "209",     PROTOCOL_EVENT_209_RPL_TRACECLASS },
    { "211",     PROTOCOL_EVENT_211_RPL_STATSLINKINFO },
    { "212",     PROTOCOL_EVENT_212_RPL_STATSCOMMANDS },
    { "213",     PROTOCOL_EVENT_213_RPL_STATSCLINE},
    { "215",     PROTOCOL_EVENT_215_RPL_STATSILINE },
    { "216",     PROTOCOL_EVENT_216_RPL_STATSKLINE },
    { "218",     PROTOCOL_EVENT_218_RPL_STATSYLINE },
    { "219",     PROTOCOL_EVENT_219_RPL_ENDOFSTATS },
    { "221",     PROTOCOL_EVENT_221_RPL_UMODEIS },
    { "234",     PROTOCOL_EVENT_234_RPL_SERVLIST },
    { "235",     PROTOCOL_EVENT_235_RPL_SERVLISTEND },
    { "241",     PROTOCOL_EVENT_241_RPL_STATSLLINE },
    { "242",     PROTOCOL_EVENT_242_RPL_STATSUPTIME },
    { "243",     PROTOCOL_EVENT_243_RPL_STATSOLINE },
    { "244",     PROTOCOL_EVENT_244_RPL_STATSHLINE },
    { "245",     PROTOCOL_EVENT_245_RPL_STATSSLINE },
    { "250",     PROTOCOL_EVENT_250_RPL_STATSCONN },
    { "251",     PROTOCOL_EVENT_251_RPL_LUSERCLIENT },
    { "252",     PROTOCOL_EVENT_252_RPL_LUSEROP },
    { "253",     PROTOCOL_EVENT_253_RPL_LUSERUNKNOWN },
    { "254",     PROTOCOL_EVENT_254_RPL_LUSERCHANNELS },
    { "255",     PROTOCOL_EVENT_255_RPL_LUSERME },
    { "256",     PROTOCOL_EVENT_256_RPL_ADMINME },
    { "257",     PROTOCOL_EVENT_257_RPL_ADMINLOC1 },
    { "258",     PROTOCOL_EVENT_258_RPL_ADMINLOC2 },
    { "259",     PROTOCOL_EVENT_259_RPL_ADMINEMAIL },
    { "261",     PROTOCOL_EVENT_261_RPL_TRACELOG },
    { "263",     PROTOCOL_EVENT_263_RPL_TRYAGAIN },
    { "265",     PROTOCOL_EVENT_265_RPL_LOCALUSERS },
    { "266",     PROTOCOL_EVENT_266_RPL_GLOBALUSERS },
    { "300",     PROTOCOL_EVENT_300_RPL_NONE },
    { "301",     PROTOCOL_EVENT_301_RPL_AWAY },
    { "302",     PROTOCOL_EVENT_302_RPL_USERHOST },
    { "303",     PROTOCOL_EVENT_303_RPL_ISON },
    { "305",     PROTOCOL_EVENT_305_RPL_UNAWAY },
    { "306",     PROTOCOL_EVENT_306_RPL_NOWAWAY },
    { "311",     PROTOCOL_EVENT_311_RPL_WHOISUSER },
    { "312",     PROTOCOL_EVENT_312_RPL_WHOISSERVER },
    { "313",     PROTOCOL_EVENT_313_RPL_WHOISOPERATOR },
    { "314",     PROTOCOL_EVENT_314_RPL_WHOWASUSER },
    { "315",     PROTOCOL_EVENT_315_RPL_ENDOFWHO },
    { "317",     PROTOCOL_EVENT_317_RPL_WHOISIDLE },
    { "318",     PROTOCOL_EVENT_318_RPL_ENDOFWHOIS },
    { "319",     PROTOCOL_EVENT_319_RPL_WHOISCHANNELS },
    { "322",     PROTOCOL_EVENT_322_RPL_LIST },
    { "323",     PROTOCOL_EVENT_323_RPL_LISTEND },
    { "324",     PROTOCOL_EVENT_324_RPL_CHANNELMODEIS },
    { "328",     PROTOCOL_EVENT_328_RPL_CHANNEL_URL },
    { "331",     PROTOCOL_EVENT_331_RPL_NOTOPIC },
    { "332",     PROTOCOL_EVENT_332_RPL_TOPIC },
    { "333",     PROTOCOL_EVENT_333_RPL_TOPICWHOTIME },
    { "341",     PROTOCOL_EVENT_341_RPL_INVITING },
    { "346",     PROTOCOL_EVENT_346_RPL_INVITELIST },
    { "347",     PROTOCOL_EVENT_347_RPL_ENDOFINVITELIST },
    { "348",     PROTOCOL_EVENT_348_RPL_EXCEPTLIST },
    { "349",     PROTOCOL_EVENT_349_RPL_ENDOFEXCEPTLIST },
    { "351",     PROTOCOL_EVENT_351_RPL_VERSION },
    { "352",     PROTOCOL_EVENT_352_RPL_WHOREPLY },
    { "353",     PROTOCOL_EVENT_353_RPL_NAMREPLY },
    { "364",     PROTOCOL_EVENT_364_RPL_LINKS },
    { "365",     PROTOCOL_EVENT_365_RPL_ENDOFLINKS },
    { "366",     PROTOCOL_EVENT_366_RPL_ENDOFNAMES },
    { "367",     PROTOCOL_EVENT_367_RPL_BANLIST },
    { "368",     PROTOCOL_EVENT_368_RPL_ENDOFBANLIST },
    { "369",     PROTOCOL_EVENT_369_RPL_ENDOFWHOWAS },
    { "375",     PROTOCOL_EVENT_375_RPL_MOTDSTART },
    { "371",     PROTOCOL_EVENT_371_RPL_INFO },
    { "372",     PROTOCOL_EVENT_372_RPL_MOTD },
    { "374",     PROTOCOL_EVENT_374_RPL_ENDOFINFO },
    { "376",     PROTOCOL_EVENT_376_RPL_ENDOFMOTD },
    { "381",     PROTOCOL_EVENT_381_RPL_YOUREOPER },
    { "382",     PROTOCOL_EVENT_382_RPL_REHASHING },
    { "383",     PROTOCOL_EVENT_383_RPL_YOURESERVICE },
    { "391",     PROTOCOL_EVENT_391_RPL_TIME },
    { "392",     PROTOCOL_EVENT_392_RPL_USERSSTART },
    { "393",     PROTOCOL_EVENT_393_RPL_USERS },
    { "394",     PROTOCOL_EVENT_394_RPL_ENDOFUSERS },
    { "395",     PROTOCOL_EVENT_395_RPL_NOUSERS },
    { "396",     PROTOCOL_EVENT_396_RPL_HOSTHIDDEN },
    { "400",     PROTOCOL_EVENT_400_ERR_UNKNOWNERROR },
    { "401",     PROTOCOL_EVENT_401_ERR_NOSUCHNICK },
    { "402",     PROTOCOL_EVENT_402_ERR_NOSUCHSERVER },
    { "403",     PROTOCOL_EVENT_403_ERR_NOSUCHCHANNEL },
    { "404",     PROTOCOL_EVENT_404_ERR_CANNOTSENDTOCHAN },
    { "405",     PROTOCOL_EVENT_405_ERR_TOOMANYCHANNELS },
    { "406",     PROTOCOL_EVENT_406_ERR_WASNOSUCHNICK },
    { "407",     PROTOCOL_EVENT_407_ERR_TOOMANYTARGETS },
    { "408",     PROTOCOL_EVENT_408_ERR_NOSUCHSERVICE },
    { "409",     PROTOCOL_EVENT_409_ERR_NOORIGIN },
    { "411",     PROTOCOL_EVENT_411_ERR_NORECIPIENT },
    { "412",     PROTOCOL_EVENT_412_ERR_NOTEXTTOSEND },
    { "413",     PROTOCOL_EVENT_413_ERR_NOTOPLEVEL },
    { "414",     PROTOCOL_EVENT_414_ERR_WILDTOPLEVEL },
    { "415",     PROTOCOL_EVENT_415_ERR_BADMASK },
    { "421",     PROTOCOL_EVENT_421_ERR_UNKNOWNCOMMAND },
    { "422",     PROTOCOL_EVENT_422_ERR_NOMOTD },
    { "423",     PROTOCOL_EVENT_423_ERR_NOADMININFO },
    { "424",     PROTOCOL_EVENT_424_ERR_FILEERROR },
    { "431",     PROTOCOL_EVENT_431_ERR_NONICKNAMEGIVEN },
    { "432",     PROTOCOL_EVENT_432_ERR_ERRONEUSNICKNAME },
    { "433",     PROTOCOL_EVENT_433_ERR_NICKNAMEINUSE },
    { "436",     PROTOCOL_EVENT_436_ERR_NICKCOLLISION },
    { "441",     PROTOCOL_EVENT_441_ERR_USERNOTINCHANNEL },
    { "442",     PROTOCOL_EVENT_442_ERR_NOTONCHANNEL },
    { "443",     PROTOCOL_EVENT_443_ERR_USERONCHANNEL },
    { "444",     PROTOCOL_EVENT_444_ERR_NOLOGIN },
    { "445",     PROTOCOL_EVENT_445_ERR_SUMMONDISABLED },
    { "446",     PROTOCOL_EVENT_446_ERR_USERSDISABLED },
    { "451",     PROTOCOL_EVENT_451_ERR_NOTREGISTERED },
    { "461",     PROTOCOL_EVENT_461_ERR_NEEDMOREPARAMS },
    { "462",     PROTOCOL_EVENT_462_ERR_ALREADYREGISTERED },
    { "463",     PROTOCOL_EVENT_463_ERR_NOPERMFORHOST },
    { "464",     PROTOCOL_EVENT_464_ERR_PASSWDMISMATCH },
    { "465",     PROTOCOL_EVENT_465_ERR_YOUREBANNEDCREEP },
    { "467",     PROTOCOL_EVENT_467_ERR_KEYSET },
    { "470",     PROTOCOL_EVENT_470_ERR_LINKCHANNEL },
    { "471",     PROTOCOL_EVENT_471_ERR_CHANNELISFULL },
    { "472",     PROTOCOL_EVENT_472_ERR_UNKNOWNMODE },
    { "473",     PROTOCOL_EVENT_473_ERR_INVITEONLYCHAN },
    { "474",     PROTOCOL_EVENT_474_ERR_BANNEDFROMCHAN },
    { "475",     PROTOCOL_EVENT_475_ERR_BADCHANNELKEY },
    { "476",     PROTOCOL_EVENT_476_ERR_BADCHANMASK },
    { "477",     PROTOCOL_EVENT_477_ERR_NEEDREGGEDNICK },
    { "478",     PROTOCOL_EVENT_478_ERR_BANLISTFULL },
    { "481",     PROTOCOL_EVENT_481_ERR_NOPRIVILEGES },
    { "482",     PROTOCOL_EVENT_482_ERR_CHANOPRIVSNEEDED },
    { "483",     PROTOCOL_EVENT_483_ERR_CANTKILLSERVER },
    { "485",     PROTOCOL_EVENT_485_ERR_UNIQOPRIVSNEEDED },
    { "491",     PROTOCOL_EVENT_491_ERR_NOOPERHOST },
    { "501",     PROTOCOL_EVENT_501_ERR_UMODEUNKNOWNFLAG },
    { "502",     PROTOCOL_EVENT_502_ERR_USERSDONTMATCH },
    { "704",     PROTOCOL_EVENT_704_RPL_HELPSTART },
    { "705",     PROTOCOL_EVENT_705_RPL_HELPTXT },
    { "706",     PROTOCOL_EVENT_706_RPL_ENDOFHELP },
    { "900",     PROTOCOL_EVENT_900_RPL_LOGGEDIN },
    { "901",     PROTOCOL_EVENT_901_RPL_LOGGEDOUT },
    { "902",     PROTOCOL_EVENT_902_ERR_NICKLOCKED },
    { "903",     PROTOCOL_EVENT_903_RPL_SASLSUCCESS },
    { "904",     PROTOCOL_EVENT_904_ERR_SASLFAIL },
    { "905",     PROTOCOL_EVENT_905_ERR_SASLTOOLONG },
    { "906",     PROTOCOL_EVENT_906_ERR_SASLABORTED },
    { "907",     PROTOCOL_EVENT_907_ERR_SASLALREADY },
    { "908",     PROTOCOL_EVENT_908_RPL_SASLMECHS },
    { NULL,      PROTOCOL_EVENT_NONE }
};

typedef struct {
    kirc_t *ctx;
    protocol_event_t event;
    char raw[MESSAGE_MAX_LEN];
    char channel[CHANNEL_MAX_LEN];
    char message[MESSAGE_MAX_LEN];
    char command[MESSAGE_MAX_LEN];
    char nickname[MESSAGE_MAX_LEN];
    char params[MESSAGE_MAX_LEN];
} protocol_t;

int protocol_init(protocol_t *protocol, kirc_t *ctx);
int protocol_parse(protocol_t *protocol, char *line);
int protocol_handle(protocol_t *protocol);

#endif  // __KIRC_PROTOCOL_H
