/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.reports.html;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.browser.BrowserEditorInput;
import com.archimatetool.editor.browser.IBrowserEditor;
import com.archimatetool.editor.diagram.util.DiagramUtils;
import com.archimatetool.editor.diagram.util.ModelReferencedImage;
import com.archimatetool.editor.ui.ImageFactory;
import com.archimatetool.editor.ui.services.EditorManager;
import com.archimatetool.editor.utils.FileUtils;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelContainer;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IDiagramModelReference;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.IIdentifier;
import com.archimatetool.reports.ArchiReportsPlugin;
import com.archimatetool.reports.html.BoundsWithAbsolutePosition;
import com.archimatetool.reports.html.Messages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.osgi.framework.Bundle;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.StringRenderer;

public class HTMLReportExporter {
    public static File PREVIEW_FOLDER = new File(ArchiPlugin.getInstance().getWorkspaceFolder(), "html-report-preview");
    static final String PREFS_LAST_FOLDER = "Reports_LastFolder";
    private IArchimateModel fModel;
    private Map<IDiagramModel, Rectangle> diagramBoundsMap = new HashMap<IDiagramModel, Rectangle>();
    private Map<String, BoundsWithAbsolutePosition> childBoundsMap = new HashMap<String, BoundsWithAbsolutePosition>();
    private IProgressMonitor progressMonitor;

    public static void cleanPreviewFiles() throws IOException {
        FileUtils.deleteFolder((File)PREVIEW_FOLDER);
    }

    public HTMLReportExporter(IArchimateModel model) {
        this.fModel = model;
    }

    public void export() throws Exception {
        File targetFolder = this.askSaveFolder();
        if (targetFolder == null) {
            return;
        }
        Exception[] exception = new Exception[1];
        File[] file = new File[1];
        IRunnableWithProgress runnable = monitor -> {
            try {
                fileArray[0] = this.createReport(targetFolder, "index.html", monitor);
            }
            catch (Exception ex) {
                exceptionArray[0] = ex;
            }
        };
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            dialog.run(false, true, runnable);
        }
        catch (Exception ex) {
            exception[0] = ex;
        }
        if (exception[0] instanceof CancelledException) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.HTMLReportExporter_2, (String)exception[0].getMessage());
            return;
        }
        if (exception[0] != null) {
            throw exception[0];
        }
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        IWebBrowser browser = support.getExternalBrowser();
        String path = "file:///" + file[0].getAbsolutePath().replaceAll(" ", "%20").replaceAll("\\\\", "/");
        browser.openURL(new URI(path).toURL());
    }

    public void preview() throws Exception {
        PREVIEW_FOLDER.mkdirs();
        Exception[] exception = new Exception[1];
        File[] file = new File[1];
        IRunnableWithProgress runnable = monitor -> {
            try {
                fileArray[0] = this.createReport(PREVIEW_FOLDER, "preview-" + this.fModel.getId() + ".html", monitor);
            }
            catch (Exception ex) {
                exceptionArray[0] = ex;
            }
        };
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            dialog.run(false, true, runnable);
        }
        catch (Exception ex) {
            exception[0] = ex;
        }
        if (exception[0] instanceof CancelledException) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.HTMLReportExporter_2, (String)exception[0].getMessage());
            return;
        }
        if (exception[0] != null) {
            throw exception[0];
        }
        BrowserEditorInput input = new BrowserEditorInput("file:///" + file[0].getPath(), Messages.HTMLReportExporter_0 + " " + this.fModel.getName());
        IBrowserEditor editor = (IBrowserEditor)EditorManager.openEditor((IEditorInput)input, (String)"com.archimatetool.editor.browser.browserEditor");
        if (editor != null && editor.getBrowser() != null) {
            editor.getBrowser().refresh();
        }
    }

    public File createReport(File targetFolder, String indexFileName) throws IOException {
        return this.createReport(targetFolder, indexFileName, null);
    }

    public File createReport(File targetFolder, String indexFileName, IProgressMonitor monitor) throws IOException {
        this.progressMonitor = monitor;
        if (this.progressMonitor != null) {
            this.progressMonitor.beginTask(Messages.HTMLReportExporter_6, -1);
        }
        this.copyHTMLSkeleton(targetFolder);
        this.copyHintsFiles(targetFolder);
        this.setProgressSubTask(Messages.HTMLReportExporter_11);
        File elementsFolder = new File(targetFolder, this.fModel.getId() + "/elements");
        elementsFolder.mkdirs();
        File viewsFolder = new File(targetFolder, this.fModel.getId() + "/views");
        viewsFolder.mkdirs();
        File imagesFolder = new File(targetFolder, this.fModel.getId() + "/images");
        imagesFolder.mkdirs();
        File objectsFolder = new File(targetFolder, this.fModel.getId() + "/objects");
        objectsFolder.mkdirs();
        File mainFile = new File(ArchiReportsPlugin.getInstance().getTemplatesFolder(), "st/main.stg");
        STGroupFile groupFile = new STGroupFile(mainFile.getAbsolutePath(), '^', '^');
        ST stFrame = groupFile.getInstanceOf("frame");
        groupFile.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
        this.writeElement(new File(elementsFolder, "model.html"), stFrame, (EObject)this.fModel);
        this.writeFolders(elementsFolder, stFrame, (List<IFolder>)this.fModel.getFolders());
        this.writeGraphicalObjects(objectsFolder, stFrame);
        this.writeDiagrams(imagesFolder, viewsFolder, stFrame);
        this.setProgressSubTask(Messages.HTMLReportExporter_13);
        ST stModel = groupFile.getInstanceOf("modelreport");
        stModel.add("model", (Object)this.fModel);
        stModel.add("strategyFolder", (Object)this.fModel.getFolder(FolderType.STRATEGY));
        stModel.add("businessFolder", (Object)this.fModel.getFolder(FolderType.BUSINESS));
        stModel.add("applicationFolder", (Object)this.fModel.getFolder(FolderType.APPLICATION));
        stModel.add("technologyFolder", (Object)this.fModel.getFolder(FolderType.TECHNOLOGY));
        stModel.add("motivationFolder", (Object)this.fModel.getFolder(FolderType.MOTIVATION));
        stModel.add("implementationFolder", (Object)this.fModel.getFolder(FolderType.IMPLEMENTATION_MIGRATION));
        stModel.add("otherFolder", (Object)this.fModel.getFolder(FolderType.OTHER));
        stModel.add("relationsFolder", (Object)this.fModel.getFolder(FolderType.RELATIONS));
        stModel.add("viewsFolder", (Object)this.fModel.getFolder(FolderType.DIAGRAMS));
        File indexFile = new File(targetFolder, indexFileName);
        Throwable throwable = null;
        Object var14_15 = null;
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(indexFile), "UTF8");){
            writer.write(stModel.render());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return indexFile;
    }

    private void copyHTMLSkeleton(File targetFolder) throws IOException {
        this.setProgressSubTask(Messages.HTMLReportExporter_9);
        File srcDir = new File(ArchiReportsPlugin.getInstance().getTemplatesFolder(), "html");
        FileUtils.copyFolder((File)srcDir, (File)targetFolder);
    }

    private void copyHintsFiles(File targetFolder) throws IOException {
        this.setProgressSubTask(Messages.HTMLReportExporter_10);
        Bundle bundle = Platform.getBundle((String)"com.archimatetool.help");
        URL url = FileLocator.resolve((URL)bundle.getEntry("hints"));
        FileUtils.copyFolder((File)new File(url.getPath()), (File)new File(targetFolder, "hints"));
        bundle = Platform.getBundle((String)"com.archimatetool.canvas");
        url = FileLocator.resolve((URL)bundle.getEntry("help/hints"));
        FileUtils.copyFolder((File)new File(url.getPath()), (File)new File(targetFolder, "hints"));
    }

    private void writeFolders(File elementsFolder, ST stFrame, List<IFolder> folders) throws IOException {
        for (IFolder folder : folders) {
            this.writeFolder(elementsFolder, stFrame, folder);
        }
    }

    private void writeFolder(File elementsFolder, ST stFrame, IFolder folder) throws IOException {
        this.writeElements(elementsFolder, stFrame, (List<EObject>)folder.getElements());
        this.writeFolders(elementsFolder, stFrame, (List<IFolder>)folder.getFolders());
    }

    private void writeElements(File elementsFolder, ST stFrame, List<EObject> list) throws IOException {
        for (EObject object : list) {
            if (!(object instanceof IArchimateConcept)) continue;
            this.writeElement(new File(elementsFolder, ((IIdentifier)object).getId() + ".html"), stFrame, object);
        }
    }

    private void writeElement(File elementFile, ST stFrame, EObject component) throws IOException {
        stFrame.remove("element");
        stFrame.add("element", (Object)component);
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(elementFile), "UTF8");){
            writer.write(stFrame.render());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.checkProgressCancelled();
    }

    private void writeGraphicalObjects(File objectsFolder, ST stFrame) throws IOException {
        for (IDiagramModel dm : this.fModel.getDiagramModels()) {
            TreeIterator iter = dm.eAllContents();
            while (iter.hasNext()) {
                EObject eObject = (EObject)iter.next();
                if (!(eObject instanceof IDiagramModelObject) || eObject instanceof IDiagramModelArchimateObject || eObject instanceof IDiagramModelReference) continue;
                this.writeElement(new File(objectsFolder, ((IIdentifier)eObject).getId() + ".html"), stFrame, eObject);
            }
        }
    }

    private void writeDiagrams(File imagesFolder, File viewsFolder, ST stFrame) throws IOException {
        EList diagramModels = this.fModel.getDiagramModels();
        if (diagramModels.isEmpty()) {
            return;
        }
        this.saveImages(imagesFolder, (List<IDiagramModel>)diagramModels);
        this.setProgressSubTask(Messages.HTMLReportExporter_11);
        for (IDiagramModel dm : diagramModels) {
            Rectangle bounds = this.diagramBoundsMap.get(dm);
            for (IDiagramModelObject dmo : dm.getChildren()) {
                this.addNewBounds(dmo, bounds.x * -1, bounds.y * -1);
            }
            stFrame.remove("element");
            stFrame.add("element", (Object)dm);
            stFrame.remove("map");
            stFrame.add("map", this.childBoundsMap);
            File viewFile = new File(viewsFolder, dm.getId() + ".html");
            Object object = null;
            Object var10_11 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(viewFile), "UTF8");){
                writer.write(stFrame.render());
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
            this.checkProgressCancelled();
        }
    }

    private void saveImages(File imagesFolder, List<IDiagramModel> diagramModels) throws IOException {
        Hashtable<IDiagramModel, Object> nameTable = new Hashtable<IDiagramModel, Object>();
        int nameCount = 1;
        int total = diagramModels.size();
        int i = 1;
        for (IDiagramModel dm : diagramModels) {
            this.setProgressSubTask(NLS.bind((String)Messages.HTMLReportExporter_4, (Object)i++, (Object)total));
            ModelReferencedImage geoImage = null;
            try {
                try {
                    geoImage = DiagramUtils.createModelReferencedImage((IDiagramModel)dm, (double)1.0, (int)10);
                    Object diagramName = dm.getId();
                    if (StringUtils.isSet((String)diagramName)) {
                        int j = 2;
                        String s = (String)diagramName + ".png";
                        while (nameTable.containsValue(s)) {
                            s = (String)diagramName + "_" + j++ + ".png";
                        }
                        diagramName = s;
                    } else {
                        diagramName = Messages.HTMLReportExporter_1 + " " + nameCount++ + ".png";
                    }
                    nameTable.put(dm, diagramName);
                    Rectangle bounds = geoImage.getBounds();
                    bounds.performScale((double)(ImageFactory.getImageDeviceZoom() / 100));
                    this.diagramBoundsMap.put(dm, bounds);
                    ImageLoader loader = new ImageLoader();
                    loader.data = new ImageData[]{geoImage.getImage().getImageData(ImageFactory.getImageDeviceZoom())};
                    File file = new File(imagesFolder, (String)diagramName);
                    loader.save(file.getAbsolutePath(), 5);
                }
                catch (Throwable t) {
                    throw new IOException("Error saving image for: " + dm.getName() + "\n" + (t.getMessage() == null ? t.toString() : t.getMessage()), t);
                }
            }
            finally {
                if (geoImage != null && geoImage.getImage() != null) {
                    geoImage.getImage().dispose();
                }
            }
        }
    }

    private void checkProgressCancelled() throws CancelledException {
        if (this.progressMonitor != null) {
            if (PlatformUI.isWorkbenchRunning() && Display.getCurrent() != null) {
                while (Display.getCurrent().readAndDispatch()) {
                }
            }
            if (this.progressMonitor.isCanceled()) {
                throw new CancelledException(Messages.HTMLReportExporter_14);
            }
        }
    }

    private void setProgressSubTask(String task) throws CancelledException {
        if (this.progressMonitor != null) {
            this.progressMonitor.subTask(task);
            this.checkProgressCancelled();
        }
    }

    private File askSaveFolder() {
        String path;
        DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.setText(Messages.HTMLReportExporter_2);
        dialog.setMessage(Messages.HTMLReportExporter_3);
        IPreferenceStore store = ArchiReportsPlugin.getInstance().getPreferenceStore();
        String lastFolder = store.getString(PREFS_LAST_FOLDER);
        if (StringUtils.isSet((String)lastFolder)) {
            dialog.setFilterPath(this.getLastDirectory(lastFolder));
        }
        if ((path = dialog.open()) == null) {
            return null;
        }
        File folder = new File(path);
        if (folder.exists()) {
            boolean result;
            String[] children = folder.list();
            if (children != null && children.length > 0 && !(result = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.HTMLReportExporter_2, (String)NLS.bind((String)Messages.HTMLReportExporter_5, (Object)folder)))) {
                return null;
            }
        } else {
            folder.mkdirs();
        }
        store.setValue(PREFS_LAST_FOLDER, folder.getAbsolutePath());
        return folder;
    }

    private String getLastDirectory(String path) {
        File file = new File(path);
        while (file != null && !file.exists()) {
            file = file.getParentFile();
        }
        return file == null ? "" : file.getAbsolutePath();
    }

    private void addNewBounds(IDiagramModelObject dmo, int offsetX, int offsetY) {
        BoundsWithAbsolutePosition newBounds = new BoundsWithAbsolutePosition(dmo.getBounds(), ImageFactory.getImageDeviceZoom() / 100);
        newBounds.setOffset(offsetX, offsetY);
        this.childBoundsMap.put(dmo.getId(), newBounds);
        if (dmo instanceof IDiagramModelContainer) {
            for (IDiagramModelObject child : ((IDiagramModelContainer)dmo).getChildren()) {
                this.addNewBounds(child, newBounds.getX1(), newBounds.getY1());
            }
        }
    }

    static class CancelledException
    extends IOException {
        public CancelledException(String message) {
            super(message);
        }
    }
}

