/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef;

import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.internal.Internal;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class SharedCursors
extends Cursors {
    public static final Cursor CURSOR_PLUG;
    public static final Cursor CURSOR_PLUG_NOT;
    public static final Cursor CURSOR_TREE_ADD;
    public static final Cursor CURSOR_TREE_MOVE;
    private static int deviceZoom;

    static {
        deviceZoom = -1;
        CURSOR_PLUG = SharedCursors.createCursor("icons/plug-cursor.png");
        CURSOR_PLUG_NOT = SharedCursors.createCursor("icons/plugnot-cursor.png");
        CURSOR_TREE_ADD = SharedCursors.createCursor("icons/tree_add-cursor.png");
        CURSOR_TREE_MOVE = SharedCursors.createCursor("icons/tree_move-cursor.png");
    }

    private static Cursor createCursor(String sourceName) {
        ImageDescriptor src = ImageDescriptor.createFromFile(Internal.class, (String)sourceName);
        Image img = src.createImage();
        ImageData id = img.getImageData(SharedCursors.getDeviceZoom());
        img.dispose();
        return new Cursor(null, id, 0, 0);
    }

    private static int getDeviceZoom() {
        if (deviceZoom == -1) {
            deviceZoom = 100;
            String deviceZoomProperty = System.getProperty("org.eclipse.swt.internal.deviceZoom");
            if (deviceZoomProperty != null) {
                try {
                    deviceZoom = Integer.parseInt(deviceZoomProperty);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return Platform.getOS().equals("win32") ? deviceZoom : 100;
    }
}

