/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.internal.ui.palette.PaletteColorUtil;
import org.eclipse.gef.internal.ui.palette.editparts.GroupEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.PaletteContainerFlowLayout;
import org.eclipse.gef.palette.PaletteToolbar;

public class ToolbarEditPart
extends GroupEditPart {
    private static final Border BORDER = new MarginBorder(4, 4, 4, 4);

    public ToolbarEditPart(PaletteToolbar model) {
        super(model);
    }

    @Override
    public IFigure createFigure() {
        Figure figure = new Figure(){

            protected void paintFigure(Graphics graphics) {
                super.paintFigure(graphics);
                graphics.setForegroundColor(PaletteColorUtil.WIDGET_LIST_BACKGROUND);
                graphics.drawLine(this.getBounds().getTopLeft(), this.getBounds().getTopRight());
                graphics.setForegroundColor(PaletteColorUtil.WIDGET_BACKGROUND_NORMAL_SHADOW_70);
                graphics.drawLine(this.getBounds().getBottomLeft().getTranslated(0, -1), this.getBounds().getBottomRight().getTranslated(0, -1));
            }
        };
        figure.setOpaque(true);
        figure.setBackgroundColor(PaletteColorUtil.PALETTE_TOOLBAR_BACKGROUND);
        figure.setBorder(BORDER);
        return figure;
    }

    @Override
    protected int getLayoutSetting() {
        return 2;
    }

    @Override
    public boolean isToolbarItem() {
        return true;
    }

    @Override
    protected void refreshVisuals() {
        if (this.getContentPane().getLayoutManager() == null) {
            PaletteContainerFlowLayout flow = new PaletteContainerFlowLayout();
            flow.setMajorSpacing(4);
            flow.setMinorSpacing(4);
            this.getContentPane().setLayoutManager((LayoutManager)flow);
        }
    }
}

