/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.rulers;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.internal.ui.rulers.GuideEditPart;
import org.eclipse.gef.internal.ui.rulers.GuideFigure;
import org.eclipse.gef.internal.ui.rulers.GuidePlaceHolder;
import org.eclipse.gef.internal.ui.rulers.RulerEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class DragGuidePolicy
extends GraphicalEditPolicy {
    private List attachedEditParts = null;
    private IFigure dummyGuideFigure;
    private IFigure dummyLineFigure;
    private boolean dragInProgress = false;

    protected IFigure createDummyLineFigure() {
        return new Figure();
    }

    protected GuideFigure createDummyGuideFigure() {
        return new GuidePlaceHolder(this.getGuideEditPart().isHorizontal());
    }

    @Override
    public void deactivate() {
        this.removeFeedback();
        super.deactivate();
    }

    private void eraseAttachedPartsFeedback(Request request) {
        if (this.attachedEditParts != null) {
            ChangeBoundsRequest req = new ChangeBoundsRequest(request.getType());
            req.setEditParts(this.attachedEditParts);
            Iterator i = this.attachedEditParts.iterator();
            while (i.hasNext()) {
                ((EditPart)i.next()).eraseSourceFeedback(req);
            }
            this.attachedEditParts = null;
        }
    }

    @Override
    public void eraseSourceFeedback(Request request) {
        this.getGuideEditPart().updateLocationOfFigures(this.getGuideEditPart().getZoomedPosition());
        this.getHostFigure().setVisible(true);
        this.getGuideEditPart().getGuideLineFigure().setVisible(true);
        this.removeFeedback();
        this.getGuideEditPart().setCurrentCursor(null);
        this.dragInProgress = false;
        this.eraseAttachedPartsFeedback(request);
    }

    private List getAttachedEditParts() {
        if (this.attachedEditParts == null) {
            this.attachedEditParts = this.getGuideEditPart().getRulerProvider().getAttachedEditParts(this.getHost().getModel(), ((RulerEditPart)this.getHost().getParent()).getDiagramViewer());
        }
        return this.attachedEditParts;
    }

    @Override
    public Command getCommand(Request request) {
        Command cmd;
        ChangeBoundsRequest req = (ChangeBoundsRequest)request;
        if (this.isDeleteRequest(req)) {
            cmd = this.getGuideEditPart().getRulerProvider().getDeleteGuideCommand(this.getHost().getModel());
        } else {
            int pDelta = this.getGuideEditPart().isHorizontal() ? req.getMoveDelta().y : req.getMoveDelta().x;
            if (this.isMoveValid(this.getGuideEditPart().getZoomedPosition() + pDelta)) {
                ZoomManager zoomManager = this.getGuideEditPart().getZoomManager();
                if (zoomManager != null) {
                    pDelta = (int)Math.round((double)pDelta / zoomManager.getZoom());
                }
                cmd = this.getGuideEditPart().getRulerProvider().getMoveGuideCommand(this.getHost().getModel(), pDelta);
            } else {
                cmd = UnexecutableCommand.INSTANCE;
            }
        }
        return cmd;
    }

    protected IFigure getDummyGuideFigure() {
        if (this.dummyGuideFigure == null) {
            this.dummyGuideFigure = this.createDummyGuideFigure();
        }
        return this.dummyGuideFigure;
    }

    protected IFigure getDummyLineFigure() {
        if (this.dummyLineFigure == null) {
            this.dummyLineFigure = this.createDummyLineFigure();
        }
        return this.dummyLineFigure;
    }

    protected GuideEditPart getGuideEditPart() {
        return (GuideEditPart)this.getHost();
    }

    protected boolean isDeleteRequest(ChangeBoundsRequest req) {
        int max;
        int min;
        int pos;
        if (this.getGuideEditPart().isHorizontal()) {
            pos = req.getLocation().x;
            Rectangle zone = this.getHostFigure().getBounds().getExpanded(20, 0);
            min = zone.x;
            max = min + zone.width;
        } else {
            pos = req.getLocation().y;
            Rectangle zone = this.getHostFigure().getBounds().getExpanded(0, 20);
            min = zone.y;
            max = min + zone.height;
        }
        return pos < min || pos > max;
    }

    protected boolean isMoveValid(int zoomedPosition) {
        boolean result = true;
        ZoomManager zoomManager = this.getGuideEditPart().getZoomManager();
        int position = zoomedPosition;
        if (zoomManager != null) {
            position = (int)Math.round((double)position / zoomManager.getZoom());
        }
        for (Object guide : this.getGuideEditPart().getRulerProvider().getGuides()) {
            int guidePos;
            if (guide == this.getGuideEditPart().getModel() || Math.abs((guidePos = this.getGuideEditPart().getRulerProvider().getGuidePosition(guide)) - position) >= 5) continue;
            result = false;
            break;
        }
        return result;
    }

    private void removeFeedback() {
        if (this.getDummyGuideFigure().getParent() != null) {
            this.getDummyGuideFigure().getParent().remove(this.getDummyGuideFigure());
        }
        if (this.getDummyLineFigure().getParent() != null) {
            this.getDummyLineFigure().getParent().remove(this.getDummyLineFigure());
        }
    }

    private void showAttachedPartsFeedback(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest(request.getType());
        req.setEditParts(this.getAttachedEditParts());
        if (this.getGuideEditPart().isHorizontal()) {
            req.setMoveDelta(new Point(0, request.getMoveDelta().y));
        } else {
            req.setMoveDelta(new Point(request.getMoveDelta().x, 0));
        }
        Iterator i = this.getAttachedEditParts().iterator();
        while (i.hasNext()) {
            ((EditPart)i.next()).showSourceFeedback(req);
        }
    }

    @Override
    public void showSourceFeedback(Request request) {
        ChangeBoundsRequest req;
        if (!this.dragInProgress) {
            this.dragInProgress = true;
            this.getHostFigure().getParent().add(this.getDummyGuideFigure(), 0);
            ((GraphicalEditPart)this.getHost().getParent()).setLayoutConstraint(this.getHost(), this.getDummyGuideFigure(), this.getGuideEditPart().getZoomedPosition());
            this.getDummyGuideFigure().setBounds(this.getHostFigure().getBounds());
            this.getDummyGuideFigure().validate();
            this.getGuideEditPart().getGuideLayer().add(this.getDummyLineFigure(), 0);
            this.getGuideEditPart().getGuideLayer().setConstraint(this.getDummyLineFigure(), (Object)this.getGuideEditPart().isHorizontal());
            this.getDummyLineFigure().setBounds(this.getGuideEditPart().getGuideLineFigure().getBounds());
            this.getDummyLineFigure().validate();
            List children = this.getHostFigure().getParent().getChildren();
            children.remove(this.getHostFigure());
            children.add(this.getHostFigure());
        }
        if (this.isDeleteRequest(req = (ChangeBoundsRequest)request)) {
            this.getHostFigure().setVisible(false);
            this.getGuideEditPart().getGuideLineFigure().setVisible(false);
            this.getGuideEditPart().setCurrentCursor(Cursors.ARROW);
            this.eraseAttachedPartsFeedback(request);
        } else {
            int newPosition = this.getGuideEditPart().isHorizontal() ? this.getGuideEditPart().getZoomedPosition() + req.getMoveDelta().y : this.getGuideEditPart().getZoomedPosition() + req.getMoveDelta().x;
            this.getHostFigure().setVisible(true);
            this.getGuideEditPart().getGuideLineFigure().setVisible(true);
            if (this.isMoveValid(newPosition)) {
                this.getGuideEditPart().setCurrentCursor(null);
                this.getGuideEditPart().updateLocationOfFigures(newPosition);
                this.showAttachedPartsFeedback(req);
            } else {
                this.getGuideEditPart().setCurrentCursor(Cursors.NO);
                this.getGuideEditPart().updateLocationOfFigures(this.getGuideEditPart().getZoomedPosition());
                this.eraseAttachedPartsFeedback(request);
            }
        }
    }

    @Override
    public boolean understandsRequest(Request req) {
        return req.getType().equals("move");
    }
}

