/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.actions;

import java.text.MessageFormat;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.ui.actions.StackAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class UndoAction
extends StackAction {
    public UndoAction(IEditorPart editor) {
        super((IWorkbenchPart)editor);
    }

    public UndoAction(IWorkbenchPart part) {
        super(part);
    }

    @Override
    protected boolean calculateEnabled() {
        return this.getCommandStack().canUndo();
    }

    @Override
    protected void init() {
        super.init();
        this.setToolTipText(MessageFormat.format(GEFMessages.UndoAction_Tooltip, "").trim());
        this.setText(MessageFormat.format(GEFMessages.UndoAction_Label, "").trim());
        this.setId(ActionFactory.UNDO.getId());
        this.setActionDefinitionId(ActionFactory.UNDO.getCommandId());
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO_DISABLED"));
    }

    @Override
    protected void refresh() {
        Command undoCmd = this.getCommandStack().getUndoCommand();
        this.setToolTipText(MessageFormat.format(GEFMessages.UndoAction_Tooltip, this.getLabelForCommand(undoCmd)).trim());
        this.setText(MessageFormat.format(GEFMessages.UndoAction_Label, this.getLabelForCommand(undoCmd)).trim());
        super.refresh();
    }

    public void run() {
        this.getCommandStack().undo();
    }
}

