/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette.customize;

import java.util.HashMap;
import org.eclipse.gef.ui.palette.PaletteMessages;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.PageBook;

public class PaletteSettingsDialog
extends Dialog {
    private PaletteViewerPreferences prefs;
    private Label fontName;
    private PageBook book;
    private Control columnsPanel;
    private Control detailsPanel;
    private Control iconsPanel;
    private Control listPanel;
    private HashMap<Integer, Button> widgets = new HashMap();
    protected HashMap<String, Object> settings = new HashMap();
    protected static final String CACHE_LAYOUT = "layout setting";
    protected static final String CACHE_COLUMNS_ICON_SIZE = "columns - use large icons";
    protected static final String CACHE_LIST_ICON_SIZE = "list - use large icons";
    protected static final String CACHE_ICONS_ICON_SIZE = "icons only - use large icons";
    protected static final String CACHE_DETAILS_ICON_SIZE = "details - use large icons";
    protected static final String CACHE_FONT = "font";
    protected static final String CACHE_COLLAPSE = "auto-collapse setting";
    protected static final int LAYOUT_COLUMNS_VIEW_ID = 1025;
    protected static final int LAYOUT_LIST_VIEW_ID = 1026;
    protected static final int LAYOUT_ICONS_VIEW_ID = 1027;
    protected static final int LAYOUT_COLUMNS_ICON_SIZE_ID = 1028;
    protected static final int LAYOUT_LIST_ICON_SIZE_ID = 1029;
    protected static final int LAYOUT_ICONS_ICON_SIZE_ID = 1030;
    protected static final int LAYOUT_DETAILS_ICON_SIZE_ID = 1031;
    protected static final int COLLAPSE_NEVER_ID = 1032;
    protected static final int COLLAPSE_ALWAYS_ID = 1033;
    protected static final int COLLAPSE_NEEDED_ID = 1034;
    protected static final int APPLY_ID = 1035;
    protected static final int LAYOUT_DETAILS_VIEW_ID = 1036;
    protected static final int FONT_CHANGE_ID = 1037;
    protected static final int DEFAULT_FONT_ID = 1038;
    protected static final int CLIENT_ID = 16;

    public PaletteSettingsDialog(Shell parentShell, PaletteViewerPreferences prefs) {
        super(parentShell);
        this.prefs = prefs;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected void buttonPressed(int buttonId) {
        Button b = this.getButton(buttonId);
        if (1037 == buttonId) {
            this.handleChangeFontPressed();
        } else if (1033 == buttonId) {
            this.handleAutoCollapseSettingChanged(2);
        } else if (1032 == buttonId) {
            this.handleAutoCollapseSettingChanged(1);
        } else if (1034 == buttonId) {
            this.handleAutoCollapseSettingChanged(0);
        } else if (1025 == buttonId) {
            this.handleLayoutSettingChanged(1);
        } else if (1027 == buttonId) {
            this.handleLayoutSettingChanged(2);
        } else if (1026 == buttonId) {
            this.handleLayoutSettingChanged(0);
        } else if (1036 == buttonId) {
            this.handleLayoutSettingChanged(3);
        } else if (1031 == buttonId) {
            this.handleIconSizeChanged(b.getSelection());
        } else if (1028 == buttonId) {
            this.handleIconSizeChanged(b.getSelection());
        } else if (1030 == buttonId) {
            this.handleIconSizeChanged(b.getSelection());
        } else if (1029 == buttonId) {
            this.handleIconSizeChanged(b.getSelection());
        } else if (1038 == buttonId) {
            this.handleDefaultFontRequested();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void cacheSettings() {
        this.settings.put(CACHE_LAYOUT, this.prefs.getLayoutSetting());
        this.settings.put(CACHE_COLLAPSE, this.prefs.getAutoCollapseSetting());
        this.settings.put(CACHE_FONT, this.prefs.getFontData());
        this.settings.put(CACHE_DETAILS_ICON_SIZE, this.prefs.useLargeIcons(3));
        this.settings.put(CACHE_ICONS_ICON_SIZE, this.prefs.useLargeIcons(2));
        this.settings.put(CACHE_COLUMNS_ICON_SIZE, this.prefs.useLargeIcons(1));
        this.settings.put(CACHE_LIST_ICON_SIZE, this.prefs.useLargeIcons(0));
    }

    public boolean close() {
        if (this.getReturnCode() != 0) {
            this.handleCancelPressed();
        }
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(PaletteMessages.SETTINGS_DIALOG_TITLE);
        super.configureShell(newShell);
    }

    protected Button createButton(Composite parent, int id, String label, int stylebits, ImageDescriptor descriptor) {
        Button button = new Button(parent, stylebits);
        button.setText(label);
        button.setFont(parent.getFont());
        GridData data = new GridData(256);
        button.setLayoutData((Object)data);
        button.setData((Object)id);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PaletteSettingsDialog.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        this.widgets.put(id, button);
        if (descriptor != null) {
            button.setImage(new Image((Device)parent.getDisplay(), descriptor.getImageData(100)));
            button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Image img = ((Button)e.getSource()).getImage();
                    if (img != null && !img.isDisposed()) {
                        img.dispose();
                    }
                }
            });
        }
        return button;
    }

    protected Control createDrawerCollapseOptions(Composite container) {
        Composite composite = new Composite(container, 0);
        composite.setFont(container.getFont());
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setText(PaletteMessages.COLLAPSE_OPTIONS_TITLE);
        GridData data = new GridData();
        label.setLayoutData((Object)data);
        Button b = this.createButton(composite, 1033, PaletteMessages.COLLAPSE_ALWAYS_LABEL, 16, null);
        ((GridData)b.getLayoutData()).horizontalIndent = 5;
        b = this.createButton(composite, 1034, PaletteMessages.COLLAPSE_AS_NEEDED_LABEL, 16, null);
        ((GridData)b.getLayoutData()).horizontalIndent = 5;
        b = this.createButton(composite, 1032, PaletteMessages.COLLAPSE_NEVER_LABEL, 16, null);
        ((GridData)b.getLayoutData()).horizontalIndent = 5;
        b = null;
        int collapse = this.prefs.getAutoCollapseSetting();
        switch (collapse) {
            case 2: {
                b = this.getButton(1033);
                break;
            }
            case 0: {
                b = this.getButton(1034);
                break;
            }
            case 1: {
                b = this.getButton(1032);
            }
        }
        b.setSelection(true);
        return composite;
    }

    protected Control createDetailsOptions(Composite parent) {
        Control contents = this.createOptionsPage(parent, PaletteMessages.SETTINGS_OPTIONS_DETAILS, 1031);
        this.getButton(1031).setSelection(this.prefs.useLargeIcons(3));
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.horizontalSpacing = 0;
        layout.numColumns = 2;
        Control child = this.createFontSettings(composite);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.horizontalIndent = 5;
        child.setLayoutData((Object)data);
        Label label = new Label(composite, 258);
        data = new GridData(256);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        child = this.createLayoutSettings(composite);
        data = new GridData(1296);
        data.horizontalSpan = 2;
        data.horizontalIndent = 5;
        child.setLayoutData((Object)data);
        label = new Label(composite, 258);
        data = new GridData(256);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        child = this.createDrawerCollapseOptions(composite);
        data = new GridData(256);
        data.horizontalSpan = 2;
        data.horizontalIndent = 5;
        child.setLayoutData((Object)data);
        label = new Label(parent, 258);
        data = new GridData(256);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.cacheSettings();
        return composite;
    }

    protected Control createColumnsOptions(Composite parent) {
        Composite contents = (Composite)this.createOptionsPage(parent, PaletteMessages.SETTINGS_OPTIONS_COLUMNS, 1028);
        this.getButton(1028).setSelection(this.prefs.useLargeIcons(1));
        return contents;
    }

    protected Control createFontSettings(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setFont(parent.getFont());
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.fontName = new Label(container, 16448);
        this.fontName.setFont(container.getFont());
        GridData data = new GridData(1808);
        data.verticalSpan = 2;
        this.fontName.setLayoutData((Object)data);
        this.updateFontName();
        this.createButton(container, 1037, PaletteMessages.SETTINGS_FONT_CHANGE, 8, null);
        this.createButton(container, 1038, PaletteMessages.SETTINGS_DEFAULT_FONT, 8, null);
        return container;
    }

    protected Control createIconsOnlyOptions(Composite parent) {
        Control contents = this.createOptionsPage(parent, PaletteMessages.SETTINGS_OPTIONS_ICONS_ONLY, 1030);
        this.getButton(1030).setSelection(this.prefs.useLargeIcons(2));
        return contents;
    }

    protected Control createLayoutOptions(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setText(PaletteMessages.SETTINGS_LAYOUT_TITLE);
        GridData data = new GridData();
        label.setLayoutData((Object)data);
        Button b = null;
        int[] modes = this.prefs.getSupportedLayoutModes();
        int i = 0;
        while (i < modes.length) {
            switch (modes[i]) {
                case 1: {
                    b = this.createButton(composite, 1025, PaletteMessages.SETTINGS_COLUMNS_VIEW_LABEL, 16, null);
                    ((GridData)b.getLayoutData()).horizontalIndent = 5;
                    break;
                }
                case 0: {
                    b = this.createButton(composite, 1026, PaletteMessages.SETTINGS_LIST_VIEW_LABEL, 16, null);
                    ((GridData)b.getLayoutData()).horizontalIndent = 5;
                    break;
                }
                case 2: {
                    b = this.createButton(composite, 1027, PaletteMessages.SETTINGS_ICONS_VIEW_LABEL, 16, null);
                    ((GridData)b.getLayoutData()).horizontalIndent = 5;
                    break;
                }
                case 3: {
                    b = this.createButton(composite, 1036, PaletteMessages.SETTINGS_DETAILS_VIEW_LABEL, 16, null);
                    ((GridData)b.getLayoutData()).horizontalIndent = 5;
                }
            }
            ++i;
        }
        int layoutSetting = this.prefs.getLayoutSetting();
        switch (layoutSetting) {
            case 1: {
                b = this.getButton(1025);
                break;
            }
            case 2: {
                b = this.getButton(1027);
                break;
            }
            case 0: {
                b = this.getButton(1026);
                break;
            }
            case 3: {
                b = this.getButton(1036);
            }
        }
        b.setSelection(true);
        b.setFocus();
        return composite;
    }

    protected Control createLayoutSettings(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        Control layoutOptions = this.createLayoutOptions(composite);
        GridData data = new GridData(2);
        layoutOptions.setLayoutData((Object)data);
        this.book = new PageBook(composite, 0);
        this.book.setFont(composite.getFont());
        data = new GridData(1808);
        this.book.setLayoutData((Object)data);
        this.columnsPanel = this.createColumnsOptions((Composite)this.book);
        this.listPanel = this.createListOptions((Composite)this.book);
        this.iconsPanel = this.createIconsOnlyOptions((Composite)this.book);
        this.detailsPanel = this.createDetailsOptions((Composite)this.book);
        this.handleLayoutSettingChanged(this.prefs.getLayoutSetting());
        return composite;
    }

    protected Control createListOptions(Composite parent) {
        Control composite = this.createOptionsPage(parent, PaletteMessages.SETTINGS_OPTIONS_LIST, 1029);
        this.getButton(1029).setSelection(this.prefs.useLargeIcons(0));
        return composite;
    }

    protected Control createOptionsPage(Composite parent, String title, int buttonId) {
        Group contents = new Group(parent, 0);
        contents.setFont(parent.getFont());
        GridLayout layout = new GridLayout(1, false);
        contents.setLayout((Layout)layout);
        GridData data = new GridData(272);
        data.heightHint = 0;
        contents.setLayoutData((Object)data);
        contents.setText(title);
        Button b = this.createButton((Composite)contents, buttonId, PaletteMessages.SETTINGS_USE_LARGE_ICONS_LABEL, 32, null);
        b.setEnabled(false);
        return contents;
    }

    protected Button getButton(int id) {
        Button button = null;
        Widget widget = this.getWidget(id);
        if (widget instanceof Button) {
            button = (Button)widget;
        }
        return button;
    }

    protected Widget getWidget(int id) {
        Widget widget = (Widget)this.widgets.get(id);
        if (widget == null) {
            widget = super.getButton(id);
        }
        return widget;
    }

    protected void handleAutoCollapseSettingChanged(int newSetting) {
        this.prefs.setAutoCollapseSetting(newSetting);
    }

    protected void handleCancelPressed() {
        this.restoreSettings();
    }

    protected void handleChangeFontPressed() {
        FontDialog dialog = new FontDialog(this.getShell());
        FontData data = this.prefs.getFontData();
        dialog.setFontList(new FontData[]{data});
        data = dialog.open();
        if (data != null) {
            this.prefs.setFontData(data);
        }
        this.updateFontName();
    }

    protected void handleDefaultFontRequested() {
        this.prefs.setFontData(JFaceResources.getDialogFont().getFontData()[0]);
        this.updateFontName();
    }

    protected void handleIconSizeChanged(boolean selection) {
        this.prefs.setCurrentUseLargeIcons(selection);
    }

    protected void handleLayoutSettingChanged(int newSetting) {
        this.prefs.setLayoutSetting(newSetting);
        switch (newSetting) {
            case 1: {
                this.showLayoutOptionsPage(this.columnsPanel);
                break;
            }
            case 0: {
                this.showLayoutOptionsPage(this.listPanel);
                break;
            }
            case 2: {
                this.showLayoutOptionsPage(this.iconsPanel);
                break;
            }
            case 3: {
                this.showLayoutOptionsPage(this.detailsPanel);
                break;
            }
        }
    }

    protected void restoreSettings() {
        this.prefs.setFontData((FontData)this.settings.get(CACHE_FONT));
        this.prefs.setAutoCollapseSetting((Integer)this.settings.get(CACHE_COLLAPSE));
        this.prefs.setLayoutSetting((Integer)this.settings.get(CACHE_LAYOUT));
        this.prefs.setUseLargeIcons(3, (Boolean)this.settings.get(CACHE_DETAILS_ICON_SIZE));
        this.prefs.setUseLargeIcons(2, (Boolean)this.settings.get(CACHE_ICONS_ICON_SIZE));
        this.prefs.setUseLargeIcons(0, (Boolean)this.settings.get(CACHE_LIST_ICON_SIZE));
        this.prefs.setUseLargeIcons(1, (Boolean)this.settings.get(CACHE_COLUMNS_ICON_SIZE));
    }

    protected void showLayoutOptionsPage(Control page) {
        Point oldSize = this.getShell().getSize();
        this.book.showPage(page);
        Point newSize = this.getShell().computeSize(-1, -1, true);
        int x = newSize.x - oldSize.x;
        x = x < 0 ? 0 : x;
        int y = newSize.y - oldSize.y;
        int n = y = y < 0 ? 0 : y;
        if (x > 0 || y > 0) {
            this.getShell().setSize(oldSize.x + x, oldSize.y + y);
        }
    }

    protected void updateFontName() {
        String name = this.prefs.getFontData().equals((Object)JFaceResources.getDialogFont().getFontData()[0]) ? PaletteMessages.SETTINGS_WORKBENCH_FONT_LABEL : StringConverter.asString((FontData)this.prefs.getFontData());
        this.fontName.setText(PaletteMessages.SETTINGS_FONT_CURRENT + name);
    }
}

