/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chrome;

import com.github.kklisura.cdt.protocol.commands.Log;
import com.github.kklisura.cdt.protocol.commands.Page;
import com.github.kklisura.cdt.protocol.commands.Runtime;
import com.github.kklisura.cdt.protocol.events.log.EntryAdded;
import com.github.kklisura.cdt.protocol.events.runtime.ConsoleAPICalled;
import com.github.kklisura.cdt.protocol.events.runtime.ExceptionThrown;
import com.github.kklisura.cdt.protocol.types.log.LogEntry;
import com.github.kklisura.cdt.protocol.types.runtime.ExceptionDetails;
import com.github.kklisura.cdt.protocol.types.runtime.RemoteObject;
import com.github.kklisura.cdt.services.ChromeDevToolsService;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.sf.jasperreports.chrome.ChromePage;
import net.sf.jasperreports.chrome.ChromePageEvaluation;
import net.sf.jasperreports.chrome.ChromeServiceHandle;
import net.sf.jasperreports.chrome.PageOptions;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.apache.commons.logging.LogFactory;

public class BrowserService {
    private static final org.apache.commons.logging.Log log = LogFactory.getLog(BrowserService.class);
    public static final String PROPERTY_PAGE_TIMEOUT = "net.sf.jasperreports.chrome.page.timeout";
    private JRPropertiesUtil propertiesUtil;
    private ChromeServiceHandle chromeServiceHandle;

    public BrowserService(JasperReportsContext jasperReportsContext, ChromeServiceHandle chromeServiceHandle) {
        this.propertiesUtil = JRPropertiesUtil.getInstance(jasperReportsContext);
        this.chromeServiceHandle = chromeServiceHandle;
    }

    public <T> T evaluateInPage(String pageURL, PageOptions options, ChromePageEvaluation<T> evaluation) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("page evaluation at " + pageURL));
        }
        Object result = this.chromeServiceHandle.runInTab(devToolsService -> {
            try {
                Log pageLog = devToolsService.getLog();
                pageLog.onEntryAdded(this::pageLogEvent);
                pageLog.enable();
                Runtime runtime = devToolsService.getRuntime();
                runtime.onConsoleAPICalled(this::consoleEvent);
                runtime.onExceptionThrown(this::pageExceptionEvent);
                runtime.enable();
                CompletableFuture resultFuture = new CompletableFuture();
                ChromePage chromePage = new ChromePage((ChromeDevToolsService)devToolsService);
                Page page = devToolsService.getPage();
                page.onLoadEventFired(event -> {
                    try {
                        Object evaluationResult = evaluation.runInPage(chromePage);
                        resultFuture.complete(evaluationResult);
                    }
                    catch (Exception e) {
                        resultFuture.completeExceptionally(e);
                    }
                });
                page.enable();
                page.navigate(pageURL);
                Long timeout = this.pageTimeout(options);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("waiting for result, timeout " + timeout));
                }
                Object promiseResult = timeout == null || timeout <= 0L ? resultFuture.get() : resultFuture.get(timeout, TimeUnit.MILLISECONDS);
                return promiseResult;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new JRRuntimeException(e);
            }
        });
        if (log.isDebugEnabled()) {
            log.debug((Object)"page evaluation done");
        }
        return (T)result;
    }

    protected Long pageTimeout(PageOptions options) {
        String timeoutProp;
        Long timeout;
        Long l = timeout = options == null ? null : options.getTimeout();
        if (timeout == null && (timeoutProp = this.propertiesUtil.getProperty(PROPERTY_PAGE_TIMEOUT)) != null && !timeoutProp.trim().isEmpty()) {
            timeout = JRPropertiesUtil.asLong(timeoutProp);
        }
        return timeout;
    }

    protected void pageLogEvent(EntryAdded event) {
        LogEntry entry = event.getEntry();
        switch (entry.getLevel()) {
            case ERROR: {
                log.error((Object)("Page error: " + entry.getText()));
                break;
            }
            case WARNING: {
                log.warn((Object)("Page warning: " + entry.getText()));
                break;
            }
            case INFO: {
                log.info((Object)("Page info: " + entry.getText()));
                break;
            }
            default: {
                if (!log.isDebugEnabled()) break;
                log.info((Object)("Page message: " + entry.getText()));
            }
        }
    }

    protected void consoleEvent(ConsoleAPICalled event) {
        if (log.isDebugEnabled()) {
            StringBuilder eventString = new StringBuilder();
            eventString.append("Page console ");
            eventString.append(event.getType());
            eventString.append(": ");
            List args = event.getArgs();
            if (args != null) {
                for (RemoteObject argObject : args) {
                    eventString.append(argObject.getValue() == null ? argObject.getUnserializableValue() : argObject.getValue());
                    eventString.append(", ");
                }
            }
            log.debug((Object)eventString.substring(0, eventString.length() - 2));
        }
    }

    protected void pageExceptionEvent(ExceptionThrown event) {
        if (log.isWarnEnabled()) {
            ExceptionDetails exceptionDetails = event.getExceptionDetails();
            log.warn((Object)("Script exception: " + exceptionDetails.getText()));
            if (log.isDebugEnabled()) {
                RemoteObject exception = exceptionDetails.getException();
                String exceptionString = null;
                if (exception != null) {
                    if (exception.getDescription() != null) {
                        exceptionString = exception.getDescription();
                    } else if (exception.getValue() != null) {
                        exceptionString = exception.getValue().toString();
                    }
                }
                if (exceptionString != null) {
                    log.debug((Object)("Exception description: " + exceptionString));
                }
            }
        }
    }
}

